/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.security.Secured;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.OnEmptyResult;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.controller.items.magic.MagicList;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;

@Secured
public interface AbstractSelfItemsListController<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm<ID_TYPE>, ID_TYPE extends Serializable>
extends Serviceable<DB_TYPE, ID_TYPE>,
MagicList<DB_TYPE, ID_TYPE>,
Transformable<DB_TYPE, FORM> {
    @GetMapping(value={"/list"})
    @ResponseBody
    @WithRole
    default public ResponseEntity<Page<FORM>> getData(@RequestParam(value="limit", required=false) Integer limit, @RequestParam(value="page", required=false) Integer page) {
        AbstractDataFilter<DB_TYPE> specification = this.modifySearchSpecification((AbstractDataFilter)this.getContext().getDataFilterProvider().ofUser(this.getModel(), (Serializable)this.getContext().getCurrentUser()));
        Page<DB_TYPE> data = this.getService().find(specification, limit, page);
        List<Object> result = new ArrayList();
        if (data.isEmpty()) {
            result = this.onEmpty().doOnEmptyResults();
        } else {
            for (IDPresenter item : data) {
                result.add(this.toForm(item));
            }
        }
        PageImpl request = new PageImpl(result, (Pageable)PageRequest.of((int)page, (int)limit), (long)result.size());
        return ResponseEntity.ok((Object)request);
    }

    default public OnEmptyResult onEmpty() {
        return OnEmptyResult.INSTANCE;
    }

    default public AbstractDataFilter<DB_TYPE> modifySearchSpecification(AbstractDataFilter specification) {
        return specification;
    }
}

