/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.IDHolder;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.utils.bean_copier.AbstractTransformer;
import systems.dennis.shared.utils.bean_copier.BeanCopier;
import systems.dennis.shared.utils.bean_copier.DataTransformer;

public interface Transformable<DB_TYPE extends AbstractEntity, FORM extends AbstractForm> {
    default public DB_TYPE fromForm(FORM form) {
        Class<? extends AbstractEntity> cl = Serviceable.findDeclaredClass(this.getClass(), this.getClass().getAnnotation(DataRetrieverDescription.class)).model();
        return (DB_TYPE)this.afterTransformToDBType(this.getContext().getBean(BeanCopier.class).copy(form, cl), form);
    }

    default public FORM toForm(DB_TYPE model) {
        Class<? extends AbstractForm> cl = Serviceable.findDeclaredClass(this.getClass(), this.getClass().getAnnotation(DataRetrieverDescription.class)).form();
        AbstractForm res = this.getContext().getBean(BeanCopier.class).copy(model, cl);
        return (FORM)this.afterTransformToForm(res, model);
    }

    default public KeyValue transformValueToTargetType(KeyValue keyValue, Class<?> targetClass, Class<? extends AbstractForm> sourceClass) {
        Field editField = BeanCopier.findField(keyValue.getKey(), sourceClass);
        DataTransformer transformer = editField.getAnnotation(DataTransformer.class);
        Object transformableValue = keyValue.getValue();
        if (transformer != null) {
            AbstractTransformer converter = transformer.transFormWith().newInstance();
            transformableValue = IDHolder.class.isAssignableFrom(transformableValue.getClass()) ? converter.transform(transformableValue, transformer, ((IDHolder)transformableValue).getId().getClass(), this.getContext()) : converter.transform(transformableValue, transformer, targetClass, this.getContext());
        }
        return new KeyValue(keyValue.getKey(), transformableValue);
    }

    default public KeyValue transformValueToModelType(KeyValue keyValue) {
        DataRetrieverDescription description = this.getClassDescription();
        Class<? extends AbstractEntity> targetClass = description.model();
        Class<? extends AbstractForm> sourceClass = description.form();
        return this.transformValueToTargetType(keyValue, targetClass, sourceClass);
    }

    default public KeyValue transformValueToFormType(KeyValue keyValue) {
        DataRetrieverDescription description = this.getClassDescription();
        Class<? extends AbstractForm> targetClass = description.form();
        Class<? extends AbstractEntity> sourceClass = description.model();
        return this.transformValueToTargetType(keyValue, sourceClass, targetClass);
    }

    default public DataRetrieverDescription getClassDescription() {
        return this.getClass().getAnnotation(WebFormsSupport.class).value().getAnnotation(DataRetrieverDescription.class);
    }

    default public FORM afterTransformToForm(FORM ob, DB_TYPE origin) {
        return ob;
    }

    default public DB_TYPE afterTransformToDBType(DB_TYPE ob, FORM form) {
        return ob;
    }

    default public Page<Map<String, Object>> toFormPage(Page<DB_TYPE> page) {
        BeanCopier beanCopier = this.getContext().getBean(BeanCopier.class);
        Class<? extends AbstractForm> cl = Serviceable.findDeclaredClass(this.getClass(), this.getClass().getAnnotation(DataRetrieverDescription.class)).form();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < page.getContent().size(); ++i) {
            AbstractEntity model = (AbstractEntity)page.getContent().get(i);
            AbstractForm form = beanCopier.copy(model, cl);
            data.add(BeanCopier.values(form, model, this.getContext()));
        }
        return new PageImpl(data, page.getPageable(), page.getTotalElements());
    }

    public WebContext.LocalWebContext getContext();
}

