/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items.magic;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.AbstractFormModifier;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.forms.ValidateForm;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.controller.items.magic.UserSettingsFormInterface;
import systems.dennis.shared.entity.ExtendedForm;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.pojo_form.PojoForm;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.utils.GeneratedPojoForm;
import systems.dennis.shared.utils.PojoFormField;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

public interface MagicForm<FORM extends AbstractForm>
extends ValidateForm<FORM> {
    public static final Map<String, GeneratedPojoForm> pojoFormCache = new HashMap<String, GeneratedPojoForm>();

    @GetMapping(value={"/root/fetch/form"}, produces={"application/json"})
    @ResponseBody
    @WithRole
    default public GeneratedPojoForm fetchForm(HttpServletRequest request, @RequestParam(required=false) Serializable id) {
        GeneratedPojoForm res;
        DataRetrieverDescription descriptor = this.getClass().getAnnotation(WebFormsSupport.class).value().getAnnotation(DataRetrieverDescription.class);
        Class<? extends AbstractForm> formClass = descriptor.form();
        GeneratedPojoForm receivedForm = this.getPojoForm(formClass, id);
        Object changedForm = null;
        receivedForm.setAction(this.getClass().getAnnotation(RequestMapping.class).value()[0] + (id == null ? "/add" : "/edit"));
        receivedForm.setMethod(id == null ? HttpMethod.POST.name() : HttpMethod.PUT.name());
        if (this.getContext().getEnv("app.global.allow_form_change", true).booleanValue()) {
            UserSettingsFormInterface bean = this.getContext().getBean(UserSettingsFormInterface.class);
            bean.configForm(this.getContext(), receivedForm, formClass);
        }
        if (id != null) {
            this.setPojoFormValue(id, changedForm == null ? receivedForm : changedForm, this.getContext());
        }
        GeneratedPojoForm generatedPojoForm = res = changedForm == null ? receivedForm : changedForm;
        if (descriptor.formModifier() != AbstractFormModifier.class) {
            AbstractFormModifier modifier = null;
            try {
                modifier = descriptor.formModifier().newInstance();
                modifier.modify(this.getContext(), request, res);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res;
    }

    default public GeneratedPojoForm getPojoForm(Class<? extends AbstractForm> formClass, Serializable id) {
        if (pojoFormCache.containsKey(formClass.getName())) {
            GeneratedPojoForm res = pojoFormCache.get(formClass.getName());
            res = this.getContext().getBean(BeanCopier.class).clone(res);
            res.setFieldList(new ArrayList<PojoFormField>(res.getFieldList()));
            return res;
        }
        GeneratedPojoForm generatedPojoForm = new GeneratedPojoForm();
        PojoListView ann = formClass.getAnnotation(PojoListView.class);
        if (Objects.equals(ann.favoriteType(), "")) {
            generatedPojoForm.setObjectType(formClass.getSimpleName());
        } else {
            generatedPojoForm.setObjectType(ann.favoriteType());
        }
        if (formClass.getAnnotation(PojoForm.class) != null) {
            this.copyTo(formClass.getAnnotation(PojoForm.class), generatedPojoForm);
        } else {
            generatedPojoForm.setTitle(this.getContext().getScoped(this.getClass().getSimpleName()).toLowerCase());
            generatedPojoForm.setCommitText("global.submit");
            generatedPojoForm.setShowTitle(true);
        }
        BeanCopier.withEach(formClass, field -> this.getDescription(field, generatedPojoForm));
        pojoFormCache.put(formClass.getName(), generatedPojoForm);
        generatedPojoForm.getFieldList().sort(Comparator.comparing(PojoFormField::getOrder));
        return this.getContext().getBean(BeanCopier.class).clone(generatedPojoForm);
    }

    default public void setPojoFormValue(Serializable id, GeneratedPojoForm pojoForm, WebContext.LocalWebContext context) {
        Object service = ((Serviceable)((Object)this)).getService();
        DataRetrieverDescription descriptor = this.getClass().getAnnotation(WebFormsSupport.class).value().getAnnotation(DataRetrieverDescription.class);
        Object model = service.findByIdOrThrow((Serializable)id);
        Object form = ((Transformable)((Object)this)).toForm(model);
        pojoForm.setValue(BeanCopier.values(form, model, context));
        if (form instanceof ExtendedForm && descriptor.formModifier() != AbstractFormModifier.class) {
            AbstractFormModifier valueFetcherClass = descriptor.formModifier().newInstance();
            pojoForm.getFieldList().forEach(x -> {
                if (x.getCustomized() != null && x.getCustomized().booleanValue()) {
                    pojoForm.getValue().put(x.getField(), valueFetcherClass.getValue(pojoForm, x.getField(), model));
                }
            });
        }
    }

    default public void copyTo(PojoForm annotation, GeneratedPojoForm generatedPojoForm) {
        generatedPojoForm.setTitle(annotation.title().title());
        generatedPojoForm.setShowTitle(annotation.title().show());
        generatedPojoForm.setCommitText(annotation.commitButtonText());
    }

    default public void getDescription(Field x, GeneratedPojoForm generatedForm) {
        if (x.getAnnotation(FormTransient.class) == null && x.getAnnotation(PojoFormElement.class) != null && x.getAnnotation(PojoFormElement.class).available()) {
            generatedForm.getFieldList().add(PojoFormField.from(x, this.getContext()));
        }
    }
}

