/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items.magic;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.io.UrlResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import systems.dennis.shared.annotations.AbstractFormModifier;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.WebFormsSupport;
import systems.dennis.shared.annotations.security.WithRole;
import systems.dennis.shared.beans.OnApplicationStart;
import systems.dennis.shared.controller.DefaultFormDetailsContainer;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.Contextable;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.controller.items.magic.GeneratedReport;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.ExtendedForm;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.pojo_view.list.Remote;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.GeneratedPojoList;
import systems.dennis.shared.utils.PojoListField;
import systems.dennis.shared.utils.WebAction;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

public interface MagicList<T extends AbstractEntity<ID_TYPE>, ID_TYPE extends Serializable>
extends Contextable {
    public static final Map<String, GeneratedPojoList> pojoListCache = new HashMap<String, GeneratedPojoList>();

    @GetMapping(value={"/root/fetch/list", "/root/fetch/list/"}, produces={"application/json"})
    @ResponseBody
    @WithRole
    default public GeneratedPojoList fetchForm(HttpServletRequest request) {
        DataRetrieverDescription descriptor = this.getClass().getAnnotation(WebFormsSupport.class).value().getAnnotation(DataRetrieverDescription.class);
        Class<? extends AbstractForm> formClass = descriptor.form();
        GeneratedPojoList form = pojoListCache.containsKey(formClass.getName()) ? pojoListCache.get(formClass.getName()) : this.getPojoList(formClass);
        GeneratedPojoList res = this.getContext().getBean(BeanCopier.class).clone(form);
        res.setFields(new ArrayList<PojoListField>(res.getFields()));
        if (descriptor.formModifier() != AbstractFormModifier.class) {
            AbstractFormModifier modifier = null;
            try {
                modifier = descriptor.formModifier().newInstance();
                modifier.modify(this.getContext(), res, request);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res;
    }

    default public GeneratedPojoList getPojoList(Class<? extends AbstractForm> formClass) {
        GeneratedPojoList generatedPojoList = new GeneratedPojoList();
        if (formClass.getAnnotation(PojoListView.class) != null) {
            this.copyTo(formClass.getAnnotation(PojoListView.class), generatedPojoList, formClass);
        } else {
            generatedPojoList.setShowTitle(true);
            generatedPojoList.setObjectType(formClass.getSimpleName());
        }
        generatedPojoList.setTableTitle(this.getContext().getScoped(this.getClass().getSimpleName() + "_list").toLowerCase());
        generatedPojoList.setDefaultField(this.getDefaultField());
        BeanCopier.withEach(formClass, field -> this.getDescription(field, generatedPojoList));
        generatedPojoList.getFields().sort(Comparator.comparing(PojoListField::getOrder));
        generatedPojoList.setDefaultSorting(formClass.getConstructor(new Class[0]).newInstance(new Object[0]).defaultSearchOrderField());
        pojoListCache.put(formClass.getName(), generatedPojoList);
        return generatedPojoList;
    }

    default public String getDefaultField() {
        return "name";
    }

    @GetMapping(value={"/root/fetch/details/{id}", "/root/fetch/details/{id}/"}, produces={"application/json"})
    @WithRole
    default public DefaultFormDetailsContainer objectDetails(@PathVariable(value="id") ID_TYPE id, HttpServletRequest request) {
        Object bean = ((Serviceable)((Object)this)).getService();
        AbstractEntity res = (AbstractEntity)bean.findById((Serializable)id).orElseThrow(() -> ItemNotFoundException.fromId(id));
        DefaultFormDetailsContainer container = new DefaultFormDetailsContainer();
        container.setData(BeanCopier.values(((Transformable)((Object)this)).toForm(res), res, this.getContext()));
        container.setFields(this.fetchForm(request).getFields());
        return container;
    }

    @PostMapping(value={"/root/fetch/data", "/root/fetch/data/"}, produces={"application/json"}, consumes={"application/json"})
    @ResponseBody
    @WithRole
    default public Page<Map<String, Object>> fetchData(@RequestBody MagicRequest request) {
        AbstractService service = this.getContext().getBean(this.getClass().getAnnotation(WebFormsSupport.class).value());
        DataRetrieverDescription descriptor = this.getClass().getAnnotation(WebFormsSupport.class).value().getAnnotation(DataRetrieverDescription.class);
        Page res = service.search(request);
        ArrayList<Map<String, Object>> pageList = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < res.getContent().size(); ++i) {
            AbstractEntity model = (AbstractEntity)res.getContent().get(i);
            Object form = ((Transformable)((Object)this)).toForm(model);
            Map<String, Object> parcedFields = BeanCopier.values(form, model, this.getContext());
            pageList.add(parcedFields);
            if (!(form instanceof ExtendedForm) || descriptor.formModifier() == AbstractFormModifier.class) continue;
            try {
                AbstractFormModifier valueFetcherClass = descriptor.formModifier().newInstance();
                if (!valueFetcherClass.hasCustomValues(model)) continue;
                valueFetcherClass.appendToValues(parcedFields, model);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PageImpl(pageList, res.getPageable(), res.getTotalElements());
    }

    @PostMapping(value={"/root/download/data", "/root/download/data/"}, consumes={"application/json"})
    @ResponseBody
    @WithRole
    default public GeneratedReport download(@RequestBody MagicRequest request) {
        UrlResource generatedReportPath = this.getContext().getBean(this.getClass().getAnnotation(WebFormsSupport.class).value()).download(request);
        GeneratedReport report = new GeneratedReport();
        report.setPathToDownload(generatedReportPath.getFilename());
        report.setType("application/oset-stram");
        return report;
    }

    @GetMapping(value={"/root/download/data/{name}", "/root/download/data/{name}/"})
    @ResponseBody
    default public ResponseEntity<UrlResource> fetchFile(@PathVariable String name) {
        UrlResource generatedReportPath = this.getContext().getBean(this.getClass().getAnnotation(WebFormsSupport.class).value()).getInterNalResource(name);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + name + "\""})).body((Object)generatedReportPath);
    }

    default public void getDescription(Field f, GeneratedPojoList generatedPojoList) {
        PojoListViewField el = f.getAnnotation(PojoListViewField.class);
        PojoListField field = new PojoListField();
        if (el == null) {
            field.setOrder(0);
            field.setSearchType("text");
            field.setRemoteType("");
            field.setSearchable(false);
            field.setShowContent(true);
            field.setSortable(true);
            field.setType("text");
            field.setVisible(true);
            field.setGroup(null);
        } else {
            if (!el.available()) {
                return;
            }
            field.setOrder(el.order());
            field.setSearchType(el.remote().searchType());
            field.setActions(Arrays.stream(el.actions()).map(x -> new WebAction().from((UIAction)x)).collect(Collectors.toList()));
            field.setSearchable(el.searchable());
            field.setShowContent(el.showContent());
            field.setSortable(el.sortable());
            field.setFormat(el.format());
            field.setType(el.type());
            field.setGroup(el.group());
            if (!"".equals(el.remote().fetcher())) {
                field.setType("object_chooser");
                field.setSearchType("object_chooser");
            }
            if (!"".equals(el.remote().searchName())) {
                field.setSearchField(el.remote().searchField());
                field.setSearchName(el.remote().searchName());
            }
            if (!Remote.class.equals(el.remote().controller())) {
                field.setSearchName(OnApplicationStart.getSearchName(el.remote().controller()));
                field.setSearchField(OnApplicationStart.getFieldName(el.remote().controller()));
                if ("text".equals(el.type())) {
                    field.setType("object_chooser");
                    field.setRemoteType("object_chooser");
                } else {
                    field.setType(el.type());
                    field.setRemoteType(el.type());
                }
            }
            field.setVisible(el.visible());
            field.setRemoteType(el.remote().fetcher());
        }
        field.setField(f.getName());
        field.setTranslation(this.getContext().getScoped(f.getDeclaringClass().getSimpleName() + "." + f.getName()).toLowerCase());
        generatedPojoList.getFields().add(field);
    }

    default public void copyTo(PojoListView annotation, GeneratedPojoList generatedPojoList, Class<? extends AbstractForm> formClass) {
        generatedPojoList.setShowTitle(annotation.enableTitle());
        generatedPojoList.setSearchEnabled(annotation.enableSearching());
        generatedPojoList.setObjectType(annotation.favoriteType().isEmpty() ? formClass.getSimpleName() : annotation.favoriteType());
        generatedPojoList.setListActions(Arrays.asList(annotation.actions()));
        if (annotation.enableTitle() && !Objects.equals(annotation.title(), "")) {
            generatedPojoList.setTableTitle(annotation.title());
        } else {
            generatedPojoList.setTableTitle(this.getClass().getSimpleName() + ".list.title");
        }
    }
}

