/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.controller.items.magic;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.entity.IDHolder;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.OperationNotAllowedException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.service.AbstractService;

public class MagicQuery {
    public static final SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
    private String field;
    private String type;
    private Object value;
    private String searchName;
    private String dataType;

    public AbstractDataFilter toQuery(WebContext.LocalWebContext context) {
        Object provider = null;
        if (this.dataType.equals("checkbox")) {
            if (this.value.equals("null")) {
                return context.getDataFilterProvider().isNull(this.field);
            }
            this.value = Boolean.valueOf(this.value.toString());
        }
        if (this.dataType.equalsIgnoreCase("double")) {
            this.value = new BigDecimal(String.valueOf(this.value));
        }
        if (this.dataType.startsWith("date")) {
            this.value = this.value instanceof Date ? MagicQuery.trim((Date)this.value) : MagicQuery.trim(format.parse(((String)this.value).replaceAll("/", "."), new ParsePosition(0)));
        }
        if (this.dataType.equals("object_chooser") && this.value != null && !this.value.toString().trim().equals("") && !IDHolder.class.isAssignableFrom(this.value.getClass())) {
            try {
                this.value = context.getBean(SearchEntityApi.findServiceByType(this.searchName)).findById((Serializable)this.value).orElseThrow(() -> ItemNotFoundException.fromId(String.valueOf(this.value)));
            }
            catch (Exception e) {
                System.out.println(this.value);
            }
        }
        if (Objects.equals(this.type, "=")) {
            if (this.value == null || this.value.toString().isBlank()) {
                return context.getDataFilterProvider().isNull(this.field);
            }
            return context.getDataFilterProvider().eq(this.field, this.value);
        }
        if (Objects.equals(this.type, "!=")) {
            if (this.value == null || this.value.toString().isBlank()) {
                return context.getDataFilterProvider().notNull(this.field);
            }
            return context.getDataFilterProvider().notEq(this.field, this.value);
        }
        if (Objects.equals(this.type, ">=")) {
            return context.getDataFilterProvider().greatEQ(this.field, this.value);
        }
        if (Objects.equals(this.type, ">")) {
            return context.getDataFilterProvider().greater(this.field, this.value);
        }
        if (Objects.equals(this.type, "<=")) {
            return context.getDataFilterProvider().lessEQ(this.field, this.value);
        }
        if (Objects.equals(this.type, "<")) {
            return context.getDataFilterProvider().less(this.field, this.value);
        }
        if (Objects.equals(this.type, "%...%")) {
            return context.getDataFilterProvider().setInsensitive(true).contains(this.field, String.valueOf(this.value));
        }
        if (Objects.equals(this.type, "!%...%")) {
            return context.getDataFilterProvider().setInsensitive(true).notContains(this.field, String.valueOf(this.value));
        }
        if (Objects.equals(this.type, "%...")) {
            return context.getDataFilterProvider().setInsensitive(true).startsWith(this.field, String.valueOf(this.value));
        }
        if (Objects.equals(this.type, "!%...")) {
            return context.getDataFilterProvider().setInsensitive(true).notEndsWith(this.field, String.valueOf(this.value));
        }
        if (Objects.equals(this.type, "...%")) {
            return context.getDataFilterProvider().setInsensitive(true).endsWith(this.field, String.valueOf(this.value));
        }
        if (Objects.equals(this.type, "!...%")) {
            return context.getDataFilterProvider().setInsensitive(true).notEndsWith(this.field, String.valueOf(this.value));
        }
        if (Objects.equals(this.type, "is_null")) {
            return context.getDataFilterProvider().isNull(this.field);
        }
        if (Objects.equals(this.type, "not_null")) {
            return context.getDataFilterProvider().notNull(this.field);
        }
        if (Objects.equals(this.type, "in") && Objects.equals(this.dataType, "object_chooser")) {
            ArrayList<IDPresenter> sourceList = new ArrayList<IDPresenter>();
            if (this.value != null) {
                try {
                    AbstractService service = context.getBean(SearchEntityApi.findServiceByType(this.searchName));
                    for (Serializable integer : (List)this.value) {
                        try {
                            Serializable id = integer;
                            IDPresenter model = (IDPresenter)service.findById(context.getDataFilterProvider().getIdValue(id)).orElseThrow(() -> ItemNotFoundException.fromId(id));
                            sourceList.add(model);
                        }
                        catch (Exception e) {
                            System.out.println(this.value);
                        }
                    }
                }
                catch (Exception e) {
                    return context.getDataFilterProvider().iN(this.field, (List)this.value);
                }
            }
            return context.getDataFilterProvider().iN(this.field, sourceList);
        }
        if (Objects.equals(this.type, "not_in") && Objects.equals(this.dataType, "object_chooser")) {
            ArrayList<IDPresenter> sourceList = new ArrayList<IDPresenter>();
            if (this.value != null) {
                try {
                    AbstractService service = context.getBean(SearchEntityApi.findServiceByType(this.searchName));
                    for (Serializable idValue : (List)this.value) {
                        try {
                            IDPresenter model = (IDPresenter)service.findById(context.getDataFilterProvider().getIdValue(idValue)).orElseThrow(() -> ItemNotFoundException.fromId(idValue));
                            sourceList.add(model);
                        }
                        catch (Exception e) {
                            System.out.println(this.value);
                        }
                    }
                }
                catch (Exception e) {
                    return context.getDataFilterProvider().notIN(this.field, (List)this.value);
                }
            }
            return context.getDataFilterProvider().notIN(this.field, sourceList);
        }
        if (Objects.equals(this.type, "not_in") && (this.dataType.equals("referenced_id") || this.dataType.equals("referenced_ids"))) {
            return context.getDataFilterProvider().notIN(this.field, (List)this.value);
        }
        if (Objects.equals(this.type, "in") && (this.dataType.equals("referenced_id") || this.dataType.equals("referenced_ids"))) {
            return context.getDataFilterProvider().iN(this.field, (List)this.value);
        }
        throw new OperationNotAllowedException("Do not know operator send to query");
    }

    public static Date trim(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        return calendar.getTime();
    }

    public String getField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MagicQuery)) {
            return false;
        }
        MagicQuery other = (MagicQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$searchName = this.getSearchName();
        String other$searchName = other.getSearchName();
        if (this$searchName == null ? other$searchName != null : !this$searchName.equals(other$searchName)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MagicQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $searchName = this.getSearchName();
        result = result * 59 + ($searchName == null ? 43 : $searchName.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        return result;
    }

    public String toString() {
        return "MagicQuery(field=" + this.getField() + ", type=" + this.getType() + ", value=" + String.valueOf(this.getValue()) + ", searchName=" + this.getSearchName() + ", dataType=" + this.getDataType() + ")";
    }
}

