/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.importer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.env.Environment;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.items.Transformable;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.ImportFilter;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.importer.AbstractConditionalImport;
import systems.dennis.shared.importer.DataHolder;
import systems.dennis.shared.importer.Import;
import systems.dennis.shared.importer.MergeType;
import systems.dennis.shared.importer.PojoChecker;
import systems.dennis.shared.importer.PojoExistsChecker;
import systems.dennis.shared.importer.exception.ImportException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.Mapper;

public interface Importer<DB_TYPE extends IDPresenter<ID_TYPE>, FORM extends AbstractForm, ID_TYPE extends Serializable>
extends Transformable<DB_TYPE, FORM> {
    public static final Set<String> importedClasses = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public List<FORM> fetchAndStore(WebContext.LocalWebContext context) {
        String currentClass = this.getClass().getSimpleName();
        String propertiesKey = "global.app.lock_same_import_in_the_same_time";
        Boolean isParallelImportForbidden = this.getContext().getEnv(propertiesKey, true);
        try {
            if (importedClasses.contains(currentClass) && isParallelImportForbidden.booleanValue()) {
                throw new ImportException(" this class " + this.getClass().getSimpleName() + " is currently being imported");
            }
            importedClasses.add(currentClass);
            List<FORM> list = this.storeData(this.fetchData(context), context);
            return list;
        }
        finally {
            importedClasses.remove(currentClass);
        }
    }

    default public List<DB_TYPE> fetchData(final WebContext.LocalWebContext context) {
        List<Object> result;
        final Import imp = this.getClass().getAnnotation(Import.class);
        if (imp == null) {
            throw new ImportException("Annotation @Import is not set for the class " + String.valueOf(this.getClass()));
        }
        ObjectMapper mapper = this.getObjectMapper();
        Environment env = context.getBean(Environment.class);
        String property = env.getProperty(imp.pathKey());
        if ((property = this.modifyPath(property)) == null) {
            throw new ImportException("There is no property for path" + imp.pathKey());
        }
        HttpClient client = HttpClient.newBuilder().authenticator(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication((String)context.getEnv(imp.auth().login()), ((String)context.getEnv(imp.auth().password())).toCharArray());
            }
        }).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(property)).GET().build();
        HttpResponse<String> string = client.send(request, HttpResponse.BodyHandlers.ofString());
        String str = string.body();
        try {
            if (imp.dataHolder() != DataHolder.class) {
                for (String key : this.keys()) {
                    str = str.replaceAll("\"" + key + "\":", "\"" + this.keyToKey(key) + "\":");
                }
                result = ((DataHolder)mapper.readValue(str, imp.dataHolder())).getValue();
            } else {
                result = List.of((AbstractForm[])mapper.readValue(str, imp.returnType()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new ArrayList();
        }
        Class<? extends AbstractForm> formClas = this.getService().getClass().getAnnotation(DataRetrieverDescription.class).form();
        if (ImportFilter.class.isAssignableFrom(formClas)) {
            result = result.stream().filter(f -> {
                ImportFilter element = (ImportFilter)((Object)f);
                return element.accept();
            }).collect(Collectors.toList());
        }
        result = this.filterImport(result);
        result = result.stream().map(this::beforeItemImported).collect(Collectors.toList());
        this.preImport();
        PojoExistsChecker exPojoExistsChecker = imp.pojoChecker().pojoChecker().getConstructor(new Class[0]).newInstance(new Object[0]);
        boolean toCheck = imp.conditional() != AbstractConditionalImport.class;
        List subResult = null;
        if (toCheck) {
            AbstractConditionalImport obj = null;
            try {
                obj = imp.conditional().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new ImportException("There is no constructor for class: " + String.valueOf(this.getClass()) + ": " + String.valueOf(e));
            }
            AbstractConditionalImport finalObj = obj;
            subResult = result.stream().filter(form -> finalObj.satisfy(form, this.getContext())).map(this::fromForm).collect(Collectors.toList());
        } else {
            subResult = result.stream().map(this::fromForm).collect(Collectors.toList());
        }
        ArrayList<IDPresenter> endList = new ArrayList<IDPresenter>();
        for (IDPresenter item : subResult) {
            AbstractEntity existElement;
            if (imp.mergeType() == MergeType.ADD_NEW && imp.pojoChecker().pojoChecker().equals(PojoChecker.NO_CHECKER)) {
                endList.add(item);
            }
            if (imp.mergeType() == MergeType.UPDATE) {
                existElement = exPojoExistsChecker.exists(imp, item, context, imp.pojoChecker().params());
                if (existElement != null) {
                    item.setId(existElement.getId());
                }
                endList.add(item);
            }
            if (imp.mergeType() == MergeType.SKIP && (existElement = exPojoExistsChecker.exists(imp, item, context, imp.pojoChecker().params())) == null) {
                endList.add(item);
            }
            if (imp.mergeType() != MergeType.ADD_NEW) continue;
            endList.add(item);
        }
        return endList;
    }

    default public String modifyPath(String path) {
        return path;
    }

    default public ObjectMapper getObjectMapper() {
        return Mapper.mapper;
    }

    default public List<FORM> storeData(List<DB_TYPE> data, WebContext.LocalWebContext context) {
        ArrayList saved = new ArrayList();
        data.forEach(x -> {
            try {
                IDPresenter si = this.getService().save((IDPresenter)x);
                saved.add(this.toForm(si));
            }
            catch (Exception e) {
                this.getService().getLogger().error("Could not save item: " + x.asValue(), (Throwable)e);
            }
        });
        this.afterImport(saved, data);
        return saved;
    }

    default public void afterImport(List<FORM> saved, List<DB_TYPE> types) {
    }

    public <E, T extends AbstractService<DB_TYPE, ID_TYPE>> T getService();

    default public Map<String, String> keyReplacement() {
        return Collections.emptyMap();
    }

    default public String keyToKey(String value) {
        return this.keyReplacement().get(value);
    }

    default public Set<String> keys() {
        return this.keyReplacement().keySet();
    }

    default public FORM beforeItemImported(FORM item) {
        return item;
    }

    default public void preImport() {
    }

    default public List<FORM> filterImport(List<FORM> forms) {
        return forms;
    }
}

