/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.mock;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import systems.dennis.shared.mock.PathToDataConverter;

@RestController
@RequestMapping(value={"rest/api/2/search"})
public class MockService {
    private static final Logger log = LoggerFactory.getLogger(MockService.class);
    @Autowired(required=false)
    private PathToDataConverter converter;

    @GetMapping(produces={"application/json"})
    @ResponseBody
    public byte[] get(@RequestParam(value="jql") String query) throws IOException {
        if (!((String)query).contains(".")) {
            query = (String)query + ".json";
        }
        return this.getFile((String)query, null, HttpMethod.GET);
    }

    @GetMapping(produces={"text/html"})
    @ResponseBody
    public String string(@RequestParam(value="jql") String query) throws IOException {
        if (!((String)query).contains(".")) {
            query = (String)query + ".json";
        }
        return new String(this.getFile((String)query, null, HttpMethod.GET));
    }

    @RequestMapping(value={"/post/"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String stringPost(@RequestParam(value="jql", required=false) String query, @RequestBody String data) throws IOException {
        if (query != null && !((String)query).contains(".")) {
            query = (String)query + ".json";
        }
        return new String(this.getFile((String)query, data, HttpMethod.POST));
    }

    @ResponseBody
    public byte[] getFile(String query, Object data, HttpMethod method) throws IOException {
        byte[] byArray;
        block9: {
            if (this.converter != null) {
                log.info("**** Incoming path:" + query);
                query = this.converter.convert(query, method, data);
                log.info("**** out coming path: " + query + " method: " + String.valueOf(method) + " dat: " + String.valueOf(data));
            }
            log.info("Requested file: " + query);
            InputStream in = new ClassPathResource(query).getInputStream();
            try {
                byArray = IOUtils.toByteArray((InputStream)in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("can't fetch file " + query + " data " + String.valueOf(data) + " method: " + String.valueOf(method));
                    return new byte[0];
                }
            }
            in.close();
        }
        return byArray;
    }
}

