/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.pojo_form;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_form.PojoForm;
import systems.dennis.shared.pojo_view.UIAction;

public class FormDescription {
    private String method;
    private String title;
    private List<UIAction> actions;
    private boolean showTitle;
    private String titleClassName;
    private String commitButtonText;
    private String id;
    private String action;
    private String path;
    private String editTitle;

    public static FormDescription createDefault(Class<?> c, String path, WebContext.LocalWebContext context) {
        FormDescription description = new FormDescription();
        description.showTitle = true;
        description.setTitle("froms." + c.getSimpleName() + ".title");
        description.setEditTitle("froms." + c.getSimpleName() + "edit.title");
        description.setActions(Collections.emptyList());
        description.setTitleClassName("form_title");
        description.setMethod("POST");
        description.setId(c.getSimpleName());
        description.setCommitButtonText("submit");
        description.setPath(path);
        return description;
    }

    public static FormDescription from(PojoForm form, Class<?> c, String path, WebContext.LocalWebContext context) {
        FormDescription description = new FormDescription();
        description.setShowTitle(true);
        description.setTitle(form.title().title());
        description.setEditTitle(form.title().editTitle());
        description.setActions(Arrays.asList(form.formActions()));
        description.setId(form.id());
        description.setMethod(form.method());
        description.setShowTitle(form.title().show());
        description.setTitleClassName(form.title().className());
        description.setCommitButtonText(form.commitButtonText());
        description.setPath(path);
        description.setEditTitle(form.title().editTitle());
        return description;
    }

    public String getMethod() {
        return this.method;
    }

    public String getTitle() {
        return this.title;
    }

    public List<UIAction> getActions() {
        return this.actions;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public String getTitleClassName() {
        return this.titleClassName;
    }

    public String getCommitButtonText() {
        return this.commitButtonText;
    }

    public String getId() {
        return this.id;
    }

    public String getAction() {
        return this.action;
    }

    public String getPath() {
        return this.path;
    }

    public String getEditTitle() {
        return this.editTitle;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setActions(List<UIAction> actions) {
        this.actions = actions;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    public void setTitleClassName(String titleClassName) {
        this.titleClassName = titleClassName;
    }

    public void setCommitButtonText(String commitButtonText) {
        this.commitButtonText = commitButtonText;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setEditTitle(String editTitle) {
        this.editTitle = editTitle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormDescription)) {
            return false;
        }
        FormDescription other = (FormDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isShowTitle() != other.isShowTitle()) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<UIAction> this$actions = this.getActions();
        List<UIAction> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        String this$titleClassName = this.getTitleClassName();
        String other$titleClassName = other.getTitleClassName();
        if (this$titleClassName == null ? other$titleClassName != null : !this$titleClassName.equals(other$titleClassName)) {
            return false;
        }
        String this$commitButtonText = this.getCommitButtonText();
        String other$commitButtonText = other.getCommitButtonText();
        if (this$commitButtonText == null ? other$commitButtonText != null : !this$commitButtonText.equals(other$commitButtonText)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$editTitle = this.getEditTitle();
        String other$editTitle = other.getEditTitle();
        return !(this$editTitle == null ? other$editTitle != null : !this$editTitle.equals(other$editTitle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FormDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isShowTitle() ? 79 : 97);
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<UIAction> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        String $titleClassName = this.getTitleClassName();
        result = result * 59 + ($titleClassName == null ? 43 : $titleClassName.hashCode());
        String $commitButtonText = this.getCommitButtonText();
        result = result * 59 + ($commitButtonText == null ? 43 : $commitButtonText.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $editTitle = this.getEditTitle();
        result = result * 59 + ($editTitle == null ? 43 : $editTitle.hashCode());
        return result;
    }

    public String toString() {
        return "FormDescription(method=" + this.getMethod() + ", title=" + this.getTitle() + ", actions=" + String.valueOf(this.getActions()) + ", showTitle=" + this.isShowTitle() + ", titleClassName=" + this.getTitleClassName() + ", commitButtonText=" + this.getCommitButtonText() + ", id=" + this.getId() + ", action=" + this.getAction() + ", path=" + this.getPath() + ", editTitle=" + this.getEditTitle() + ")";
    }
}

