/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.pojo_form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.pojo_form.ValidationResult;

public class ValidationContext
implements Serializable {
    private boolean containsErrors;
    private Map<String, List<ValidationResult>> data = new HashMap<String, List<ValidationResult>>();

    public List<String> getValidationMessages() {
        ArrayList<String> res = new ArrayList<String>();
        for (List<ValidationResult> key : this.data.values()) {
            for (ValidationResult result : key) {
                if (result.getResult().booleanValue() || Strings.isBlank((String)result.getErrorMessage())) continue;
                res.add(result.getErrorMessage());
            }
        }
        return res;
    }

    public List<KeyValue> getFieldErrors() {
        ArrayList<KeyValue> res = new ArrayList<KeyValue>();
        for (String key : this.data.keySet()) {
            for (ValidationResult result : this.data.get(key)) {
                if (result.getResult().booleanValue() || Strings.isBlank((String)result.getErrorMessage())) continue;
                res.add(new KeyValue(key, result.getErrorMessage()));
            }
        }
        return res;
    }

    public boolean hasErrors(String field) {
        List<ValidationResult> results = this.data.get(field);
        if (results == null) {
            return true;
        }
        for (ValidationResult result : results) {
            if (result.getResult().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isContainsErrors() {
        return this.containsErrors;
    }

    public void setContainsErrors(boolean b) {
        this.containsErrors = b;
    }

    public void setData(Map<String, List<ValidationResult>> data) {
        this.data = data;
    }

    public Map<String, List<ValidationResult>> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationContext)) {
            return false;
        }
        ValidationContext other = (ValidationContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isContainsErrors() != other.isContainsErrors()) {
            return false;
        }
        Map<String, List<ValidationResult>> this$data = this.getData();
        Map<String, List<ValidationResult>> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isContainsErrors() ? 79 : 97);
        Map<String, List<ValidationResult>> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationContext(containsErrors=" + this.isContainsErrors() + ", data=" + String.valueOf(this.getData()) + ")";
    }
}

