/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.repository;

import java.io.Serializable;
import java.util.List;
import systems.dennis.shared.exceptions.StandardException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.utils.ApplicationContext;

public interface AbstractDataFilter<T extends IDPresenter<?>> {
    public static final String EQUALS_OPERATOR = "equals";
    public static final String STARTS_WITH_OPERATOR = "startsWith";
    public static final String NOT_STARTS_WITH_OPERATOR = "notStartsWith";
    public static final String ENDS_WITH_OPERATOR = "endsWith";
    public static final String NOT_ENDS_WITH_OPERATOR = "notEndsWith";
    public static final String MORE_THEN = "gt";
    public static final String LESS_THEN = "lt";
    public static final String LESS_EQUALS = "le";
    public static final String MORE_EQUALS = "ge";
    public static final String CONTAINS_OPERATOR = "contains";
    public static final String IN = "in";
    public static final String NOT_IN = "not_in";
    public static final String NOT_CONTAINS_OPERATOR = "_nc_";
    public static final String NOT_EMPTY = "_ne_";
    public static final String EMPTY = "_em_";
    public static final String NOT_EQUALS_OPERATOR = "notEquals";
    public static final String NULL_OPERATOR = "null";
    public static final String NOT_NULL_OPERATOR = "notNull";

    public <E extends AbstractDataFilter<T>> E operator(String var1, Object var2, String var3);

    public <E extends AbstractDataFilter<?>> E and(E var1);

    public <E extends AbstractDataFilter<?>> E or(E var1);

    default public <E extends AbstractDataFilter<T>> E eq(String field, Object value) {
        return this.operator(field, value, EQUALS_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E id(Object value) {
        return this.operator("id", value, EQUALS_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E idNot(Object value) {
        return this.operator("id", value, NOT_EQUALS_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E ofUser(Class<?> cl, Serializable user) {
        return this.operator(this.getUserField(cl), user, EQUALS_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E notEq(String field, Object value) {
        return this.operator(field, value, NOT_EQUALS_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E notIN(String field, List<?> value) {
        return this.operator(field, value, NOT_IN);
    }

    default public <E extends AbstractDataFilter<T>> E iN(String field, List<?> value) {
        return this.operator(field, value, IN);
    }

    default public <E extends AbstractDataFilter<T>> E contains(String field, String value) {
        return this.operator(field, value, CONTAINS_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E notContains(String field, String value) {
        return this.operator(field, value, NOT_CONTAINS_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E greater(String field, Object value) {
        return this.operator(field, value, MORE_THEN);
    }

    default public <E extends AbstractDataFilter<T>> E greatEQ(String field, Object value) {
        return this.operator(field, value, MORE_EQUALS);
    }

    default public <E extends AbstractDataFilter<T>> E lessEQ(String field, Object value) {
        return this.operator(field, value, LESS_EQUALS);
    }

    default public <E extends AbstractDataFilter<T>> E less(String field, Object value) {
        return this.operator(field, value, LESS_THEN);
    }

    default public <E extends AbstractDataFilter<T>> E startsWith(String field, String value) {
        return this.operator(field, value, STARTS_WITH_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E notStartsWith(String field, String value) {
        return this.operator(field, value, NOT_STARTS_WITH_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E endsWith(String field, String value) {
        return this.operator(field, value, ENDS_WITH_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E empty(String field) {
        return this.operator(field, null, EMPTY);
    }

    default public <E extends AbstractDataFilter<T>> E notEmpty(String field) {
        return this.operator(field, null, NOT_EMPTY);
    }

    default public <E extends AbstractDataFilter<T>> E isNull(String field) {
        return this.operator(field, null, NULL_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E notNull(String field) {
        return this.operator(field, null, NOT_NULL_OPERATOR);
    }

    default public <E extends AbstractDataFilter<T>> E notEndsWith(String field, String value) {
        return this.operator(field, value, NOT_ENDS_WITH_OPERATOR);
    }

    public <E extends AbstractDataFilter<T>> E comparasionType(Class<?> var1);

    public boolean isClosed();

    public String getField();

    default public <E extends AbstractDataFilter<T>> E empty() {
        return this.operator("id", null, NOT_EMPTY);
    }

    public AbstractDataFilter<T> setInsensitive(boolean var1);

    public AbstractDataFilter<T> setComplex(boolean var1);

    public AbstractDataFilter<T> setJoinOn(String var1);

    public Serializable getIdValue(Object var1);

    public boolean isEmpty();

    public String getOperator();

    public Object getValue();

    public Class<?> getFieldClass();

    public boolean isComplex();

    default public String getUserField(Class cl) {
        try {
            return ApplicationContext.CREATED_FIELDS_MAP.get(cl).getName();
        }
        catch (Exception e) {
            throw new StandardException((Serializable)((Object)cl.getName()), "global.app.field_is_not_able_to_be_found_as_creator");
        }
    }

    public String getOn();

    public <T> T getQueryRoot();
}

