/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.service;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.entity.Created;
import systems.dennis.shared.annotations.entity.CreatedBy;
import systems.dennis.shared.annotations.entity.PrimaryDateSetter;
import systems.dennis.shared.annotations.entity.Updated;
import systems.dennis.shared.annotations.entity.UpdatedBy;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.beans.IdToAuthorizationIdBean;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.QueryObject;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.StatusException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.repository.AbstractRepository;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

public abstract class AbstractPaginationService<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable>
extends ApplicationContext
implements AbstractService<DB_TYPE, ID_TYPE> {
    private static final Logger log = LoggerFactory.getLogger(AbstractPaginationService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private IdToAuthorizationIdBean id2id;

    public AbstractPaginationService(WebContext holder) {
        super(holder);
    }

    @Override
    public Logger getLogger() {
        return log;
    }

    @Override
    public boolean exists(DB_TYPE object) {
        return this.getRepository().existsById(object.getId());
    }

    @Override
    public DB_TYPE save(DB_TYPE model) {
        if (model.getId() != null && !((IDPresenter)model).isIdSet()) {
            model.setId(null);
        }
        if (model.getId() != null) {
            if (this.entityManager != null) {
                Session session = (Session)this.entityManager.unwrap(Session.class);
                session.evict(model);
            }
            return (DB_TYPE)this.edit((IDPresenter)this.getBean(BeanCopier.class).clone(model));
        }
        this.dateFieldByAnnotationFiller(model, Created.class);
        this.userFieldByAnnotationFiller(model, CreatedBy.class);
        this.preAdd(model);
        DB_TYPE res = this.getRepository().save(model);
        this.afterAdd(res);
        return res;
    }

    public void preFetchOriginal(DB_TYPE form) {
    }

    public AbstractDataFilter<DB_TYPE> getAdditionalCases(QueryObject<String> parameters) {
        return this.getFilterImpl().empty();
    }

    @Override
    public List<DB_TYPE> find() {
        return this.find(false);
    }

    public List<DB_TYPE> find(Boolean ignoreAdditionalSpecification) {
        ArrayList result = new ArrayList();
        if (ignoreAdditionalSpecification.booleanValue()) {
            this.getRepository().findAll().forEach(result::add);
        } else {
            this.getRepository().filteredData(this.getAdditionalSpecification()).forEach(result::add);
        }
        return result;
    }

    @Override
    public DB_TYPE edit(DB_TYPE model) throws ItemNotUserException, ItemNotFoundException, UnmodifiedItemSaveAttemptException, ItemDoesNotContainsIdValueException {
        Object editedId = model.getId();
        IDPresenter cloneOfOriginal = (IDPresenter)this.findByIdClone(editedId).orElseThrow(() -> ItemNotFoundException.fromId(editedId));
        if (Objects.equals(model, cloneOfOriginal)) {
            throw new UnmodifiedItemSaveAttemptException("Object not changed");
        }
        BeanCopier copier = this.getContext().getBean(BeanCopier.class);
        copier.copyTransientFields((AbstractEntity)model, cloneOfOriginal);
        this.dateFieldByAnnotationFiller(model, Updated.class);
        this.userFieldByAnnotationFiller(model, UpdatedBy.class);
        model = this.preEdit(model, cloneOfOriginal);
        DB_TYPE res = this.getRepository().save(model);
        this.saveVersionIfRequired(cloneOfOriginal, model);
        this.afterEdit(res, cloneOfOriginal);
        return res;
    }

    private void dateFieldByAnnotationFiller(DB_TYPE model, Class<?> annotation) {
        List<Field> fields = BeanCopier.findAnnotatedFields(model.getClass(), annotation, 0);
        for (Field field : fields) {
            try {
                BeanCopier.setFieldValue(model, field, this.getContext().getBean(PrimaryDateSetter.class).getNewDateValue(), true);
            }
            catch (Exception e) {
                this.getLogger().trace("cannot set field to default:" + field.getName());
            }
        }
    }

    private void userFieldByAnnotationFiller(DB_TYPE model, Class<?> annotation) {
        List<Field> fields = BeanCopier.findAnnotatedFields(model.getClass(), annotation, 0);
        for (Field field : fields) {
            try {
                if (field.getAnnotation(FormTransient.class) == null) {
                    throw new StatusException("global.form_transient_is_not_annotated_for_created_x_field", HttpStatus.BAD_REQUEST);
                }
                BeanCopier.setFieldValue(model, field, this.getBean(ISecurityUtils.class).getUserDataId(), true);
            }
            catch (Exception e) {
                this.getLogger().trace("cannot set field to default:" + field.getName());
            }
        }
    }

    public void afterEdit(DB_TYPE object, DB_TYPE original) {
    }

    @Override
    public KeyValue editField(ID_TYPE id, KeyValue keyValue) throws ItemNotUserException, ItemNotFoundException, UnmodifiedItemSaveAttemptException, ItemDoesNotContainsIdValueException, IllegalAccessException, InvocationTargetException {
        IDPresenter original = (IDPresenter)this.getRepository().findById(id).orElseThrow(() -> ItemNotFoundException.fromId(id));
        IDPresenter cloneOfOriginal = this.getContext().getBean(BeanCopier.class).clone(original);
        Field field = BeanCopier.findField(keyValue.getKey(), cloneOfOriginal.getClass());
        BeanCopier.setFieldValue((Object)cloneOfOriginal, field, keyValue.getValue());
        cloneOfOriginal = this.edit(cloneOfOriginal);
        Object valueFromModel = BeanCopier.readValue((Object)cloneOfOriginal, keyValue.getKey());
        return new KeyValue(keyValue.getKey(), valueFromModel);
    }

    @Override
    @Transactional
    public void deleteItems(List<ID_TYPE> ids) throws ItemNotUserException, ItemNotFoundException {
        ids.forEach(this::delete);
    }

    @Override
    public <F extends AbstractRepository<DB_TYPE, ID_TYPE>> F getRepository() {
        return (F)this.getContext().getBean(this.getClass().getAnnotation(DataRetrieverDescription.class).repo());
    }

    public <T extends ISecurityUtils> T getUtils() {
        return (T)this.getContext().getBean(ISecurityUtils.class);
    }

    @Override
    public boolean isIdSet(Long id) {
        return id != null && id > 0L;
    }
}

