/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.service;

import java.io.Serializable;
import org.springframework.data.domain.Page;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.service.AbstractService;

public interface AbstractParentalService<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable>
extends AbstractService<DB_TYPE, ID_TYPE> {
    default public String getParentField() {
        return "parent";
    }

    default public long countByParent(ID_TYPE id) {
        AbstractDataFilter specification = this.getFilterImpl().eq(this.getParentField(), this.findByIdOrThrow(this.updateId(id)));
        return this.getRepository().filteredCount(specification.and(this.getAdditionalSpecification()));
    }

    default public long countByRoot(DB_TYPE x) {
        AbstractDataFilter specification = this.getFilterImpl().eq(this.getParentField(), x);
        return this.count(specification.and(this.getAdditionalSpecification()));
    }

    default public Page<DB_TYPE> findRootElements(int page, int limit) {
        AbstractDataFilter specification = this.getFilterImpl().isNull(this.getParentField());
        return this.find(specification.and(this.getAdditionalSpecification()), limit, page);
    }

    default public Page<DB_TYPE> findByParent(ID_TYPE parentId, int limit, int page) {
        AbstractDataFilter specification = this.getFilterImpl().eq(this.getParentField(), this.findByIdOrThrow(this.updateId(parentId)));
        return this.find(specification.and(this.getAdditionalSpecification()), limit, page);
    }
}

