/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.springframework.core.io.UrlResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.annotations.NeverNullResponse;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.beans.AbstractDataFilterProvider;
import systems.dennis.shared.beans.AbstractEditDeleteHistoryBean;
import systems.dennis.shared.beans.IdValidator;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.forms.Serviceable;
import systems.dennis.shared.controller.items.magic.MagicQuery;
import systems.dennis.shared.controller.items.magic.MagicRequest;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.exceptions.ItemDoesNotContainsIdValueException;
import systems.dennis.shared.exceptions.ItemForAddContainsIdException;
import systems.dennis.shared.exceptions.ItemNotFoundException;
import systems.dennis.shared.exceptions.ItemNotUserException;
import systems.dennis.shared.exceptions.ItemWasDeletedException;
import systems.dennis.shared.exceptions.StandardException;
import systems.dennis.shared.exceptions.UnmodifiedItemSaveAttemptException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.pojo_view.list.PojoListView;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.repository.AbstractRepository;
import systems.dennis.shared.service.DeleteObject;
import systems.dennis.shared.utils.ErrorSupplier;
import systems.dennis.shared.utils.Supplier;
import systems.dennis.shared.utils.bean_copier.BeanCopier;
import systems.dennis.shared.utils.bean_copier.ObjectDefinition;

public interface AbstractService<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable>
extends DeleteObject<DB_TYPE, ID_TYPE> {
    public List<DB_TYPE> find();

    public DB_TYPE edit(DB_TYPE var1) throws ItemNotUserException, ItemNotFoundException, UnmodifiedItemSaveAttemptException, ItemDoesNotContainsIdValueException;

    public KeyValue editField(ID_TYPE var1, KeyValue var2) throws ItemNotUserException, ItemNotFoundException, UnmodifiedItemSaveAttemptException, ItemDoesNotContainsIdValueException, IllegalAccessException, InvocationTargetException;

    default public void delete(ID_TYPE id) throws ItemNotUserException, ItemNotFoundException {
        IDPresenter object = (IDPresenter)this.findById((Serializable)id).orElseThrow(() -> ItemNotFoundException.fromId(id));
        this.preDelete(object);
        object = this.delete(object, this);
        this.afterDelete(object);
        AbstractEditDeleteHistoryBean deleteHistory = this.getContext().getBean(AbstractEditDeleteHistoryBean.class);
        if (deleteHistory.isEnabled()) {
            deleteHistory.delete(id, object);
        }
    }

    public void deleteItems(List<ID_TYPE> var1) throws ItemNotUserException, ItemNotFoundException;

    default public DB_TYPE preEdit(DB_TYPE object, DB_TYPE original) throws UnmodifiedItemSaveAttemptException, ItemNotFoundException {
        return object;
    }

    default public void saveVersionIfRequired(DB_TYPE original, DB_TYPE object) {
        AbstractEditDeleteHistoryBean historyVersion = this.getContext().getBean(AbstractEditDeleteHistoryBean.class);
        try {
            if (historyVersion.isEnabled()) {
                historyVersion.edit(original, object);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Cannot save original version for object", (Throwable)e);
        }
    }

    default public DB_TYPE preAdd(DB_TYPE object) throws ItemForAddContainsIdException {
        return object;
    }

    @Override
    public WebContext.LocalWebContext getContext();

    default public Page<DB_TYPE> search(String field, String subtype, String value, int page, Integer size, Serializable[] additionalIds) {
        AbstractEntity model = (AbstractEntity)this.getModel().getConstructor(new Class[0]).newInstance(new Object[0]);
        return this.getRepository().filteredData(this.getSearchRequestAbstractDataFilter(field, value, this.updateIds(additionalIds)), (Pageable)PageRequest.of((int)page, (int)size, (Sort.Direction)((Sort.Direction)model.defaultSearchOrderField().getValue()), (String[])new String[]{model.defaultSearchOrderField().getKey()}));
    }

    default public AbstractDataFilter<DB_TYPE> getSearchRequestAbstractDataFilter(String field, String value, ID_TYPE[] additionalIds) {
        AbstractDataFilter<Object> spec = this.getFilterImpl().contains(field, value).setInsensitive(true);
        AbstractDataFilter<DB_TYPE> additionalAbstractDataFilter = this.getAdditionalSpecification();
        if (additionalAbstractDataFilter != null) {
            spec = spec.and(additionalAbstractDataFilter);
        }
        return spec;
    }

    @Override
    default public AbstractDataFilter<DB_TYPE> getFilterImpl() {
        return this.getContext().getBean(AbstractDataFilterProvider.class).get();
    }

    default public ID_TYPE[] updateIds(Object[] ids) {
        return (Serializable[])ids;
    }

    default public ID_TYPE updateId(Object id) {
        return (ID_TYPE)((Serializable)id);
    }

    default public Optional<DB_TYPE> filteredOne(AbstractDataFilter<?> one) {
        return this.getRepository().filteredOne(one.and(this.getAdditionalSpecification()));
    }

    default public Optional<DB_TYPE> filteredFirst(AbstractDataFilter<?> first) {
        return this.filteredFirst(first, Sort.unsorted());
    }

    default public Optional<DB_TYPE> filteredFirst(AbstractDataFilter<?> first, Sort sort) {
        return this.getRepository().filteredFirst(first.and(this.getAdditionalSpecification()), sort);
    }

    default public Page<DB_TYPE> filteredData(AbstractDataFilter<?> specification) {
        return this.getRepository().filteredData(specification.and(this.getAdditionalSpecification()));
    }

    default public Page<DB_TYPE> filteredData(AbstractDataFilter<?> specification, Pageable pageable) {
        return this.getRepository().filteredData(specification.and(this.getAdditionalSpecification()), pageable);
    }

    default public boolean exists(AbstractDataFilter<?> specification) {
        return this.filteredCount(specification) > 0L;
    }

    default public long filteredCount(AbstractDataFilter<?> filter) {
        return this.getRepository().filteredCount(filter.and(this.getAdditionalSpecification()));
    }

    default public void deleteData(AbstractDataFilter<?> filter) {
        this.getRepository().deleteData(filter.and(this.getAdditionalSpecification()));
    }

    default public DB_TYPE afterAdd(DB_TYPE object) {
        return object;
    }

    default public DB_TYPE preDelete(DB_TYPE object) {
        return object;
    }

    default public DB_TYPE afterDelete(DB_TYPE object) {
        return object;
    }

    @Override
    public Logger getLogger();

    public boolean exists(DB_TYPE var1);

    public DB_TYPE save(DB_TYPE var1);

    default public <F extends DB_TYPE> F findByIdOrThrow(ID_TYPE id) {
        IDPresenter res = (IDPresenter)this.findById((Serializable)id).orElseThrow(() -> ItemNotFoundException.fromId(id));
        return (F)res;
    }

    default public <T> T findById(ID_TYPE id, Supplier<T> orElse) {
        Optional<DB_TYPE> res = this.findById((Serializable)id);
        if (res.isEmpty()) {
            return orElse.onNull(id);
        }
        return (T)res.get();
    }

    default public AbstractDataFilter<DB_TYPE> getSelfCreatedItems(Serializable currentUser) {
        return this.getSelfCreatedItems(currentUser, true);
    }

    @NeverNullResponse(on="ignoreOnAdmin = false")
    default public AbstractDataFilter<DB_TYPE> getSelfCreatedItems(Serializable currentUser, boolean ignoreOnAdmin) {
        return this.getSelfCreatedItemsQuery(currentUser, ignoreOnAdmin);
    }

    default public AbstractDataFilter<DB_TYPE> getSelfCreatedItemsQuery(Serializable currentUser) {
        return this.getSelfCreatedItemsQuery(currentUser, true);
    }

    @NeverNullResponse(on="ignoreOnAdmin = false")
    default public AbstractDataFilter<DB_TYPE> getSelfCreatedItemsQuery(Serializable currentUser, boolean ignoreOnAdmin) {
        if (ignoreOnAdmin && this.getContext().getBean(ISecurityUtils.class).isAdmin()) {
            return this.getFilterImpl().notNull("id");
        }
        return this.getFilterImpl().eq("userDataId", currentUser);
    }

    default public Optional<DB_TYPE> findByIdClone(ID_TYPE id) {
        Optional<DB_TYPE> el = this.findById((Serializable)id);
        if (el.isPresent()) {
            return Optional.of(this.getContext().getBean(BeanCopier.class).clone((IDPresenter)el.get()));
        }
        return el;
    }

    default public boolean isIdSet(ID_TYPE id) {
        return this.getContext().getBean(IdValidator.class).isIdSet(id);
    }

    default public Optional<DB_TYPE> findById(Serializable idSerializable) {
        ID_TYPE id = this.updateId(idSerializable);
        if (!this.isIdSet(id)) {
            throw new StandardException((Serializable)((Object)String.valueOf(id)), "id.was.not_set.ty_find_by_id");
        }
        AbstractDataFilter<DB_TYPE> AbstractDataFilter2 = this.getAdditionalSpecification();
        Optional element = AbstractDataFilter2 != null ? this.getRepository().filteredOne(AbstractDataFilter2.and(this.getFilterImpl().id(id))) : this.getRepository().filteredOne(this.getFilterImpl().id(id));
        this.getContext().getBean(AbstractEditDeleteHistoryBean.class).throwIfDeleted(id, this.getModel());
        return element;
    }

    default public <T> T findById(ID_TYPE id, Exception els) {
        return this.findById(id, new ErrorSupplier(els));
    }

    default public <T extends AbstractEntity> Class<T> getModel() {
        DataRetrieverDescription res = Serviceable.findDeclaredClass(this.getClass(), this.getClass().getAnnotation(DataRetrieverDescription.class));
        return res.model();
    }

    default public <T extends AbstractForm> Class<T> getForm() {
        DataRetrieverDescription res = Serviceable.findDeclaredClass(this.getClass(), this.getClass().getAnnotation(DataRetrieverDescription.class));
        return res.form();
    }

    default public Page<DB_TYPE> find(Integer limit, Integer page) {
        return this.find(null, limit, page);
    }

    default public Page<DB_TYPE> find(AbstractDataFilter<DB_TYPE> searchAbstractDataFilter, Integer limit, Integer page) {
        PageRequest request = null;
        if (limit == null || limit == -1) {
            limit = 200;
        }
        request = PageRequest.of((int)Objects.requireNonNullElse(page, 0), (int)limit);
        if (searchAbstractDataFilter != null) {
            return this.getRepository().filteredData(searchAbstractDataFilter, (Pageable)request);
        }
        return this.getRepository().findAll((Pageable)request);
    }

    public <F extends AbstractRepository<DB_TYPE, ID_TYPE>> F getRepository();

    default public Page<DB_TYPE> search(MagicRequest request) {
        if (request.getQuery().isEmpty() && request.getCases().isEmpty() && this.getAdditionalSpecification() == null) {
            Page data = this.getRepository().findAll((Pageable)PageRequest.of((int)request.getPage(), (int)request.getLimit(), (Sort)this.createFromRequest(request)));
            return data;
        }
        AbstractDataFilter<DB_TYPE> finalAbstractDataFilter = this.prepareAbstractDataFilter(request);
        Page data = this.getRepository().filteredData(finalAbstractDataFilter, (Pageable)PageRequest.of((int)request.getPage(), (int)request.getLimit(), (Sort)this.createFromRequest(request)));
        return data;
    }

    default public AbstractDataFilter<DB_TYPE> prepareAbstractDataFilter(MagicRequest request) {
        AbstractDataFilter<DB_TYPE> modifyQuery = this.getAdditionalSpecification();
        for (MagicQuery magicQuery : request.getQuery()) {
            modifyQuery.and(this.modifyQuery(magicQuery.toQuery(this.getContext())));
        }
        for (AbstractDataFilter abstractDataFilter : request.getCases()) {
            modifyQuery.and(this.modifyQuery(abstractDataFilter));
        }
        return modifyQuery;
    }

    default public Sort createFromRequest(MagicRequest request) {
        if (request.getSort() == null || request.getSort().isEmpty()) {
            return Sort.unsorted();
        }
        ArrayList sorts = new ArrayList();
        request.getSort().stream().filter(Objects::nonNull).forEach(x -> sorts.add(Sort.by((Sort.Direction)(x.getDesc() != false ? Sort.Direction.DESC : Sort.Direction.ASC), (String[])new String[]{this.getFieldOrder(x.getField())})));
        if (sorts.size() > 1) {
            Sort firstSort = (Sort)sorts.get(0);
            for (int i = 1; i < sorts.size(); ++i) {
                firstSort = firstSort.and((Sort)sorts.get(i));
            }
            return firstSort;
        }
        return (Sort)sorts.get(0);
    }

    default public String getFieldOrder(String field) {
        try {
            Field sortField = BeanCopier.findField(field, this.getModel());
            if (AbstractForm.class.isAssignableFrom(sortField.getType())) {
                return sortField.getName() + "." + ((AbstractEntity)sortField.getType().getConstructor(new Class[0]).newInstance(new Object[0])).defaultSearchOrderField().getKey();
            }
            return field;
        }
        catch (Exception e) {
            return field;
        }
    }

    default public long count() {
        AbstractDataFilter<DB_TYPE> spec = this.getAdditionalSpecification();
        return this.getRepository().filteredCount(spec);
    }

    default public boolean isEmpty(AbstractDataFilter AbstractDataFilter2) {
        return this.count(AbstractDataFilter2) == 0L;
    }

    default public boolean isEmpty() {
        return this.count() == 0L;
    }

    default public long count(AbstractDataFilter<DB_TYPE> spec) {
        AbstractDataFilter<DB_TYPE> customAbstractDataFilter = this.getAdditionalSpecification();
        if (customAbstractDataFilter != null) {
            return this.getRepository().filteredCount(customAbstractDataFilter.and(spec));
        }
        return this.getRepository().filteredCount(spec);
    }

    /*
     * WARNING - void declaration
     */
    default public UrlResource download(MagicRequest request) {
        void var7_13;
        Page data;
        String path = this.getContext().getEnv("global.download.path", "./");
        AbstractDataFilter<DB_TYPE> customAbstractDataFilter = this.getAdditionalSpecification();
        if (request.getQuery().isEmpty()) {
            data = customAbstractDataFilter != null ? this.getRepository().filteredData(customAbstractDataFilter, (Pageable)PageRequest.of((int)0, (int)100000, (Sort)this.createFromRequest(request))) : this.getRepository().findAll((Pageable)PageRequest.of((int)0, (int)100000, (Sort)this.createFromRequest(request)));
        } else {
            AbstractDataFilter<DB_TYPE> filter = this.getFilterImpl().empty();
            for (MagicQuery magicQuery : request.getQuery()) {
                filter.and((AbstractDataFilter)magicQuery.toQuery(this.getContext()));
            }
            data = customAbstractDataFilter != null ? this.getRepository().filteredData(filter.and(customAbstractDataFilter), (Pageable)PageRequest.of((int)0, (int)100000, (Sort)this.createFromRequest(request))) : this.getRepository().filteredData(filter, (Pageable)PageRequest.of((int)0, (int)100000, (Sort)this.createFromRequest(request)));
        }
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        BeanCopier bc = this.getContext().getBean(BeanCopier.class);
        for (IDPresenter entity : data.getContent()) {
            AbstractForm form = (AbstractForm)bc.copy(entity, this.getForm());
            Map<String, Object> values = BeanCopier.values(form, entity, this.getContext());
            res.add(values);
        }
        if (res.size() == 0) {
            res.add(Collections.singletonMap("res", " ---- NO DATA ---"));
        }
        Object var7_10 = null;
        String fileName = path + UUID.randomUUID().toString() + ".xls";
        if (fileName.endsWith("xlsx")) {
            XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();
        } else {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
        }
        Sheet sheet = var7_13.createSheet("data");
        int headRow = 1;
        int cln = 0;
        Row row = sheet.createRow(headRow);
        for (String el : ((Map)res.get(0)).keySet()) {
            if ("action".equalsIgnoreCase(el)) continue;
            Cell cell0 = row.createCell(cln);
            cell0.setCellValue(el);
            ++cln;
        }
        int dataRow = 2;
        int datacln = 0;
        for (Map map : res) {
            Row datarow = sheet.createRow(dataRow);
            for (Object el : map.values()) {
                Cell cell = datarow.createCell(datacln);
                if (el instanceof ObjectDefinition) {
                    el = ((ObjectDefinition)el).getValue();
                }
                if (el == null) {
                    el = "";
                }
                if (el.toString().length() > 5000) {
                    el = String.valueOf(el).substring(0, 5000);
                }
                cell.setCellValue(String.valueOf(el));
                ++datacln;
            }
            datacln = 0;
            ++dataRow;
        }
        FileOutputStream fos = new FileOutputStream(fileName);
        var7_13.write((OutputStream)fos);
        fos.close();
        System.out.println(fileName + " written successfully");
        return new UrlResource(new File(fileName).toURI());
    }

    default public String getItemFavoriteType() {
        if (this.getForm().getAnnotation(PojoListView.class) == null) {
            return this.getForm().getSimpleName();
        }
        return this.getForm().getAnnotation(PojoListView.class).favoriteType();
    }

    default public UrlResource getInterNalResource(String resource) {
        String path = this.getContext().getEnv("global.download.path", "./");
        String fileName = path + resource;
        try {
            return new UrlResource(new File(fileName).toURI());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NeverNullResponse
    default public AbstractDataFilter<DB_TYPE> getAdditionalSpecification() {
        return this.getNotDeletedQuery();
    }

    default public void preSearch(String what, String type) {
    }

    default public boolean isPublicSearchEnabled() {
        return false;
    }

    default public void checkMy(DB_TYPE object) {
        this.getContext().getBean(ISecurityUtils.class).isMy(object);
    }

    @NeverNullResponse
    default public AbstractDataFilter<DB_TYPE> modifyQuery(AbstractDataFilter<DB_TYPE> query) {
        return query;
    }

    default public Boolean isObjectDeleted(DB_TYPE object) {
        int strategy = this.getDeleteStrategy(this.getClass());
        if (strategy == 2) {
            if (Objects.isNull(((IDPresenter)object).getHidden())) {
                return false;
            }
            return ((IDPresenter)object).getHidden();
        }
        try {
            this.findById((Serializable)object.getId());
            return false;
        }
        catch (ItemWasDeletedException e) {
            return true;
        }
    }

    default public boolean getByIdAndUserDataId(ID_TYPE id, Serializable currentUser) {
        try {
            if (this.getContext().getBean(ISecurityUtils.class).isAdmin()) {
                return true;
            }
            Object AbstractDataFilter2 = this.getFilterImpl().id(id).and(this.getFilterImpl().ofUser(this.getModel(), currentUser));
            return this.count((AbstractDataFilter<DB_TYPE>)AbstractDataFilter2) > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }
}

