/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.service;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import systems.dennis.shared.annotations.DeleteStrategy;
import systems.dennis.shared.annotations.security.ISecurityUtils;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.exceptions.DeleteNotPossibleException;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.repository.AbstractDataFilter;
import systems.dennis.shared.service.AbstractService;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

public interface DeleteObject<DB_TYPE extends IDPresenter<ID_TYPE>, ID_TYPE extends Serializable> {
    default public DB_TYPE delete(DB_TYPE object, AbstractService<DB_TYPE, ID_TYPE> service) {
        int strategy;
        if (this.getSelfOnly(service.getClass())) {
            service.getContext().getBean(ISecurityUtils.class).isMy(object);
        }
        if ((strategy = this.getDeleteStrategy(service.getClass())) == 1) {
            service.getRepository().delete(object);
            this.saveDeleteHistoryIfRequired(object, service);
            return object;
        }
        if (strategy == 2) {
            Field field = BeanCopier.findField(this.getDeleteField(this.getClass()), object.getClass());
            try {
                field.setAccessible(true);
                field.set(object, Boolean.TRUE);
                field.setAccessible(false);
                service.getRepository().save(object);
                this.saveDeleteHistoryIfRequired(object, service);
                return object;
            }
            catch (Exception e) {
                throw new DeleteNotPossibleException(e.getMessage(), (Serializable)((Object)field.getName()));
            }
        }
        throw new DeleteNotPossibleException("global.wrong.delete.strategy", Integer.valueOf(strategy));
    }

    default public void saveDeleteHistoryIfRequired(DB_TYPE deletedObject, AbstractService<DB_TYPE, ID_TYPE> service) {
    }

    public Logger getLogger();

    default public int getDeleteStrategy(Class<?> cl) {
        DeleteStrategy ann = cl.getAnnotation(DeleteStrategy.class);
        if (ann == null) {
            return 1;
        }
        return ann.value();
    }

    default public boolean getSelfOnly(Class<?> cl) {
        DeleteStrategy ann = cl.getAnnotation(DeleteStrategy.class);
        if (ann == null) {
            return false;
        }
        return ann.selfOnly();
    }

    default public String getDeleteField(Class<?> cl) {
        DeleteStrategy ann = cl.getAnnotation(DeleteStrategy.class);
        if (ann == null) {
            return "hidden";
        }
        return ann.field();
    }

    default public boolean getStoreHistoryRequired(Class<?> cl) {
        DeleteStrategy ann = cl.getAnnotation(DeleteStrategy.class);
        if (ann == null) {
            return false;
        }
        return ann.storeDeleteEventHistory();
    }

    default public AbstractDataFilter<DB_TYPE> getNotDeletedQuery() {
        Object query = this.getFilterImpl().notNull("id");
        if (this.getDeleteStrategy(this.getClass()) == 2) {
            query = query.and(this.getFilterImpl().notEq(this.getDeleteField(this.getClass()), true));
        }
        return query;
    }

    public AbstractDataFilter<DB_TYPE> getFilterImpl();

    public WebContext.LocalWebContext getContext();
}

