/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Objects;
import org.springframework.stereotype.Component;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.controller.SearchEntityApi;
import systems.dennis.shared.exceptions.TransformException;
import systems.dennis.shared.utils.ApplicationContext;

@Component
public class DataTypeConverter
extends ApplicationContext {
    public DataTypeConverter(WebContext context) {
        super(context);
    }

    public Object convert(String type, Object value, String searchName) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (type.equals("object_chooser")) {
            return this.convertToObjectSearch(value, searchName);
        }
        if (type.equals("checkbox")) {
            return this.convertToCheckbox(value);
        }
        if (type.equals("date")) {
            return this.convertToDate(value);
        }
        if (type.equals("integer")) {
            return this.convertToInteger(value);
        }
        return value;
    }

    private Object convertToObjectSearch(Object value, String searchName) {
        Long id = Long.valueOf(value.toString());
        return this.getBean(SearchEntityApi.findServiceByType(searchName)).findByIdOrThrow(id);
    }

    private Object convertToCheckbox(Object value) {
        return Boolean.valueOf(value.toString());
    }

    private Object convertToDate(Object value) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            return dateFormat.parse(value.toString());
        }
        catch (ParseException e) {
            throw new TransformException("failed_to_convert_date");
        }
    }

    private Object convertToInteger(Object value) {
        return Integer.valueOf(value.toString());
    }
}

