/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileHandler {
    public static String readFile(String fileName) throws IOException {
        File file = new File(fileName);
        return new String(Files.readAllBytes(Paths.get(URLDecoder.decode(file.getAbsolutePath(), StandardCharsets.UTF_8.toString()), new String[0])));
    }

    public static ByteArrayInputStream fileToByteArray(String path) throws IOException {
        return new ByteArrayInputStream(Files.readAllBytes(Paths.get(URLDecoder.decode(path, StandardCharsets.UTF_8.toString()), new String[0])));
    }

    public static void writeFile(String fileName, String newContent) throws IOException {
        File file = new File(fileName);
        Path path = Paths.get(URLDecoder.decode(file.getAbsolutePath(), StandardCharsets.UTF_8.toString()), new String[0]);
        Files.write(path, newContent.getBytes(), new OpenOption[0]);
    }

    public static boolean copyFilesRecursively(File toCopy, File destDir) throws IOException {
        assert (destDir.isDirectory());
        if (!toCopy.isDirectory()) {
            return FileHandler.copyFile(toCopy, new File(destDir, toCopy.getName()));
        }
        File newDestDir = new File(destDir, toCopy.getName());
        if (!newDestDir.exists() && !newDestDir.mkdir()) {
            return false;
        }
        File[] filesToCopy = toCopy.listFiles();
        if (filesToCopy != null) {
            for (File child : filesToCopy) {
                if (FileHandler.copyFilesRecursively(child, newDestDir)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(File toCopy, File destFile) throws IOException {
        return FileHandler.copyStream(new FileInputStream(toCopy), new FileOutputStream(destFile));
    }

    private static boolean copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = is.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
        is.close();
        os.close();
        return true;
    }
}

