/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import systems.dennis.shared.beans.OnApplicationStart;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.KeyValue;
import systems.dennis.shared.pojo_form.DataProvider;
import systems.dennis.shared.pojo_form.PojoFormElement;
import systems.dennis.shared.pojo_view.list.Remote;

public class PojoFormField
implements Serializable {
    private String translation;
    private Integer order;
    private String field;
    private String type;
    private boolean required;
    private boolean visible;
    private boolean showPlaceHolder;
    private boolean checked;
    private boolean format;
    private boolean showLabel;
    List<KeyValue> dataProviders = new ArrayList<KeyValue>();
    private String searchField;
    private String searchType;
    private String searchName;
    private String fieldNote;
    private String placeHolder;
    private String customName;
    private String remoteType;
    private String favType;
    private String subType;
    private String group;
    private String description;
    private Boolean customized = false;
    private boolean isId = false;

    public static PojoFormField from(Field x, WebContext.LocalWebContext context) {
        PojoFormField field = new PojoFormField();
        PojoFormElement element = x.getAnnotation(PojoFormElement.class);
        field.setField(x.getName());
        field.setTranslation(context.getScoped(x.getDeclaringClass().getSimpleName() + "." + x.getName()).toLowerCase());
        field.setOrder(element == null ? 0 : element.order());
        field.setRequired(element != null && element.required());
        field.setVisible(element != null && element.visible());
        field.setType(element == null ? "text" : element.type());
        field.setPlaceHolder(element == null ? "" : field.placeHolder);
        field.setShowPlaceHolder(element != null && element.showPlaceHolder());
        field.setChecked(element != null && element.checked().checked());
        field.setShowLabel(element == null || element.showLabel());
        field.setGroup(null);
        field.setDescription(element == null || Objects.equals(element.description(), "no_description") ? null : element.description());
        field.setId(element != null && element.ID());
        if (element != null) {
            field.setCustomName(element.group());
            field.setFavType(element.type());
            field.setRemoteType(element.remote().fetcher());
            field.setSearchType(element.remote().searchType());
            field.setSearchName(element.remote().searchName());
            field.setSearchField(element.remote().searchField());
            if (!Remote.class.equals(element.remote().controller())) {
                field.setSearchName(OnApplicationStart.getSearchName(element.remote().controller()));
                field.setSearchField(OnApplicationStart.getFieldName(element.remote().controller()));
                if ("text".equals(element.type())) {
                    field.setType("object_chooser");
                    field.setRemoteType("object_chooser");
                } else {
                    field.setType(element.type());
                    field.setRemoteType(element.type());
                }
            }
            field.setFieldNote(element.fieldNote());
            field.setGroup(element.group());
            if (element.dataProvider() != null && element.dataProvider() != DataProvider.class) {
                ArrayList items = element.dataProvider().getConstructor(new Class[0]).newInstance(new Object[0]).getItems(context);
                field.getDataProviders().addAll(items);
            }
        }
        return field;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(((PojoFormField)o).getField(), this.getField());
    }

    public String getTranslation() {
        return this.translation;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowPlaceHolder() {
        return this.showPlaceHolder;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isFormat() {
        return this.format;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public List<KeyValue> getDataProviders() {
        return this.dataProviders;
    }

    public String getSearchField() {
        return this.searchField;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public String getFieldNote() {
        return this.fieldNote;
    }

    public String getPlaceHolder() {
        return this.placeHolder;
    }

    public String getCustomName() {
        return this.customName;
    }

    public String getRemoteType() {
        return this.remoteType;
    }

    public String getFavType() {
        return this.favType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getCustomized() {
        return this.customized;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setTranslation(String translation) {
        this.translation = translation;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setShowPlaceHolder(boolean showPlaceHolder) {
        this.showPlaceHolder = showPlaceHolder;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setDataProviders(List<KeyValue> dataProviders) {
        this.dataProviders = dataProviders;
    }

    public void setSearchField(String searchField) {
        this.searchField = searchField;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public void setFieldNote(String fieldNote) {
        this.fieldNote = fieldNote;
    }

    public void setPlaceHolder(String placeHolder) {
        this.placeHolder = placeHolder;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void setRemoteType(String remoteType) {
        this.remoteType = remoteType;
    }

    public void setFavType(String favType) {
        this.favType = favType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCustomized(Boolean customized) {
        this.customized = customized;
    }

    public void setId(boolean isId) {
        this.isId = isId;
    }

    public String toString() {
        return "PojoFormField(translation=" + this.getTranslation() + ", order=" + this.getOrder() + ", field=" + this.getField() + ", type=" + this.getType() + ", required=" + this.isRequired() + ", visible=" + this.isVisible() + ", showPlaceHolder=" + this.isShowPlaceHolder() + ", checked=" + this.isChecked() + ", format=" + this.isFormat() + ", showLabel=" + this.isShowLabel() + ", dataProviders=" + String.valueOf(this.getDataProviders()) + ", searchField=" + this.getSearchField() + ", searchType=" + this.getSearchType() + ", searchName=" + this.getSearchName() + ", fieldNote=" + this.getFieldNote() + ", placeHolder=" + this.getPlaceHolder() + ", customName=" + this.getCustomName() + ", remoteType=" + this.getRemoteType() + ", favType=" + this.getFavType() + ", subType=" + this.getSubType() + ", group=" + this.getGroup() + ", description=" + this.getDescription() + ", customized=" + this.getCustomized() + ", isId=" + this.isId() + ")";
    }
}

