/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.utils.PojoHelper;

public class PojoHeader
implements Comparable<PojoHeader> {
    private String header;
    private String translation;
    private Integer order;
    private String field;
    private String format;
    private Class<?> dataConverter;
    private UIAction[] actions;
    private Boolean sortable;
    private Boolean searchable;
    private boolean visible;
    private String searchType;
    boolean showContent;
    private String width;

    public static List<String> get(List<PojoHeader> headers, WebContext.LocalWebContext context, boolean toTranslate) {
        if (headers == null) {
            return Collections.emptyList();
        }
        PojoHelper.sortData(headers);
        ArrayList<String> list = new ArrayList<String>();
        for (PojoHeader pojoHeader : headers) {
            list.add(PojoHeader.get(pojoHeader, context, toTranslate));
        }
        return list;
    }

    public static String get(PojoHeader header, WebContext.LocalWebContext context, boolean toTranslate) {
        if (header == null) {
            return "";
        }
        if (toTranslate) {
            return header.header;
        }
        header.setTranslation(header.header);
        return header.header;
    }

    @Override
    public int compareTo(PojoHeader o) {
        if (o == null) {
            return 0;
        }
        return this.order == null ? 0 : this.order.compareTo(o.order);
    }

    public static PojoHeaderBuilder builder() {
        return new PojoHeaderBuilder();
    }

    public String getHeader() {
        return this.header;
    }

    public String getTranslation() {
        return this.translation;
    }

    public Integer getOrder() {
        return this.order;
    }

    public String getField() {
        return this.field;
    }

    public String getFormat() {
        return this.format;
    }

    public Class<?> getDataConverter() {
        return this.dataConverter;
    }

    public UIAction[] getActions() {
        return this.actions;
    }

    public Boolean getSortable() {
        return this.sortable;
    }

    public Boolean getSearchable() {
        return this.searchable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public boolean isShowContent() {
        return this.showContent;
    }

    public String getWidth() {
        return this.width;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setTranslation(String translation) {
        this.translation = translation;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setDataConverter(Class<?> dataConverter) {
        this.dataConverter = dataConverter;
    }

    public void setActions(UIAction[] actions) {
        this.actions = actions;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public void setShowContent(boolean showContent) {
        this.showContent = showContent;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PojoHeader)) {
            return false;
        }
        PojoHeader other = (PojoHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isShowContent() != other.isShowContent()) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Boolean this$sortable = this.getSortable();
        Boolean other$sortable = other.getSortable();
        if (this$sortable == null ? other$sortable != null : !((Object)this$sortable).equals(other$sortable)) {
            return false;
        }
        Boolean this$searchable = this.getSearchable();
        Boolean other$searchable = other.getSearchable();
        if (this$searchable == null ? other$searchable != null : !((Object)this$searchable).equals(other$searchable)) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        String this$translation = this.getTranslation();
        String other$translation = other.getTranslation();
        if (this$translation == null ? other$translation != null : !this$translation.equals(other$translation)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        Class<?> this$dataConverter = this.getDataConverter();
        Class<?> other$dataConverter = other.getDataConverter();
        if (this$dataConverter == null ? other$dataConverter != null : !this$dataConverter.equals(other$dataConverter)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getActions(), other.getActions())) {
            return false;
        }
        String this$searchType = this.getSearchType();
        String other$searchType = other.getSearchType();
        if (this$searchType == null ? other$searchType != null : !this$searchType.equals(other$searchType)) {
            return false;
        }
        String this$width = this.getWidth();
        String other$width = other.getWidth();
        return !(this$width == null ? other$width != null : !this$width.equals(other$width));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PojoHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isShowContent() ? 79 : 97);
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Boolean $sortable = this.getSortable();
        result = result * 59 + ($sortable == null ? 43 : ((Object)$sortable).hashCode());
        Boolean $searchable = this.getSearchable();
        result = result * 59 + ($searchable == null ? 43 : ((Object)$searchable).hashCode());
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        String $translation = this.getTranslation();
        result = result * 59 + ($translation == null ? 43 : $translation.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        Class<?> $dataConverter = this.getDataConverter();
        result = result * 59 + ($dataConverter == null ? 43 : $dataConverter.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getActions());
        String $searchType = this.getSearchType();
        result = result * 59 + ($searchType == null ? 43 : $searchType.hashCode());
        String $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : $width.hashCode());
        return result;
    }

    public String toString() {
        return "PojoHeader(header=" + this.getHeader() + ", translation=" + this.getTranslation() + ", order=" + this.getOrder() + ", field=" + this.getField() + ", format=" + this.getFormat() + ", dataConverter=" + String.valueOf(this.getDataConverter()) + ", actions=" + Arrays.deepToString(this.getActions()) + ", sortable=" + this.getSortable() + ", searchable=" + this.getSearchable() + ", visible=" + this.isVisible() + ", searchType=" + this.getSearchType() + ", showContent=" + this.isShowContent() + ", width=" + this.getWidth() + ")";
    }

    public PojoHeader() {
    }

    public PojoHeader(String header, String translation, Integer order, String field, String format, Class<?> dataConverter, UIAction[] actions, Boolean sortable, Boolean searchable, boolean visible, String searchType, boolean showContent, String width) {
        this.header = header;
        this.translation = translation;
        this.order = order;
        this.field = field;
        this.format = format;
        this.dataConverter = dataConverter;
        this.actions = actions;
        this.sortable = sortable;
        this.searchable = searchable;
        this.visible = visible;
        this.searchType = searchType;
        this.showContent = showContent;
        this.width = width;
    }

    public static class PojoHeaderBuilder {
        private String header;
        private String translation;
        private Integer order;
        private String field;
        private String format;
        private Class<?> dataConverter;
        private UIAction[] actions;
        private Boolean sortable;
        private Boolean searchable;
        private boolean visible;
        private String searchType;
        private boolean showContent;
        private String width;

        PojoHeaderBuilder() {
        }

        public PojoHeaderBuilder header(String header) {
            this.header = header;
            return this;
        }

        public PojoHeaderBuilder translation(String translation) {
            this.translation = translation;
            return this;
        }

        public PojoHeaderBuilder order(Integer order) {
            this.order = order;
            return this;
        }

        public PojoHeaderBuilder field(String field) {
            this.field = field;
            return this;
        }

        public PojoHeaderBuilder format(String format) {
            this.format = format;
            return this;
        }

        public PojoHeaderBuilder dataConverter(Class<?> dataConverter) {
            this.dataConverter = dataConverter;
            return this;
        }

        public PojoHeaderBuilder actions(UIAction[] actions) {
            this.actions = actions;
            return this;
        }

        public PojoHeaderBuilder sortable(Boolean sortable) {
            this.sortable = sortable;
            return this;
        }

        public PojoHeaderBuilder searchable(Boolean searchable) {
            this.searchable = searchable;
            return this;
        }

        public PojoHeaderBuilder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public PojoHeaderBuilder searchType(String searchType) {
            this.searchType = searchType;
            return this;
        }

        public PojoHeaderBuilder showContent(boolean showContent) {
            this.showContent = showContent;
            return this;
        }

        public PojoHeaderBuilder width(String width) {
            this.width = width;
            return this;
        }

        public PojoHeader build() {
            return new PojoHeader(this.header, this.translation, this.order, this.field, this.format, this.dataConverter, this.actions, this.sortable, this.searchable, this.visible, this.searchType, this.showContent, this.width);
        }

        public String toString() {
            return "PojoHeader.PojoHeaderBuilder(header=" + this.header + ", translation=" + this.translation + ", order=" + this.order + ", field=" + this.field + ", format=" + this.format + ", dataConverter=" + String.valueOf(this.dataConverter) + ", actions=" + Arrays.deepToString(this.actions) + ", sortable=" + this.sortable + ", searchable=" + this.searchable + ", visible=" + this.visible + ", searchType=" + this.searchType + ", showContent=" + this.showContent + ", width=" + this.width + ")";
        }
    }
}

