/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.ui.Model;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.pojo_view.DefaultDataConverter;
import systems.dennis.shared.pojo_view.UIAction;
import systems.dennis.shared.pojo_view.list.PojoListViewField;
import systems.dennis.shared.utils.PojoHeader;
import systems.dennis.shared.utils.bean_copier.BeanCopier;

public class PojoHelper {
    private static final Logger log = LoggerFactory.getLogger(PojoHelper.class);

    public static List<PojoHeader> getHeaders(Class<?> jobReportClass) {
        Field[] superDeclared;
        ArrayList<PojoHeader> headers = new ArrayList<PojoHeader>();
        Field[] declaredFields = jobReportClass.getDeclaredFields();
        for (Field field : superDeclared = jobReportClass.getSuperclass().getDeclaredFields()) {
            PojoHelper.getHeadersFromField(field, headers);
        }
        for (Field field : declaredFields) {
            PojoHelper.getHeadersFromField(field, headers);
        }
        return headers;
    }

    private static void getHeadersFromField(Field field, List<PojoHeader> headers) {
        PojoListViewField pojoListViewField = field.getAnnotation(PojoListViewField.class);
        if (pojoListViewField != null) {
            String pojoFieldWidth = pojoListViewField.widthInTable();
            headers.add(new PojoHeader(field.getName(), null, pojoListViewField.order(), field.getName(), pojoListViewField.format(), pojoListViewField.dataConverter(), PojoHelper.getActions(pojoListViewField), pojoListViewField.sortable(), pojoListViewField.searchable(), pojoListViewField.visible(), pojoListViewField.remote().searchType(), pojoListViewField.showContent(), pojoFieldWidth));
        } else if (!Modifier.isStatic(field.getModifiers())) {
            headers.add(new PojoHeader(field.getName(), null, 0, field.getName(), "", DefaultDataConverter.class, null, true, true, true, "text", true, "inherit"));
        }
    }

    private static UIAction[] getActions(PojoListViewField pojoListViewField) {
        return pojoListViewField.actions();
    }

    public static Object addData(PojoHeader header, Object dataObject, WebContext.LocalWebContext context) {
        String field = header.getField();
        Class<?> cz = dataObject.getClass();
        try {
            Field f = BeanCopier.findField(field, cz);
            f.setAccessible(true);
            Object value = f.get(dataObject);
            if (header.getDataConverter() != DefaultDataConverter.class) {
                DefaultDataConverter converter = (DefaultDataConverter)header.getDataConverter().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                value = converter.convert(value, dataObject, context);
            }
            f.setAccessible(false);
            return value;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Map<String, Object>> toMap(List<PojoHeader> headers, Page<?> values, WebContext.LocalWebContext context, Model model) {
        ArrayList<Map<String, Object>> listResult = new ArrayList<Map<String, Object>>();
        PojoHelper.sortData(headers);
        for (Object object : values) {
            TreeMap<String, Object> result = new TreeMap<String, Object>();
            for (PojoHeader header : headers) {
                result.put(PojoHeader.get(header, context, false), PojoHelper.addData(header, object, context));
            }
            listResult.add(result);
        }
        return listResult;
    }

    public static void sortData(List<PojoHeader> headers) {
        headers.sort(Comparator.comparing(PojoHeader::getOrder));
    }
}

