/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import systems.dennis.shared.exceptions.StandardException;

public class TSDate
implements Serializable {
    public static final String CURRENT_TIME_ZONE = Calendar.getInstance().getTimeZone().getID();
    private Date date;
    private Long milliseconds;
    private String zone;
    private String template;
    @JsonIgnore
    private Calendar calendar;

    public static TSDate of(Long date) {
        return new TSDate(TSDate.ofDate(date));
    }

    private static Calendar ofDate(Long date) {
        if (date == null) {
            return null;
        }
        Calendar res = Calendar.getInstance();
        res.setTimeInMillis(date);
        return res;
    }

    public static TSDate of(Date date) {
        if (date == null) {
            return null;
        }
        return TSDate.of(date.getTime());
    }

    public TSDate() {
        this(Calendar.getInstance());
    }

    public TSDate(Calendar calendar) {
        if (calendar == null) {
            throw new StandardException((Serializable)((Object)""), "calendar_has_no_data");
        }
        this.date = calendar.getTime();
        this.zone = CURRENT_TIME_ZONE;
        this.milliseconds = this.date.getTime();
    }

    public static TSDate now() {
        return TSDate.of(new Date());
    }

    public TSDate ts(String timeZone) {
        this.zone = timeZone;
        return this;
    }

    public TSDate template(String template) {
        this.template = template;
        return this;
    }

    public TSDate UTC() {
        if (Objects.equals(this.zone, "UTC")) {
            return this;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneId.of("UTC")));
        calendar.setTimeInMillis(this.milliseconds);
        return new TSDate(calendar);
    }

    public Date get() {
        return this.date;
    }

    public Date getDate() {
        return this.date;
    }

    public Long getMilliseconds() {
        return this.milliseconds;
    }

    public String getZone() {
        return this.zone;
    }

    public String getTemplate() {
        return this.template;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setMilliseconds(Long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @JsonIgnore
    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TSDate)) {
            return false;
        }
        TSDate other = (TSDate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$milliseconds = this.getMilliseconds();
        Long other$milliseconds = other.getMilliseconds();
        if (this$milliseconds == null ? other$milliseconds != null : !((Object)this$milliseconds).equals(other$milliseconds)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$zone = this.getZone();
        String other$zone = other.getZone();
        if (this$zone == null ? other$zone != null : !this$zone.equals(other$zone)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        Calendar this$calendar = this.getCalendar();
        Calendar other$calendar = other.getCalendar();
        return !(this$calendar == null ? other$calendar != null : !((Object)this$calendar).equals(other$calendar));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TSDate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $milliseconds = this.getMilliseconds();
        result = result * 59 + ($milliseconds == null ? 43 : ((Object)$milliseconds).hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $zone = this.getZone();
        result = result * 59 + ($zone == null ? 43 : $zone.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        Calendar $calendar = this.getCalendar();
        result = result * 59 + ($calendar == null ? 43 : ((Object)$calendar).hashCode());
        return result;
    }

    public String toString() {
        return "TSDate(date=" + String.valueOf(this.getDate()) + ", milliseconds=" + this.getMilliseconds() + ", zone=" + this.getZone() + ", template=" + this.getTemplate() + ", calendar=" + String.valueOf(this.getCalendar()) + ")";
    }
}

