/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.utils.bean_copier;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import systems.dennis.shared.annotations.FormTransient;
import systems.dennis.shared.annotations.ObjectByIdPresentation;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.exceptions.BeanCopierException;
import systems.dennis.shared.form.AbstractForm;
import systems.dennis.shared.utils.ApplicationContext;
import systems.dennis.shared.utils.bean_copier.AbstractTransformer;
import systems.dennis.shared.utils.bean_copier.DataTransformer;
import systems.dennis.shared.utils.bean_copier.ObjectDefinition;
import systems.dennis.shared.utils.bean_copier.Transient;

@Service
@Scope(value="singleton")
public class BeanCopier
extends ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(BeanCopier.class);
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";
    public static final String IS_PREFIX = "is";
    public static final int TYPE_ALL_FIELDS = 0;
    public static final int TYPE_TRANSIENT_FIELDS = 1;
    public static final int TYPE_NON_TRANSIENT_FIELDS = 2;

    public BeanCopier(WebContext context) {
        super(context);
    }

    public <T> T copy(Object from, Class<T> cl) {
        if (from == null) {
            return null;
        }
        if (cl == null) {
            throw new BeanCopierException("Parameter \"c\" in method copy(Object from, Class<T> c) for class " + this.getClass().getName() + " is null");
        }
        T inst = cl.getConstructor(new Class[0]).newInstance(new Object[0]);
        List<Field> fields = BeanCopier.getFields(cl, new ArrayList<Field>());
        for (Field field : fields) {
            this.copyField(from, inst, field);
        }
        return inst;
    }

    public AbstractEntity copyTransientFields(AbstractEntity model, AbstractEntity original) {
        List<Field> transientFields = BeanCopier.getFields(original.getClass(), new ArrayList<Field>(), 1);
        for (Field field : transientFields) {
            this.copyField(original, model, field, true);
        }
        return model;
    }

    public <T> T clone(T object) {
        List<Field> fields = BeanCopier.getFields(object.getClass(), new ArrayList<Field>(), 0);
        Object inst = object.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field : fields) {
            this.cloneField(object, inst, field);
        }
        return (T)inst;
    }

    public static Field findField(String name, Class<?> c) {
        if (name == null || c == null) {
            return null;
        }
        try {
            return c.getDeclaredField(name);
        }
        catch (Exception e) {
            if (c.getSuperclass() != null) {
                return BeanCopier.findField(name, c.getSuperclass());
            }
            throw new BeanCopierException("field " + name + " is not known for class ");
        }
    }

    private void cloneField(Object from, Object to, Field fieldTo) {
        log.trace("Copying field: " + fieldTo.getName());
        if (fieldTo.getAnnotation(Transient.class) != null) {
            return;
        }
        try {
            Method setter = BeanCopier.findFieldAssociatedMethod(to.getClass(), fieldTo, SETTER_PREFIX);
            if (setter == null) {
                log.error("Field not found in " + String.valueOf(to.getClass()) + " ->  " + fieldTo.getName());
                return;
            }
            Method getter = BeanCopier.findFieldAssociatedMethod(from.getClass(), fieldTo, GETTER_PREFIX);
            if (getter != null) {
                try {
                    setter.invoke(to, getter.invoke(from, new Object[0]));
                }
                catch (Exception e) {
                    log.debug("Something wrong with field " + fieldTo.getName(), (Throwable)e);
                }
            } else {
                log.info("Cannot find setter for:  " + fieldTo.getName());
            }
        }
        catch (Exception e) {
            log.error("Cannot copy field " + fieldTo.getName() + " to " + String.valueOf(to.getClass()), (Throwable)e);
        }
    }

    private void copyField(Object from, Object to, Field fieldTo) {
        this.copyField(from, to, fieldTo, false);
    }

    private void copyField(Object from, Object to, Field fieldTo, boolean force) {
        block8: {
            log.debug("Copying field: " + fieldTo.getName());
            if (!(fieldTo.getAnnotation(Transient.class) == null && fieldTo.getAnnotation(FormTransient.class) == null || force)) {
                return;
            }
            try {
                Method setter = BeanCopier.findFieldAssociatedMethod(to.getClass(), fieldTo, SETTER_PREFIX);
                if (setter == null) {
                    log.error("Field not found in " + String.valueOf(to.getClass()) + " ->  " + fieldTo.getName());
                    return;
                }
                Method getter = BeanCopier.findFieldAssociatedMethod(from.getClass(), fieldTo, GETTER_PREFIX);
                if (getter != null) {
                    try {
                        Field fromField = BeanCopier.findField(fieldTo.getName(), from.getClass());
                        DataTransformer transformer = fromField.getAnnotation(DataTransformer.class);
                        if (transformer == null || to.getClass().equals(from.getClass())) {
                            setter.invoke(to, getter.invoke(from, new Object[0]));
                            break block8;
                        }
                        AbstractTransformer converter = transformer.transFormWith().newInstance();
                        setter.invoke(to, converter.transform(getter.invoke(from, new Object[0]), transformer, setter.getParameterTypes()[0], this.getContext()));
                    }
                    catch (Exception e) {
                        log.info("Something wrong with field " + fieldTo.getName(), (Throwable)e);
                    }
                    break block8;
                }
                log.debug("Cannot find setter for:  " + fieldTo.getName());
            }
            catch (Exception e) {
                log.error("Cannot copy field " + fieldTo.getName() + " to " + String.valueOf(to.getClass()), (Throwable)e);
            }
        }
    }

    private static List<Field> getFields(Class<?> cl, List<Field> fields) {
        return BeanCopier.getFields(cl, fields, 2);
    }

    private static List<Field> getFields(Class<?> cl, List<Field> fields, int collectFieldType) {
        Field[] declaredFields;
        if (cl == null) {
            return null;
        }
        if (cl.getSuperclass().getSuperclass() != null) {
            BeanCopier.getFields(cl.getSuperclass(), fields, collectFieldType);
        }
        for (Field field : declaredFields = cl.getDeclaredFields()) {
            boolean onlyTransient;
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (collectFieldType == 0) {
                fields.add(field);
            }
            boolean isTransient = field.getAnnotation(Transient.class) != null || field.getAnnotation(FormTransient.class) != null;
            boolean bl = onlyTransient = collectFieldType == 1;
            if ((!onlyTransient || !isTransient) && (onlyTransient || isTransient)) continue;
            fields.add(field);
        }
        return fields;
    }

    public static void withEach(Class<?> c, WithEach withEach) {
        if (c != null && withEach != null) {
            ArrayList<Field> fields = new ArrayList<Field>();
            BeanCopier.getFields(c, fields, 1);
            BeanCopier.getFields(c, fields);
            fields.forEach(withEach::with);
        }
    }

    public static boolean isFieldDefaultFormType(String field, Class<?> c) {
        return AbstractEntity.class.isAssignableFrom(BeanCopier.findField(field, c).getType());
    }

    public static Map<String, Object> values(AbstractForm c, AbstractEntity entity, WebContext.LocalWebContext context) {
        if (c == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        BeanCopier.withEach(c.getClass(), x -> {
            x.setAccessible(true);
            try {
                if (x.getAnnotation(ObjectByIdPresentation.class) != null && entity.getId() != null) {
                    Field f = BeanCopier.findField(x.getName(), entity.getClass());
                    f.setAccessible(true);
                    AbstractEntity origin = (AbstractEntity)f.get(entity);
                    f.setAccessible(false);
                    result.put(x.getName(), new ObjectDefinition(origin));
                } else if (x.getAnnotation(DataTransformer.class) == null) {
                    result.put(x.getName(), x.get(c));
                } else {
                    DataTransformer ann = x.getAnnotation(DataTransformer.class);
                    if (ann.transFormWith() != null) {
                        result.put(x.getName(), x.get(c));
                    } else {
                        result.put(x.getName(), x.get(c));
                    }
                }
            }
            catch (IllegalAccessException e) {
                log.error("Cannot get value from : " + String.valueOf(x.getClass()) + "." + x.getName());
            }
            finally {
                x.setAccessible(false);
            }
        });
        return result;
    }

    private static <T> T setOrGetFieldValue(Object object, Field field, Object value, String pref) {
        return BeanCopier.setOrGetFieldValue(object, field, value, pref, false);
    }

    private static <T> T setOrGetFieldValue(Object object, Field field, Object value, String pref, boolean ignoreTransient) {
        if (!ignoreTransient && pref.equals(SETTER_PREFIX) && (field.getAnnotation(Transient.class) != null || field.getAnnotation(FormTransient.class) != null)) {
            return (T)object;
        }
        Method method = BeanCopier.findFieldAssociatedMethod(object.getClass(), field, pref);
        if (method == null) {
            log.error("Field not found in " + String.valueOf(object.getClass()) + " ->  " + field.getName());
            return (T)value;
        }
        try {
            if (Objects.equals(pref, GETTER_PREFIX) || Objects.equals(pref, IS_PREFIX)) {
                return (T)method.invoke(object, new Object[0]);
            }
            method.invoke(object, value);
            return (T)object;
        }
        catch (Exception e) {
            throw new BeanCopierException("field not found or not be read my method: " + e.getMessage());
        }
    }

    public static void setFieldValue(Object model, Field field, Object value) {
        BeanCopier.setFieldValue(model, field, value, false);
    }

    public static void setFieldValue(Object model, Field field, Object value, boolean ignoreTransient) {
        BeanCopier.setOrGetFieldValue(model, field, value, SETTER_PREFIX, ignoreTransient);
    }

    public static void setFieldValue(Object model, String field, Object value) {
        BeanCopier.setOrGetFieldValue(model, BeanCopier.findField(field, model.getClass()), value, SETTER_PREFIX);
    }

    public static <T> T readValue(Object from, Field field) {
        return BeanCopier.setOrGetFieldValue(from, field, null, GETTER_PREFIX);
    }

    public static <T> T readValue(Object from, String field) {
        Field f = BeanCopier.findField(field, from.getClass());
        return BeanCopier.readValue(from, f);
    }

    public static List<Field> findAnnotatedFields(Class<?> c, Class<?> annotation) {
        return BeanCopier.findAnnotatedFields(c, annotation, 2);
    }

    public static List<Field> findAnnotatedFields(Class<?> c, Class<?> annotation, int type) {
        List<Field> fieldRes = new ArrayList<Field>();
        if (c != null && annotation != null) {
            Class<?> annotationClass = annotation;
            fieldRes = BeanCopier.getFields(c, fieldRes, type).stream().filter(x -> x.getAnnotation(annotationClass) != null).distinct().collect(Collectors.toList());
        }
        return fieldRes;
    }

    private static Method findFieldAssociatedMethod(Class<?> cl, Field f, String pref) {
        try {
            Method[] methods = cl.getDeclaredMethods();
            log.trace("Searching for method " + pref + BeanCopier.firstCapitalize(f.getName()) + " in class " + cl.getName());
            for (Method method : methods) {
                if (!method.getName().equals(pref + BeanCopier.firstCapitalize(f.getName()))) continue;
                return method;
            }
            return BeanCopier.findFieldAssociatedMethod(cl.getSuperclass(), f, pref);
        }
        catch (Exception e) {
            log.error("e");
            return null;
        }
    }

    private static String firstCapitalize(String what) {
        if (what == null || what.trim().length() == 0) {
            return null;
        }
        char res = Character.toTitleCase(what.charAt(0));
        return res + what.substring(1);
    }

    public static interface WithEach {
        public void with(Field var1);
    }
}

