/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.utils.bean_copier;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.shared.annotations.DataRetrieverDescription;
import systems.dennis.shared.config.WebContext;
import systems.dennis.shared.entity.AbstractEntity;
import systems.dennis.shared.model.IDPresenter;
import systems.dennis.shared.utils.bean_copier.AbstractTransformer;
import systems.dennis.shared.utils.bean_copier.BeanCopier;
import systems.dennis.shared.utils.bean_copier.DataTransformer;

public class BeanCopierListTransformer<ID_TYPE extends Serializable>
implements AbstractTransformer<ID_TYPE> {
    private static final Logger log = LoggerFactory.getLogger(BeanCopierListTransformer.class);

    private Class<?> determineTargetClass(Class<?> cl, DataTransformer dataTransformer) {
        if (AbstractEntity.class.isAssignableFrom(cl)) {
            return dataTransformer.additionalClass().getAnnotation(DataRetrieverDescription.class).form();
        }
        return dataTransformer.additionalClass().getAnnotation(DataRetrieverDescription.class).model();
    }

    @Override
    public <DB_TYPE extends IDPresenter<ID_TYPE>> Object transform(Object object, DataTransformer dataTransformer, Class<?> toType, WebContext.LocalWebContext context) {
        try {
            BeanCopier beanCopier = context.getBean(BeanCopier.class);
            List items = (List)object;
            ArrayList result = new ArrayList();
            items.forEach(x -> result.add(beanCopier.copy(x, this.determineTargetClass(x.getClass(), dataTransformer))));
            return result;
        }
        catch (Exception e) {
            log.debug("error: copying  " + String.valueOf(object), (Throwable)e);
            return null;
        }
    }
}

