/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.validation;

import java.util.Date;
import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.utils.TSDate;
import systems.dennis.shared.utils.bean_copier.BeanCopier;
import systems.dennis.shared.validation.ValueValidator;

public class BeforeAfterDateValidator
implements ValueValidator<Object, Object> {
    @Override
    public ValidationResult validate(Object element, Object value, ValidationContent content) {
        String[] params = content.getValidation().params();
        if (params.length < 2) {
            return ValidationResult.fail("not.enough.parameters.for.date.validation");
        }
        String startDateField = params[0];
        String endDateField = params[1];
        TSDate startValue = (TSDate)BeanCopier.readValue(element, startDateField);
        TSDate endValue = (TSDate)BeanCopier.readValue(element, endDateField);
        return this.validateDateRange(startValue.getDate(), endValue.getDate());
    }

    private ValidationResult validateDateRange(Date startValue, Date endValue) {
        if (startValue == null && endValue == null) {
            return ValidationResult.PASSED;
        }
        if (startValue == null) {
            return ValidationResult.fail("date.validation.start_date_null_and_end_date_not");
        }
        if (startValue.after(endValue)) {
            return ValidationResult.fail("date.validation.start_date_after_end_date");
        }
        return ValidationResult.PASSED;
    }
}

