/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.validation;

import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.exceptions.BeanCopierException;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.utils.bean_copier.BeanCopier;
import systems.dennis.shared.validation.ValueValidator;

public class PasswordValidator
implements ValueValidator<Object, String> {
    private static final Logger log = LoggerFactory.getLogger(PasswordValidator.class);
    private final Pattern regex = Pattern.compile("^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[@#$%^&+=!*()_{};:,<.>/\\\\-])[0-9a-zA-Z@#$%^&+=!*()_{};:,<.>/\\\\-]{8,}$");

    @Override
    public ValidationResult validate(Object element, String value, ValidationContent content) {
        boolean ok = this.regex.matcher(value = value.trim()).matches();
        if (!ok) {
            return ValidationResult.fail("incorrect.password");
        }
        try {
            if (!value.equals(BeanCopier.readValue(element, "repeatPassword"))) {
                return ValidationResult.fail("passwsord_does_not_match");
            }
        }
        catch (BeanCopierException e) {
            return ValidationResult.PASSED;
        }
        catch (Exception e) {
            log.error("Something wrong with validation ", (Throwable)e);
        }
        return ValidationResult.PASSED;
    }
}

