/*
 * Decompiled with CFR 0.152.
 */
package systems.dennis.shared.validation;

import java.util.Collection;
import java.util.Objects;
import systems.dennis.shared.annotations.ValidationContent;
import systems.dennis.shared.pojo_form.ValidationResult;
import systems.dennis.shared.validation.ValueValidator;

public class ValueNotEmptyValidator
implements ValueValidator {
    public static ValueNotEmptyValidator DEFAULT = new ValueNotEmptyValidator();

    public ValidationResult validate(Object element, Object value, ValidationContent content) {
        if (Objects.isNull(value)) {
            return ValidationResult.fail("value.not.set." + content.getField());
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.equals(String.class) && ((String)value).trim().isEmpty()) {
            return ValidationResult.fail("value.not.set." + content.getField());
        }
        if (Collection.class.isAssignableFrom(valueClass) && ((Collection)value).isEmpty()) {
            return ValidationResult.fail("value.not.set." + content.getField());
        }
        return ValidationResult.PASSED;
    }
}

