/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Supplier;

@Internal
public class Async {
    public static <T> CombinedBuilder<T> ofExpectedSize(int expectedSize) {
        if (expectedSize == 0) {
            return new Empty();
        }
        if (expectedSize == 1) {
            return new Single();
        }
        return new Many(expectedSize);
    }

    public static <T, U> CompletableFuture<List<U>> each(Collection<T> list, BiFunction<T, Integer, CompletableFuture<U>> cfFactory) {
        CombinedBuilder futures = Async.ofExpectedSize(list.size());
        int index = 0;
        for (T t : list) {
            CompletableFuture<Object> cf;
            try {
                cf = cfFactory.apply(t, index++);
                Assert.assertNotNull(cf, () -> "cfFactory must return a non null value");
            }
            catch (Exception e) {
                cf = new CompletableFuture();
                cf.completeExceptionally(new CompletionException(e));
            }
            futures.add(cf);
        }
        return futures.await();
    }

    public static <T, U> CompletableFuture<List<U>> eachSequentially(Iterable<T> list, CFFactory<T, U> cfFactory) {
        CompletableFuture<List<U>> result = new CompletableFuture<List<U>>();
        Async.eachSequentiallyImpl(list.iterator(), cfFactory, 0, new ArrayList(), result);
        return result;
    }

    private static <T, U> void eachSequentiallyImpl(Iterator<T> iterator, CFFactory<T, U> cfFactory, int index, List<U> tmpResult, CompletableFuture<List<U>> overallResult) {
        CompletableFuture<Object> cf;
        if (!iterator.hasNext()) {
            overallResult.complete(tmpResult);
            return;
        }
        try {
            cf = cfFactory.apply(iterator.next(), index, tmpResult);
            Assert.assertNotNull(cf, () -> "cfFactory must return a non null value");
        }
        catch (Exception e) {
            cf = new CompletableFuture();
            cf.completeExceptionally(new CompletionException(e));
        }
        cf.whenComplete((cfResult, exception) -> {
            if (exception != null) {
                overallResult.completeExceptionally((Throwable)exception);
                return;
            }
            tmpResult.add(cfResult);
            Async.eachSequentiallyImpl(iterator, cfFactory, index + 1, tmpResult, overallResult);
        });
    }

    public static <T> CompletableFuture<T> toCompletableFuture(T t) {
        if (t instanceof CompletionStage) {
            return ((CompletionStage)t).toCompletableFuture();
        }
        return CompletableFuture.completedFuture(t);
    }

    public static <T> CompletableFuture<T> tryCatch(Supplier<CompletableFuture<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            CompletableFuture result = new CompletableFuture();
            result.completeExceptionally(e);
            return result;
        }
    }

    public static <T> CompletableFuture<T> exceptionallyCompletedFuture(Throwable exception) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(exception);
        return result;
    }

    @FunctionalInterface
    public static interface CFFactory<T, U> {
        public CompletableFuture<U> apply(T var1, int var2, List<U> var3);
    }

    private static class Many<T>
    implements CombinedBuilder<T> {
        private final CompletableFuture<T>[] array;
        private int ix;

        private Many(int size) {
            this.array = new CompletableFuture[size];
            this.ix = 0;
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            this.array[this.ix++] = completableFuture;
        }

        @Override
        public CompletableFuture<List<T>> await() {
            Assert.assertTrue(this.ix == this.array.length, () -> "expected size was " + this.array.length + " got " + this.ix);
            CompletableFuture<List<T>> overallResult = new CompletableFuture<List<T>>();
            CompletableFuture.allOf(this.array).whenComplete((ignored, exception) -> {
                if (exception != null) {
                    overallResult.completeExceptionally((Throwable)exception);
                    return;
                }
                ArrayList<T> results = new ArrayList<T>(this.array.length);
                for (CompletableFuture<T> future : this.array) {
                    results.add(future.join());
                }
                overallResult.complete(results);
            });
            return overallResult;
        }
    }

    private static class Single<T>
    implements CombinedBuilder<T> {
        private CompletableFuture<T> completableFuture;
        private int ix;

        private Single() {
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            this.completableFuture = completableFuture;
            ++this.ix;
        }

        @Override
        public CompletableFuture<List<T>> await() {
            Assert.assertTrue(this.ix == 1, () -> "expected size was 1 got " + this.ix);
            CompletableFuture<List<T>> overallResult = new CompletableFuture<List<T>>();
            this.completableFuture.whenComplete((ignored, exception) -> {
                if (exception != null) {
                    overallResult.completeExceptionally((Throwable)exception);
                    return;
                }
                List<T> results = Collections.singletonList(this.completableFuture.join());
                overallResult.complete(results);
            });
            return overallResult;
        }
    }

    private static class Empty<T>
    implements CombinedBuilder<T> {
        private int ix;

        private Empty() {
        }

        @Override
        public void add(CompletableFuture<T> completableFuture) {
            ++this.ix;
        }

        @Override
        public CompletableFuture<List<T>> await() {
            Assert.assertTrue(this.ix == 0, () -> "expected size was 0 got " + this.ix);
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    public static interface CombinedBuilder<T> {
        public void add(CompletableFuture<T> var1);

        public CompletableFuture<List<T>> await();
    }
}

