/*
 * Decompiled with CFR 0.152.
 */
package graphql.extensions;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.extensions.ExtensionsMerger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import manifold.shade.org.jetbrains.annotations.NotNull;
import manifold.shade.org.jetbrains.annotations.Nullable;

@PublicApi
public class ExtensionsBuilder {
    private final List<Map<Object, Object>> changes = new CopyOnWriteArrayList<Map<Object, Object>>();
    private final ExtensionsMerger extensionsMerger;

    private ExtensionsBuilder(ExtensionsMerger extensionsMerger) {
        this.extensionsMerger = extensionsMerger;
    }

    public static ExtensionsBuilder newExtensionsBuilder() {
        return new ExtensionsBuilder(ExtensionsMerger.DEFAULT);
    }

    public static ExtensionsBuilder newExtensionsBuilder(ExtensionsMerger extensionsMerger) {
        return new ExtensionsBuilder(extensionsMerger);
    }

    public ExtensionsBuilder addValues(@NotNull Map<Object, Object> newValues) {
        Assert.assertNotNull(newValues);
        this.changes.add(newValues);
        return this;
    }

    public ExtensionsBuilder addValue(@NotNull Object key, @Nullable Object value) {
        Assert.assertNotNull(key);
        return this.addValues(Collections.singletonMap(key, value));
    }

    public Map<Object, Object> buildExtensions() {
        if (this.changes.isEmpty()) {
            return ImmutableMap.of();
        }
        Map<Object, Object> firstChange = this.changes.get(0);
        if (this.changes.size() == 1) {
            return firstChange;
        }
        Map<Object, Object> outMap = new LinkedHashMap<Object, Object>(firstChange);
        for (int i = 1; i < this.changes.size(); ++i) {
            Map<Object, Object> newMap = this.extensionsMerger.merge(outMap, this.changes.get(i));
            Assert.assertNotNull(outMap, () -> "You MUST provide a non null Map from ExtensionsMerger.merge()");
            outMap = newMap;
        }
        return outMap;
    }

    public ExecutionResult setExtensions(ExecutionResult executionResult) {
        Assert.assertNotNull(executionResult);
        Map<Object, Object> currentExtensions = executionResult.getExtensions();
        Map<Object, Object> builderExtensions = this.buildExtensions();
        if (currentExtensions == null && builderExtensions.isEmpty()) {
            return executionResult;
        }
        return executionResult.transform(builder -> builder.extensions(builderExtensions));
    }
}

