/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalar;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.IntValue;
import graphql.language.Value;
import graphql.scalar.CoercingUtil;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import manifold.shade.org.jetbrains.annotations.NotNull;
import manifold.shade.org.jetbrains.annotations.Nullable;

@Internal
public class GraphqlIntCoercing
implements Coercing<Integer, Integer> {
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);

    private Integer convertImpl(Object input) {
        if (input instanceof Integer) {
            return (Integer)input;
        }
        if (CoercingUtil.isNumberIsh(input)) {
            BigDecimal value;
            try {
                value = new BigDecimal(input.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
            try {
                return value.intValueExact();
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        return null;
    }

    @NotNull
    private Integer serialiseImpl(Object input, @NotNull Locale locale) {
        Integer result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingSerializeException(CoercingUtil.i18nMsg(locale, "Int.notInt", CoercingUtil.typeName(input)));
        }
        return result;
    }

    @NotNull
    private Integer parseValueImpl(@NotNull Object input, @NotNull Locale locale) {
        Integer result = this.convertImpl(input);
        if (result == null) {
            throw new CoercingParseValueException(CoercingUtil.i18nMsg(locale, "Int.notInt", CoercingUtil.typeName(input)));
        }
        return result;
    }

    private static int parseLiteralImpl(Object input, @NotNull Locale locale) {
        if (!(input instanceof IntValue)) {
            throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Scalar.unexpectedAstType", "IntValue", CoercingUtil.typeName(input)));
        }
        BigInteger value = ((IntValue)input).getValue();
        if (value.compareTo(INT_MIN) < 0 || value.compareTo(INT_MAX) > 0) {
            throw new CoercingParseLiteralException(CoercingUtil.i18nMsg(locale, "Int.outsideRange", value.toString()));
        }
        return value.intValue();
    }

    private IntValue valueToLiteralImpl(Object input, @NotNull Locale locale) {
        Integer result = Assert.assertNotNull(this.convertImpl(input), () -> CoercingUtil.i18nMsg(locale, "Int.notInt", CoercingUtil.typeName(input)));
        return IntValue.newIntValue(BigInteger.valueOf(result.intValue())).build();
    }

    @Override
    @Deprecated
    public Integer serialize(@NotNull Object dataFetcherResult) {
        return this.serialiseImpl(dataFetcherResult, Locale.getDefault());
    }

    @Override
    @Nullable
    public Integer serialize(@NotNull Object dataFetcherResult, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingSerializeException {
        return this.serialiseImpl(dataFetcherResult, locale);
    }

    @Override
    @Deprecated
    public Integer parseValue(@NotNull Object input) {
        return this.parseValueImpl(input, Locale.getDefault());
    }

    @Override
    public Integer parseValue(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseValueException {
        return this.parseValueImpl(input, locale);
    }

    @Override
    @Deprecated
    public Integer parseLiteral(@NotNull Object input) {
        return GraphqlIntCoercing.parseLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @Nullable
    public Integer parseLiteral(@NotNull Value<?> input, @NotNull CoercedVariables variables, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) throws CoercingParseLiteralException {
        return GraphqlIntCoercing.parseLiteralImpl(input, locale);
    }

    @Override
    @Deprecated
    public Value valueToLiteral(@NotNull Object input) {
        return this.valueToLiteralImpl(input, Locale.getDefault());
    }

    @Override
    @NotNull
    public Value<?> valueToLiteral(@NotNull Object input, @NotNull GraphQLContext graphQLContext, @NotNull Locale locale) {
        return this.valueToLiteralImpl(input, locale);
    }
}

