/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Directives;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.introspection.Introspection;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.schema.CodeRegistryVisitor;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeComparators;
import graphql.schema.impl.GraphQLTypeCollectingVisitor;
import graphql.schema.impl.SchemaUtil;
import graphql.schema.validation.InvalidSchemaException;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidator;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import manifold.shade.org.jetbrains.annotations.NotNull;
import manifold.shade.org.jetbrains.annotations.Nullable;

@PublicApi
public class GraphQLSchema {
    private final GraphQLObjectType queryType;
    private final GraphQLObjectType mutationType;
    private final GraphQLObjectType subscriptionType;
    private final GraphQLObjectType introspectionSchemaType;
    private final ImmutableSet<GraphQLType> additionalTypes;
    private final GraphQLFieldDefinition introspectionSchemaField;
    private final GraphQLFieldDefinition introspectionTypeField;
    private final GraphQLFieldDefinition __typename = Introspection.TypeNameMetaFieldDef;
    private final DirectivesUtil.DirectivesHolder directiveDefinitionsHolder;
    private final DirectivesUtil.DirectivesHolder schemaAppliedDirectivesHolder;
    private final SchemaDefinition definition;
    private final ImmutableList<SchemaExtensionDefinition> extensionDefinitions;
    private final String description;
    private final GraphQLCodeRegistry codeRegistry;
    private final ImmutableMap<String, GraphQLNamedType> typeMap;
    private final ImmutableMap<String, ImmutableList<GraphQLObjectType>> interfaceNameToObjectTypes;
    private final ImmutableMap<String, ImmutableList<String>> interfaceNameToObjectTypeNames;

    @Internal
    private GraphQLSchema(Builder builder) {
        Assert.assertNotNull(builder.additionalTypes, () -> "additionalTypes can't be null");
        Assert.assertNotNull(builder.queryType, () -> "queryType can't be null");
        Assert.assertNotNull(builder.additionalDirectives, () -> "directives can't be null");
        Assert.assertNotNull(builder.codeRegistry, () -> "codeRegistry can't be null");
        this.queryType = builder.queryType;
        this.mutationType = builder.mutationType;
        this.subscriptionType = builder.subscriptionType;
        this.additionalTypes = ImmutableSet.copyOf(builder.additionalTypes);
        this.introspectionSchemaType = builder.introspectionSchemaType;
        this.introspectionSchemaField = Introspection.buildSchemaField(builder.introspectionSchemaType);
        this.introspectionTypeField = Introspection.buildTypeField(builder.introspectionSchemaType);
        this.directiveDefinitionsHolder = new DirectivesUtil.DirectivesHolder(builder.additionalDirectives, ImmutableKit.emptyList());
        this.schemaAppliedDirectivesHolder = new DirectivesUtil.DirectivesHolder(builder.schemaDirectives, builder.schemaAppliedDirectives);
        this.definition = builder.definition;
        this.extensionDefinitions = ImmutableKit.nonNullCopyOf(builder.extensionDefinitions);
        this.description = builder.description;
        this.codeRegistry = null;
        this.typeMap = ImmutableKit.emptyMap();
        this.interfaceNameToObjectTypes = ImmutableKit.emptyMap();
        this.interfaceNameToObjectTypeNames = ImmutableKit.emptyMap();
    }

    @Internal
    public GraphQLSchema(GraphQLSchema existingSchema, GraphQLCodeRegistry codeRegistry, ImmutableMap<String, GraphQLNamedType> typeMap, ImmutableMap<String, ImmutableList<GraphQLObjectType>> interfaceNameToObjectTypes) {
        Assert.assertNotNull(codeRegistry, () -> "codeRegistry can't be null");
        this.queryType = existingSchema.queryType;
        this.mutationType = existingSchema.mutationType;
        this.subscriptionType = existingSchema.subscriptionType;
        this.additionalTypes = ImmutableSet.copyOf(existingSchema.additionalTypes);
        this.introspectionSchemaType = existingSchema.introspectionSchemaType;
        this.introspectionSchemaField = Introspection.buildSchemaField(existingSchema.introspectionSchemaType);
        this.introspectionTypeField = Introspection.buildTypeField(existingSchema.introspectionSchemaType);
        this.directiveDefinitionsHolder = existingSchema.directiveDefinitionsHolder;
        this.schemaAppliedDirectivesHolder = existingSchema.schemaAppliedDirectivesHolder;
        this.definition = existingSchema.definition;
        this.extensionDefinitions = existingSchema.extensionDefinitions;
        this.description = existingSchema.description;
        this.codeRegistry = codeRegistry;
        this.typeMap = typeMap;
        this.interfaceNameToObjectTypes = interfaceNameToObjectTypes;
        this.interfaceNameToObjectTypeNames = GraphQLSchema.buildInterfacesToObjectName(interfaceNameToObjectTypes);
    }

    @Internal
    public GraphQLSchema(BuilderWithoutTypes builder) {
        Assert.assertNotNull(builder.codeRegistry, () -> "codeRegistry can't be null");
        GraphQLSchema existingSchema = builder.existingSchema;
        this.queryType = existingSchema.queryType;
        this.mutationType = existingSchema.mutationType;
        this.subscriptionType = existingSchema.subscriptionType;
        this.additionalTypes = existingSchema.additionalTypes;
        this.introspectionSchemaType = existingSchema.introspectionSchemaType;
        this.introspectionSchemaField = existingSchema.introspectionSchemaField;
        this.introspectionTypeField = existingSchema.introspectionTypeField;
        this.directiveDefinitionsHolder = existingSchema.directiveDefinitionsHolder;
        this.schemaAppliedDirectivesHolder = existingSchema.schemaAppliedDirectivesHolder;
        this.definition = existingSchema.definition;
        this.extensionDefinitions = existingSchema.extensionDefinitions;
        this.typeMap = existingSchema.typeMap;
        this.interfaceNameToObjectTypes = existingSchema.interfaceNameToObjectTypes;
        this.interfaceNameToObjectTypeNames = existingSchema.interfaceNameToObjectTypeNames;
        this.description = builder.description;
        this.codeRegistry = builder.codeRegistry;
    }

    private static GraphQLDirective[] schemaDirectivesArray(GraphQLSchema existingSchema) {
        return existingSchema.schemaAppliedDirectivesHolder.getDirectives().toArray(new GraphQLDirective[0]);
    }

    private static GraphQLAppliedDirective[] schemaAppliedDirectivesArray(GraphQLSchema existingSchema) {
        return existingSchema.schemaAppliedDirectivesHolder.getAppliedDirectives().toArray(new GraphQLAppliedDirective[0]);
    }

    private static List<GraphQLNamedType> getAllTypesAsList(ImmutableMap<String, GraphQLNamedType> typeMap) {
        return GraphqlTypeComparators.sortTypes(GraphqlTypeComparators.byNameAsc(), typeMap.values());
    }

    private static ImmutableMap<String, ImmutableList<GraphQLObjectType>> buildInterfacesToObjectTypes(Map<String, List<GraphQLObjectType>> groupImplementations) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<String, List<GraphQLObjectType>> e : groupImplementations.entrySet()) {
            ImmutableList sortedObjectTypes = ImmutableList.copyOf(GraphqlTypeComparators.sortTypes(GraphqlTypeComparators.byNameAsc(), (Collection)e.getValue()));
            map.put(e.getKey(), sortedObjectTypes);
        }
        return map.build();
    }

    private static ImmutableMap<String, ImmutableList<String>> buildInterfacesToObjectName(ImmutableMap<String, ImmutableList<GraphQLObjectType>> byInterface) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry e : byInterface.entrySet()) {
            ImmutableList<String> objectTypeNames = ImmutableKit.map((Collection)e.getValue(), GraphQLObjectType::getName);
            map.put(e.getKey(), objectTypeNames);
        }
        return map.build();
    }

    public GraphQLCodeRegistry getCodeRegistry() {
        return this.codeRegistry;
    }

    public GraphQLFieldDefinition getIntrospectionSchemaFieldDefinition() {
        return this.introspectionSchemaField;
    }

    public GraphQLFieldDefinition getIntrospectionTypeFieldDefinition() {
        return this.introspectionTypeField;
    }

    public GraphQLFieldDefinition getIntrospectionTypenameFieldDefinition() {
        return this.__typename;
    }

    public GraphQLObjectType getIntrospectionSchemaType() {
        return this.introspectionSchemaType;
    }

    public Set<GraphQLType> getAdditionalTypes() {
        return this.additionalTypes;
    }

    @Nullable
    public GraphQLType getType(@NotNull String typeName) {
        return this.typeMap.get(typeName);
    }

    public <T extends GraphQLType> List<T> getTypes(Collection<String> typeNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String typeName : typeNames) {
            builder.add(Assert.assertNotNull(this.typeMap.get(typeName), () -> String.format("No type found for name %s", typeName)));
        }
        return builder.build();
    }

    public <T extends GraphQLType> T getTypeAs(String typeName) {
        return (T)this.typeMap.get(typeName);
    }

    public boolean containsType(String typeName) {
        return this.typeMap.containsKey(typeName);
    }

    public GraphQLObjectType getObjectType(String typeName) {
        GraphQLType graphQLType = this.typeMap.get(typeName);
        if (graphQLType != null) {
            Assert.assertTrue(graphQLType instanceof GraphQLObjectType, () -> String.format("You have asked for named object type '%s' but it's not an object type but rather a '%s'", typeName, graphQLType.getClass().getName()));
        }
        return (GraphQLObjectType)graphQLType;
    }

    public GraphQLFieldDefinition getFieldDefinition(FieldCoordinates fieldCoordinates) {
        String fieldName = fieldCoordinates.getFieldName();
        if (fieldCoordinates.isSystemCoordinates()) {
            if (fieldName.equals(this.getIntrospectionSchemaFieldDefinition().getName())) {
                return this.getIntrospectionSchemaFieldDefinition();
            }
            if (fieldName.equals(this.getIntrospectionTypeFieldDefinition().getName())) {
                return this.getIntrospectionTypeFieldDefinition();
            }
            if (fieldName.equals(this.getIntrospectionTypenameFieldDefinition().getName())) {
                return this.getIntrospectionTypenameFieldDefinition();
            }
            return (GraphQLFieldDefinition)Assert.assertShouldNeverHappen("The system field name %s is unknown", fieldName);
        }
        String typeName = fieldCoordinates.getTypeName();
        GraphQLType graphQLType = this.getType(typeName);
        if (graphQLType != null) {
            Assert.assertTrue(graphQLType instanceof GraphQLFieldsContainer, () -> String.format("You have asked for named type '%s' but it's not GraphQLFieldsContainer but rather a '%s'", typeName, graphQLType.getClass().getName()));
            return ((GraphQLFieldsContainer)graphQLType).getFieldDefinition(fieldName);
        }
        return null;
    }

    public Map<String, GraphQLNamedType> getTypeMap() {
        return this.typeMap;
    }

    public List<GraphQLNamedType> getAllTypesAsList() {
        return GraphQLSchema.getAllTypesAsList(this.typeMap);
    }

    public List<GraphQLNamedSchemaElement> getAllElementsAsList() {
        ArrayList<GraphQLNamedSchemaElement> list = new ArrayList<GraphQLNamedSchemaElement>();
        list.addAll(this.getDirectives());
        list.addAll(this.getAllTypesAsList());
        return list;
    }

    public List<GraphQLObjectType> getImplementations(GraphQLInterfaceType type) {
        return this.interfaceNameToObjectTypes.getOrDefault(type.getName(), ImmutableKit.emptyList());
    }

    public boolean isPossibleType(GraphQLNamedType abstractType, GraphQLObjectType concreteType) {
        if (abstractType instanceof GraphQLInterfaceType) {
            ImmutableList objectNames = this.interfaceNameToObjectTypeNames.getOrDefault(abstractType.getName(), ImmutableKit.emptyList());
            return objectNames.contains(concreteType.getName());
        }
        if (abstractType instanceof GraphQLUnionType) {
            return ((GraphQLUnionType)abstractType).isPossibleType(concreteType);
        }
        return (Boolean)Assert.assertShouldNeverHappen("Unsupported abstract type %s. Abstract types supported are Union and Interface.", abstractType.getName());
    }

    public GraphQLObjectType getQueryType() {
        return this.queryType;
    }

    public GraphQLObjectType getMutationType() {
        return this.mutationType;
    }

    public GraphQLObjectType getSubscriptionType() {
        return this.subscriptionType;
    }

    @Deprecated
    public GraphqlFieldVisibility getFieldVisibility() {
        return this.codeRegistry.getFieldVisibility();
    }

    public List<GraphQLDirective> getDirectives() {
        return this.directiveDefinitionsHolder.getDirectives();
    }

    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directiveDefinitionsHolder.getDirectivesByName();
    }

    public GraphQLDirective getDirective(String directiveName) {
        return this.directiveDefinitionsHolder.getDirective(directiveName);
    }

    @Deprecated
    public List<GraphQLDirective> getSchemaDirectives() {
        return this.schemaAppliedDirectivesHolder.getDirectives();
    }

    @Deprecated
    public Map<String, GraphQLDirective> getSchemaDirectiveByName() {
        return this.schemaAppliedDirectivesHolder.getDirectivesByName();
    }

    @Deprecated
    public Map<String, List<GraphQLDirective>> getAllSchemaDirectivesByName() {
        return this.schemaAppliedDirectivesHolder.getAllDirectivesByName();
    }

    @Deprecated
    public GraphQLDirective getSchemaDirective(String directiveName) {
        return this.schemaAppliedDirectivesHolder.getDirective(directiveName);
    }

    @Deprecated
    public List<GraphQLDirective> getSchemaDirectives(String directiveName) {
        return this.schemaAppliedDirectivesHolder.getDirectives(directiveName);
    }

    public List<GraphQLAppliedDirective> getSchemaAppliedDirectives() {
        return this.schemaAppliedDirectivesHolder.getAppliedDirectives();
    }

    public Map<String, List<GraphQLAppliedDirective>> getAllSchemaAppliedDirectivesByName() {
        return this.schemaAppliedDirectivesHolder.getAllAppliedDirectivesByName();
    }

    public GraphQLAppliedDirective getSchemaAppliedDirective(String directiveName) {
        return this.schemaAppliedDirectivesHolder.getAppliedDirective(directiveName);
    }

    public List<GraphQLAppliedDirective> getSchemaAppliedDirectives(String directiveName) {
        return this.schemaAppliedDirectivesHolder.getAppliedDirectives(directiveName);
    }

    @Nullable
    public SchemaDefinition getDefinition() {
        return this.definition;
    }

    public List<SchemaExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    public boolean isSupportingMutations() {
        return this.mutationType != null;
    }

    public boolean isSupportingSubscriptions() {
        return this.subscriptionType != null;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public GraphQLSchema transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLSchema.newSchema(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public GraphQLSchema transformWithoutTypes(Consumer<BuilderWithoutTypes> builderConsumer) {
        BuilderWithoutTypes builder = new BuilderWithoutTypes(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newSchema() {
        return new Builder();
    }

    public static Builder newSchema(GraphQLSchema existingSchema) {
        return new Builder().query(existingSchema.getQueryType()).mutation(existingSchema.getMutationType()).subscription(existingSchema.getSubscriptionType()).introspectionSchemaType(existingSchema.getIntrospectionSchemaType()).codeRegistry(existingSchema.getCodeRegistry()).clearAdditionalTypes().clearDirectives().additionalDirectives(new LinkedHashSet<GraphQLDirective>(existingSchema.getDirectives())).clearSchemaDirectives().withSchemaDirectives(GraphQLSchema.schemaDirectivesArray(existingSchema)).withSchemaAppliedDirectives(GraphQLSchema.schemaAppliedDirectivesArray(existingSchema)).additionalTypes(existingSchema.additionalTypes).description(existingSchema.getDescription());
    }

    public static class Builder {
        private GraphQLObjectType queryType;
        private GraphQLObjectType mutationType;
        private GraphQLObjectType introspectionSchemaType = Introspection.__Schema;
        private GraphQLObjectType subscriptionType;
        private GraphQLCodeRegistry codeRegistry = GraphQLCodeRegistry.newCodeRegistry().build();
        private SchemaDefinition definition;
        private List<SchemaExtensionDefinition> extensionDefinitions;
        private String description;
        private final Set<GraphQLDirective> additionalDirectives = new LinkedHashSet<GraphQLDirective>(Arrays.asList(Directives.IncludeDirective, Directives.SkipDirective));
        private final Set<GraphQLType> additionalTypes = new LinkedHashSet<GraphQLType>();
        private final List<GraphQLDirective> schemaDirectives = new ArrayList<GraphQLDirective>();
        private final List<GraphQLAppliedDirective> schemaAppliedDirectives = new ArrayList<GraphQLAppliedDirective>();

        public Builder query(GraphQLObjectType.Builder builder) {
            return this.query(builder.build());
        }

        public Builder query(GraphQLObjectType queryType) {
            this.queryType = queryType;
            return this;
        }

        public Builder mutation(GraphQLObjectType.Builder builder) {
            return this.mutation(builder.build());
        }

        public Builder mutation(GraphQLObjectType mutationType) {
            this.mutationType = mutationType;
            return this;
        }

        public Builder subscription(GraphQLObjectType.Builder builder) {
            return this.subscription(builder.build());
        }

        public Builder subscription(GraphQLObjectType subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Deprecated
        public Builder fieldVisibility(GraphqlFieldVisibility fieldVisibility) {
            this.codeRegistry = this.codeRegistry.transform(builder -> builder.fieldVisibility(fieldVisibility));
            return this;
        }

        public Builder codeRegistry(GraphQLCodeRegistry codeRegistry) {
            this.codeRegistry = codeRegistry;
            return this;
        }

        public Builder additionalTypes(Set<GraphQLType> additionalTypes) {
            this.additionalTypes.addAll(additionalTypes);
            return this;
        }

        public Builder additionalType(GraphQLType additionalType) {
            this.additionalTypes.add(additionalType);
            return this;
        }

        public Builder clearAdditionalTypes() {
            this.additionalTypes.clear();
            return this;
        }

        public Builder additionalDirectives(Set<GraphQLDirective> additionalDirectives) {
            this.additionalDirectives.addAll(additionalDirectives);
            return this;
        }

        public Builder additionalDirective(GraphQLDirective additionalDirective) {
            this.additionalDirectives.add(additionalDirective);
            return this;
        }

        public Builder clearDirectives() {
            this.additionalDirectives.clear();
            return this;
        }

        public Builder withSchemaDirectives(GraphQLDirective ... directives) {
            for (GraphQLDirective directive : directives) {
                this.withSchemaDirective(directive);
            }
            return this;
        }

        public Builder withSchemaDirectives(Collection<? extends GraphQLDirective> directives) {
            for (GraphQLDirective graphQLDirective : directives) {
                this.withSchemaDirective(graphQLDirective);
            }
            return this;
        }

        public Builder withSchemaDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, () -> "directive can't be null");
            this.schemaDirectives.add(directive);
            return this;
        }

        public Builder withSchemaDirective(GraphQLDirective.Builder builder) {
            return this.withSchemaDirective(builder.build());
        }

        public Builder withSchemaAppliedDirectives(GraphQLAppliedDirective ... appliedDirectives) {
            for (GraphQLAppliedDirective directive : appliedDirectives) {
                this.withSchemaAppliedDirective(directive);
            }
            return this;
        }

        public Builder withSchemaAppliedDirectives(Collection<? extends GraphQLAppliedDirective> appliedDirectives) {
            for (GraphQLAppliedDirective graphQLAppliedDirective : appliedDirectives) {
                this.withSchemaAppliedDirective(graphQLAppliedDirective);
            }
            return this;
        }

        public Builder withSchemaAppliedDirective(GraphQLAppliedDirective appliedDirective) {
            Assert.assertNotNull(appliedDirective, () -> "directive can't be null");
            this.schemaAppliedDirectives.add(appliedDirective);
            return this;
        }

        public Builder withSchemaAppliedDirective(GraphQLAppliedDirective.Builder builder) {
            return this.withSchemaAppliedDirective(builder.build());
        }

        public Builder clearSchemaDirectives() {
            this.schemaDirectives.clear();
            this.schemaAppliedDirectives.clear();
            return this;
        }

        public Builder definition(SchemaDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<SchemaExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder introspectionSchemaType(GraphQLObjectType introspectionSchemaType) {
            this.introspectionSchemaType = introspectionSchemaType;
            return this;
        }

        @Deprecated
        public GraphQLSchema build(Set<GraphQLType> additionalTypes) {
            return this.additionalTypes(additionalTypes).build();
        }

        @Deprecated
        public GraphQLSchema build(Set<GraphQLType> additionalTypes, Set<GraphQLDirective> additionalDirectives) {
            return this.additionalTypes(additionalTypes).additionalDirectives(additionalDirectives).build();
        }

        public GraphQLSchema build() {
            return this.buildImpl();
        }

        private GraphQLSchema buildImpl() {
            Assert.assertNotNull(this.additionalTypes, () -> "additionalTypes can't be null");
            Assert.assertNotNull(this.additionalDirectives, () -> "additionalDirectives can't be null");
            if (this.additionalDirectives.stream().noneMatch(d -> d.getName().equals(Directives.DeprecatedDirective.getName()))) {
                this.additionalDirectives.add(Directives.DeprecatedDirective);
            }
            if (this.additionalDirectives.stream().noneMatch(d -> d.getName().equals(Directives.SpecifiedByDirective.getName()))) {
                this.additionalDirectives.add(Directives.SpecifiedByDirective);
            }
            GraphQLSchema partiallyBuiltSchema = new GraphQLSchema(this);
            GraphQLCodeRegistry.Builder extractedDataFetchers = GraphQLCodeRegistry.newCodeRegistry(this.codeRegistry);
            CodeRegistryVisitor codeRegistryVisitor = new CodeRegistryVisitor(extractedDataFetchers);
            GraphQLTypeCollectingVisitor typeCollectingVisitor = new GraphQLTypeCollectingVisitor();
            SchemaUtil.visitPartiallySchema(partiallyBuiltSchema, codeRegistryVisitor, typeCollectingVisitor);
            this.codeRegistry = extractedDataFetchers.build();
            ImmutableMap<String, GraphQLNamedType> allTypes = typeCollectingVisitor.getResult();
            List allTypesAsList = GraphQLSchema.getAllTypesAsList(allTypes);
            ImmutableMap<String, List<GraphQLObjectType>> groupedImplementations = SchemaUtil.groupInterfaceImplementationsByName(allTypesAsList);
            ImmutableMap interfaceNameToObjectTypes = GraphQLSchema.buildInterfacesToObjectTypes(groupedImplementations);
            GraphQLSchema finalSchema = new GraphQLSchema(partiallyBuiltSchema, this.codeRegistry, allTypes, interfaceNameToObjectTypes);
            SchemaUtil.replaceTypeReferences(finalSchema);
            return this.validateSchema(finalSchema);
        }

        private GraphQLSchema validateSchema(GraphQLSchema graphQLSchema) {
            Set<SchemaValidationError> errors = new SchemaValidator().validateSchema(graphQLSchema);
            if (errors.size() > 0) {
                throw new InvalidSchemaException(errors);
            }
            return graphQLSchema;
        }
    }

    public static class BuilderWithoutTypes {
        private GraphQLCodeRegistry codeRegistry;
        private String description;
        private final GraphQLSchema existingSchema;

        private BuilderWithoutTypes(GraphQLSchema existingSchema) {
            this.existingSchema = existingSchema;
            this.codeRegistry = existingSchema.codeRegistry;
            this.description = existingSchema.description;
        }

        public BuilderWithoutTypes codeRegistry(GraphQLCodeRegistry codeRegistry) {
            this.codeRegistry = Assert.assertNotNull(codeRegistry);
            return this;
        }

        public BuilderWithoutTypes codeRegistry(GraphQLCodeRegistry.Builder codeRegistryBuilder) {
            return this.codeRegistry(codeRegistryBuilder.build());
        }

        public BuilderWithoutTypes description(String description) {
            this.description = description;
            return this;
        }

        public GraphQLSchema build() {
            return new GraphQLSchema(this);
        }
    }
}

