/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Internal;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.FillupIsolatedVertices;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Vertex;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
public class SortSourceGraph {
    public static void sortSourceGraph(SchemaGraph sourceGraph, SchemaGraph targetGraph, FillupIsolatedVertices.IsolatedVertices isolatedVertices) {
        LinkedHashMap<String, AtomicInteger> targetLabelCount = new LinkedHashMap<String, AtomicInteger>();
        for (Edge edge : targetGraph.getEdges()) {
            targetLabelCount.computeIfAbsent(edge.getLabel(), __ -> new AtomicInteger()).incrementAndGet();
        }
        LinkedHashMap<Vertex.VertexData, AtomicInteger> targetVertexDataCount = new LinkedHashMap<Vertex.VertexData, AtomicInteger>();
        for (Vertex targetVertex : targetGraph.getVertices()) {
            targetVertexDataCount.computeIfAbsent(targetVertex.toData(), __ -> new AtomicInteger()).incrementAndGet();
        }
        LinkedHashMap<Vertex, Integer> linkedHashMap = new LinkedHashMap<Vertex, Integer>();
        LinkedHashMap<Edge, Integer> edgesInfrequencyWeights = new LinkedHashMap<Edge, Integer>();
        for (Vertex vertex : sourceGraph.getVertices()) {
            linkedHashMap.put(vertex, 1 - targetVertexDataCount.getOrDefault(vertex.toData(), new AtomicInteger()).get());
        }
        for (Edge edge : sourceGraph.getEdges()) {
            edgesInfrequencyWeights.put(edge, 1 - targetLabelCount.getOrDefault(edge.getLabel(), new AtomicInteger()).get());
        }
        ArrayList<Vertex> nextCandidates = new ArrayList<Vertex>(sourceGraph.getVertices());
        nextCandidates.sort(Comparator.comparingInt(o -> SortSourceGraph.totalInfrequencyWeightWithAdjacentEdges(sourceGraph, o, vertexInfrequencyWeights, edgesInfrequencyWeights)));
        Vertex curVertex = nextCandidates.get(nextCandidates.size() - 1);
        nextCandidates.remove(nextCandidates.size() - 1);
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        result.add(curVertex);
        while (nextCandidates.size() > 0) {
            Vertex nextOne = null;
            int curMaxWeight = Integer.MIN_VALUE;
            int index = 0;
            int nextOneIndex = -1;
            for (Vertex candidate : nextCandidates) {
                List<Edge> allAdjacentEdges;
                int totalWeight = SortSourceGraph.totalInfrequencyWeightWithSomeEdges(candidate, allAdjacentEdges = sourceGraph.getAllAdjacentEdges(result, candidate), linkedHashMap, edgesInfrequencyWeights);
                if (totalWeight > curMaxWeight) {
                    nextOne = candidate;
                    nextOneIndex = index;
                    curMaxWeight = totalWeight;
                }
                ++index;
            }
            result.add(nextOne);
            nextCandidates.remove(nextOneIndex);
        }
        sourceGraph.setVertices(result);
    }

    private static int totalInfrequencyWeightWithSomeEdges(Vertex vertex, List<Edge> edges, Map<Vertex, Integer> vertexInfrequencyWeights, Map<Edge, Integer> edgesInfrequencyWeights) {
        if (vertex.isBuiltInType()) {
            return -2147483647;
        }
        if (vertex.isIsolated()) {
            return -2147483646;
        }
        return vertexInfrequencyWeights.get(vertex) + edges.stream().mapToInt(edgesInfrequencyWeights::get).sum();
    }

    private static int totalInfrequencyWeightWithAdjacentEdges(SchemaGraph sourceGraph, Vertex vertex, Map<Vertex, Integer> vertexInfrequencyWeights, Map<Edge, Integer> edgesInfrequencyWeights) {
        if (vertex.isBuiltInType()) {
            return -2147483647;
        }
        if (vertex.isIsolated()) {
            return -2147483646;
        }
        List<Edge> adjacentEdges = sourceGraph.getAdjacentEdges(vertex);
        return vertexInfrequencyWeights.get(vertex) + adjacentEdges.stream().mapToInt(edgesInfrequencyWeights::get).sum();
    }

    private int infrequencyWeightForVertex(Vertex sourceVertex, SchemaGraph targetGraph) {
        int count = 0;
        for (Vertex targetVertex : targetGraph.getVertices()) {
            if (!sourceVertex.isEqualTo(targetVertex)) continue;
            ++count;
        }
        return 1 - count;
    }

    private int infrequencyWeightForEdge(Edge sourceEdge, SchemaGraph targetGraph) {
        int count = 0;
        for (Edge targetEdge : targetGraph.getEdges()) {
            if (!sourceEdge.isEqualTo(targetEdge)) continue;
            ++count;
        }
        return 1 - count;
    }
}

