/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.def;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IDirectoryUtil;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.IResource;
import manifold.api.fs.def.FileSystemImpl;
import manifold.api.fs.def.JavaResourceImpl;

public class JavaDirectoryImpl
extends JavaResourceImpl
implements IDirectory {
    private FileRetrievalStrategy _fileRetrievalStrategy;

    public JavaDirectoryImpl(IFileSystem fileSystem, File file, IFileSystem.CachingMode cachingMode) {
        super(fileSystem, file);
        this.setCachingMode(cachingMode);
    }

    public void setCachingMode(IFileSystem.CachingMode cachingMode) {
        switch (cachingMode) {
            case NO_CACHING: {
                this._fileRetrievalStrategy = new UncachedFileRetrievalStrategy();
                break;
            }
            case CHECK_TIMESTAMPS: {
                this._fileRetrievalStrategy = new TimestampBasedCachingFileRetrievalStrategy();
                break;
            }
            case FUZZY_TIMESTAMPS: {
                this._fileRetrievalStrategy = new FuzzyTimestampCachingFileRetrievalStrategy();
                break;
            }
            case FULL_CACHING: {
                this._fileRetrievalStrategy = new FullyCachedFileRetrievalStrategy();
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized caching mode " + (Object)((Object)cachingMode));
            }
        }
    }

    @Override
    public void clearCaches() {
        if (this._fileRetrievalStrategy instanceof CachingFileRetrievalStrategy) {
            this.getFileSystem().getLock().lock();
            try {
                ((CachingFileRetrievalStrategy)this._fileRetrievalStrategy).clearCache();
            }
            finally {
                this.getFileSystem().getLock().unlock();
            }
        }
    }

    @Override
    public IDirectory dir(String relativePath) {
        File subDir = new File(this._file, relativePath);
        return this.getFileSystem().getIDirectory(subDir);
    }

    @Override
    public IFile file(String path) {
        File subFile = new File(this._file, path);
        return this.getFileSystem().getIFile(subFile);
    }

    @Override
    public boolean mkdir() throws IOException {
        return this._file.mkdir();
    }

    @Override
    public List<? extends IDirectory> listDirs() {
        return this._fileRetrievalStrategy.listDirs();
    }

    @Override
    public List<? extends IFile> listFiles() {
        return this._fileRetrievalStrategy.listFiles();
    }

    @Override
    public String relativePath(IResource resource) {
        return IDirectoryUtil.relativePath(this, resource);
    }

    @Override
    public boolean exists() {
        return this._file.isDirectory();
    }

    @Override
    public boolean hasChildFile(String path) {
        if (this._fileRetrievalStrategy instanceof FullyCachedFileRetrievalStrategy && path.indexOf(47) == -1 && path.indexOf(92) == -1) {
            for (IFile iFile : this.listFiles()) {
                if (!iFile.getName().equals(path)) continue;
                return true;
            }
            return false;
        }
        IFile childFile = this.file(path);
        return childFile != null && childFile.exists();
    }

    @Override
    public boolean isAdditional() {
        return false;
    }

    private class FullyCachedFileRetrievalStrategy
    extends CachingFileRetrievalStrategy {
        private FullyCachedFileRetrievalStrategy() {
        }

        @Override
        protected void refreshIfNecessary() {
            if (this._files == null) {
                this.refreshInfo();
            }
        }

        @Override
        protected void maybeSetTimestamp(File javaFile) {
        }
    }

    private class FuzzyTimestampCachingFileRetrievalStrategy
    extends CachingFileRetrievalStrategy {
        private long _lastFileTimestamp;
        private long _lastRefreshTimestamp;

        private FuzzyTimestampCachingFileRetrievalStrategy() {
        }

        @Override
        public void clearCache() {
            super.clearCache();
            this._lastFileTimestamp = -1L;
            this._lastRefreshTimestamp = -1L;
        }

        @Override
        protected void refreshIfNecessary() {
            if (this._lastFileTimestamp == -1L) {
                this.doRefreshImpl();
            } else {
                File file = JavaDirectoryImpl.this.toJavaFile();
                long currentTimestamp = file.lastModified();
                if (currentTimestamp == 0L) {
                    this._files = Collections.emptyList();
                    this._directories = Collections.emptyList();
                } else if (this._lastFileTimestamp != currentTimestamp) {
                    this.doRefreshImpl();
                } else {
                    long refreshDelta = this._lastRefreshTimestamp - currentTimestamp;
                    if (refreshDelta > -16L && refreshDelta < 16L) {
                        this.doRefreshImpl();
                    }
                }
            }
        }

        private void doRefreshImpl() {
            this._lastRefreshTimestamp = System.currentTimeMillis();
            this.refreshInfo();
        }

        @Override
        protected void maybeSetTimestamp(File javaFile) {
            this._lastFileTimestamp = javaFile.lastModified();
        }
    }

    private class TimestampBasedCachingFileRetrievalStrategy
    extends CachingFileRetrievalStrategy {
        private long _lastTimestamp;

        private TimestampBasedCachingFileRetrievalStrategy() {
        }

        @Override
        public void clearCache() {
            super.clearCache();
            this._lastTimestamp = -1L;
        }

        @Override
        protected void refreshIfNecessary() {
            if (this._lastTimestamp == -1L) {
                this.refreshInfo();
            } else {
                File file = JavaDirectoryImpl.this.toJavaFile();
                long currentTimestamp = file.lastModified();
                if (currentTimestamp == 0L) {
                    this._files = Collections.emptyList();
                    this._directories = Collections.emptyList();
                } else if (this._lastTimestamp != currentTimestamp) {
                    this.refreshInfo();
                }
            }
        }

        @Override
        protected void maybeSetTimestamp(File javaFile) {
            this._lastTimestamp = javaFile.lastModified();
        }
    }

    private abstract class CachingFileRetrievalStrategy
    implements FileRetrievalStrategy {
        protected List<IDirectory> _directories;
        protected List<IFile> _files;

        private CachingFileRetrievalStrategy() {
        }

        public void clearCache() {
            this._directories = null;
            this._files = null;
        }

        public List<IDirectory> listDirs() {
            JavaDirectoryImpl.this.getFileSystem().getLock().lock();
            try {
                this.refreshIfNecessary();
                List<IDirectory> list = this._directories;
                return list;
            }
            finally {
                JavaDirectoryImpl.this.getFileSystem().getLock().unlock();
            }
        }

        public List<IFile> listFiles() {
            JavaDirectoryImpl.this.getFileSystem().getLock().lock();
            try {
                this.refreshIfNecessary();
                List<IFile> list = this._files;
                return list;
            }
            finally {
                JavaDirectoryImpl.this.getFileSystem().getLock().unlock();
            }
        }

        protected void refreshInfo() {
            this._files = new ArrayList<IFile>();
            this._directories = new ArrayList<IDirectory>();
            File javaFile = JavaDirectoryImpl.this.toJavaFile();
            this.maybeSetTimestamp(javaFile);
            File[] files = javaFile.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (FileSystemImpl.isDirectory(f)) {
                        this._directories.add(JavaDirectoryImpl.this.getFileSystem().getIDirectory(f));
                        continue;
                    }
                    this._files.add(JavaDirectoryImpl.this.getFileSystem().getIFile(f));
                }
            }
            if (this._directories.isEmpty()) {
                this._directories = Collections.emptyList();
            } else {
                ((ArrayList)this._directories).trimToSize();
            }
            if (this._files.isEmpty()) {
                this._files = Collections.emptyList();
            } else {
                ((ArrayList)this._files).trimToSize();
            }
        }

        protected abstract void refreshIfNecessary();

        protected abstract void maybeSetTimestamp(File var1);
    }

    private class UncachedFileRetrievalStrategy
    implements FileRetrievalStrategy {
        private UncachedFileRetrievalStrategy() {
        }

        @Override
        public List<? extends IDirectory> listDirs() {
            ArrayList<IDirectory> results = new ArrayList<IDirectory>();
            File[] files = JavaDirectoryImpl.this._file.listFiles();
            if (files != null) {
                for (File f : JavaDirectoryImpl.this._file.listFiles()) {
                    if (!FileSystemImpl.isDirectory(f)) continue;
                    results.add(JavaDirectoryImpl.this.getFileSystem().getIDirectory(f));
                }
            }
            return results;
        }

        @Override
        public List<? extends IFile> listFiles() {
            ArrayList<IFile> results = new ArrayList<IFile>();
            File[] files = JavaDirectoryImpl.this._file.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (FileSystemImpl.isDirectory(f)) continue;
                    results.add(JavaDirectoryImpl.this.getFileSystem().getIFile(f));
                }
            }
            return results;
        }
    }

    private static interface FileRetrievalStrategy {
        public List<? extends IDirectory> listDirs();

        public List<? extends IFile> listFiles();
    }
}

