/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.fs.jar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IDirectoryUtil;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileSystem;
import manifold.api.fs.IResource;
import manifold.api.fs.jar.IJarFileDirectory;
import manifold.api.fs.jar.JarEntryFileImpl;
import manifold.api.fs.jar.JarEntryResourceImpl;
import manifold.api.fs.jar.JarFileDirectoryImpl;

public class JarEntryDirectoryImpl
extends JarEntryResourceImpl
implements IJarFileDirectory {
    private Map<String, JarEntryDirectoryImpl> _directories = new HashMap<String, JarEntryDirectoryImpl>();
    private Map<String, JarEntryFileImpl> _files = new HashMap<String, JarEntryFileImpl>();
    private List<IDirectory> _childDirs = new ArrayList<IDirectory>();
    private List<IFile> _childFiles = new ArrayList<IFile>();

    public JarEntryDirectoryImpl(IFileSystem fs, String name, IJarFileDirectory parent, JarFileDirectoryImpl jarFile) {
        super(fs, name, parent, jarFile);
    }

    @Override
    public JarEntryDirectoryImpl getOrCreateDirectory(String relativeName) {
        JarEntryDirectoryImpl result = this._directories.get(relativeName);
        if (result == null) {
            result = new JarEntryDirectoryImpl(this.getFileSystem(), relativeName, this, this._jarFile);
            this._directories.put(relativeName, result);
            this._childDirs.add(result);
        }
        return result;
    }

    @Override
    public JarEntryFileImpl getOrCreateFile(String relativeName) {
        JarEntryFileImpl result = this._files.get(relativeName);
        if (result == null) {
            result = new JarEntryFileImpl(this.getFileSystem(), relativeName, this, this._jarFile);
            this._files.put(relativeName, result);
            this._childFiles.add(result);
        }
        return result;
    }

    @Override
    public IDirectory dir(String relativePath) {
        return IDirectoryUtil.dir(this, relativePath);
    }

    @Override
    public IFile file(String path) {
        return IDirectoryUtil.file(this, path);
    }

    @Override
    public boolean mkdir() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends IDirectory> listDirs() {
        ArrayList<IDirectory> results = new ArrayList<IDirectory>();
        for (IDirectory child : this._childDirs) {
            if (!child.exists()) continue;
            results.add(child);
        }
        return results;
    }

    @Override
    public List<? extends IFile> listFiles() {
        ArrayList<IFile> results = new ArrayList<IFile>();
        for (IFile child : this._childFiles) {
            if (!child.exists()) continue;
            results.add(child);
        }
        return results;
    }

    @Override
    public String relativePath(IResource resource) {
        return IDirectoryUtil.relativePath(this, resource);
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public boolean hasChildFile(String path) {
        IFile childFile = this.file(path);
        return childFile != null && childFile.exists();
    }

    @Override
    public boolean isAdditional() {
        return false;
    }
}

