/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import manifold.api.fs.IFile;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;

public class SourceSupplier {
    private String _fqn;
    private Supplier<String> _supplier;
    private final Set<ITypeManifold> _sps;

    public SourceSupplier(String fqn, Set<ITypeManifold> tms, Supplier<String> supplier) {
        this._fqn = fqn;
        this._supplier = supplier;
        this._sps = tms;
    }

    public String getSource() {
        return this._supplier.get();
    }

    public boolean isPrimary() {
        return this._sps == null || this._sps.isEmpty() || this._sps.stream().anyMatch(e -> e.getContributorKind() == ContributorKind.Primary || e.getContributorKind() == ContributorKind.Partial);
    }

    public boolean isSelfCompile(String fqn) {
        return this._sps == null || this._sps.isEmpty() || this._sps.stream().anyMatch(tm -> tm.isSelfCompile(fqn));
    }

    public void parse(String fqn) {
        this._sps.stream().filter(tm -> tm.isSelfCompile(fqn)).findFirst().orElseThrow(IllegalStateException::new).parse(fqn);
    }

    public byte[] compile(String fqn) {
        return this._sps.stream().filter(tm -> tm.isSelfCompile(fqn)).findFirst().orElseThrow(IllegalStateException::new).compile(fqn);
    }

    public Set<IFile> getResourceFiles() {
        return this._sps.stream().flatMap(tm -> tm.findFilesForType(this._fqn).stream()).collect(Collectors.toSet());
    }
}

