/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.rt.parser;

import manifold.js.rt.parser.ParseContext;
import manifold.js.rt.parser.TemplateParser;
import manifold.js.rt.parser.TemplateTokenizer;
import manifold.js.rt.parser.Token;
import manifold.js.rt.parser.TokenType;
import manifold.js.rt.parser.Tokenizer;
import manifold.js.rt.parser.tree.ArrowExpressionNode;
import manifold.js.rt.parser.tree.ClassFunctionNode;
import manifold.js.rt.parser.tree.ClassNode;
import manifold.js.rt.parser.tree.ConstructorNode;
import manifold.js.rt.parser.tree.FillerNode;
import manifold.js.rt.parser.tree.FunctionBodyNode;
import manifold.js.rt.parser.tree.FunctionNode;
import manifold.js.rt.parser.tree.ImportNode;
import manifold.js.rt.parser.tree.Node;
import manifold.js.rt.parser.tree.ParameterNode;
import manifold.js.rt.parser.tree.ProgramNode;
import manifold.js.rt.parser.tree.PropertyNode;

public class Parser {
    private ClassNode _classNode;
    private ProgramNode _programNode;
    private Tokenizer _tokenizer;
    private Token _currentToken;
    private Token _nextToken;
    private ParseContext _context;

    public Parser(Tokenizer tokenizer) {
        this._tokenizer = tokenizer;
        this._programNode = new ProgramNode(tokenizer.getUrl());
        this._context = new ParseContext();
    }

    public boolean isES6Class() {
        return this._classNode != null;
    }

    public Node parse() {
        this.nextToken();
        this.parseImports();
        this.parseClassStatement();
        if (!this.isES6Class() && !this.match(TokenType.EOF)) {
            this.addParseFillerUntil(this._programNode, () -> this.match(TokenType.EOF));
        }
        return this._programNode;
    }

    private void parseClassStatement() {
        if (this.match(TokenType.CLASS)) {
            this.nextToken();
            Token className = this._currentToken;
            this.skip(this.match(TokenType.IDENTIFIER));
            this._classNode = new ClassNode(className.getValue());
            this._programNode.addChild(this._classNode);
            if (this.matchKeyword("extends")) {
                this.skip(this.matchKeyword("extends"));
                StringBuffer sb = new StringBuffer();
                while (this.match(TokenType.IDENTIFIER)) {
                    sb.append(this._currentToken.getValue());
                    this.skip(this.match(TokenType.IDENTIFIER));
                    if (!this.match('.')) break;
                    this.skip(this.match('.'));
                    sb.append('.');
                }
                this._classNode.setSuperClass(sb.toString());
            }
            this.skip(this.match('{'));
            this.parseClassBody(className.getValue());
            this.skip(this.match('}'));
            Token end = this._currentToken;
            this._classNode.setTokens(className, end);
        }
    }

    private void parseImports() {
        while (this.matchKeyword("import") && !this.match(TokenType.EOF)) {
            this._programNode.addChild(this.parseImport());
            if (!this.match(';')) continue;
            this.nextToken();
        }
    }

    protected ImportNode parseImport() {
        Token start = this._currentToken;
        this.skip(this.matchKeyword("import"));
        StringBuilder packageName = new StringBuilder();
        Matcher matcher = () -> this.match(TokenType.IDENTIFIER);
        while (matcher.match()) {
            this.concatToken(packageName);
            if (this.match(TokenType.IDENTIFIER)) {
                matcher = () -> this.match('.');
            }
            if (this.match('.')) {
                matcher = () -> this.match(TokenType.IDENTIFIER);
            }
            this.nextToken();
        }
        ImportNode importNode = new ImportNode(packageName.toString());
        importNode.setTokens(start, this._currentToken);
        return importNode;
    }

    private void parseClassBody(String className) {
        while (!this.match('}') && !this.match(TokenType.EOF)) {
            if (this.matchClassKeyword("constructor")) {
                this._classNode.addChild(this.parseConstructor(className));
                continue;
            }
            if (this.matchClassKeyword("static")) {
                Token staticToken = this._currentToken;
                this.nextToken();
                if (this.matchClassKeyword("get") || this.matchClassKeyword("set")) {
                    this._classNode.addChild(this.parseStaticProperty(className, staticToken));
                    continue;
                }
                this._classNode.addChild(this.parseStaticFunction(className, staticToken));
                continue;
            }
            if (this.matchClassKeyword("get") || this.matchClassKeyword("set")) {
                this._classNode.addChild(this.parseProperty(className));
                continue;
            }
            if (this.match(TokenType.IDENTIFIER)) {
                ClassFunctionNode functionNode = this.parseClassFunction(className);
                this._classNode.addChild(functionNode);
                continue;
            }
            this.error("Unexpected token: " + this._currentToken.toString());
            this.nextToken();
        }
    }

    private ConstructorNode parseConstructor(String className) {
        Token start = this._currentToken;
        this.skip(this.matchClassKeyword("constructor"));
        ConstructorNode constructorNode = new ConstructorNode(className);
        constructorNode.setTokens(start, null);
        this.addParseFunctionParamAndBody(constructorNode);
        this.nextToken();
        return constructorNode;
    }

    private ClassFunctionNode parseStaticFunction(String className, Token staticToken) {
        ClassFunctionNode functionNode = (ClassFunctionNode)this.parseFunction(className);
        functionNode.setTokens(staticToken, functionNode.getEnd());
        functionNode.setStatic(true);
        return functionNode;
    }

    private ClassFunctionNode parseClassFunction(String className) {
        this.expect(this.match(TokenType.IDENTIFIER));
        this._context.inOverrideFunction = this.isOverrideFunction(this._currentToken.getValue());
        ClassFunctionNode functionNode = (ClassFunctionNode)this.parseFunction(className);
        functionNode.setOverride(this._context.inOverrideFunction);
        this._context.inOverrideFunction = false;
        return functionNode;
    }

    private FunctionNode parseFunction(String className) {
        Token start = this._currentToken;
        String functionName = start.getValue();
        this.skip(this.match(TokenType.IDENTIFIER));
        FunctionNode functionNode = className != null ? new ClassFunctionNode(functionName, className, false) : new FunctionNode(functionName);
        functionNode.setTokens(start, null);
        this.addParseFunctionParamAndBody(functionNode);
        this.nextToken();
        return functionNode;
    }

    private PropertyNode parseStaticProperty(String className, Token staticToken) {
        PropertyNode propertyNode = this.parseProperty(className);
        propertyNode.setTokens(staticToken, propertyNode.getEnd());
        propertyNode.setStatic(true);
        return propertyNode;
    }

    private PropertyNode parseProperty(String className) {
        boolean isSetter = this.matchClassKeyword("set");
        this.skip(this.matchClassKeyword("get") || this.matchClassKeyword("set"));
        Token start = this._currentToken;
        String functionName = this._currentToken.getValue();
        this.skip(this.match(TokenType.IDENTIFIER));
        PropertyNode node = new PropertyNode(functionName, className, false, isSetter);
        node.setTokens(start, null);
        this.addParseFunctionParamAndBody(node);
        this.nextToken();
        return node;
    }

    protected ParameterNode parseParams() {
        this.skip(this.match('('));
        ParameterNode paramNode = new ParameterNode();
        Matcher matcher = () -> this.match(')') || this.match(TokenType.IDENTIFIER);
        this.expect(matcher);
        while (!this.match(')') && !this.match(TokenType.EOF)) {
            if (this.match(TokenType.IDENTIFIER)) {
                matcher = () -> this.match(',') || this.match(')') || this.match(':');
                String paramValue = this._currentToken.getValue();
                paramNode.addParam(paramValue, this.parseType());
            } else if (this.match(',')) {
                matcher = () -> this.match(TokenType.IDENTIFIER);
            }
            this.nextToken();
            this.expect(matcher);
        }
        this.skip(this.match(')'));
        return paramNode;
    }

    private String parseReturnType() {
        if (this._currentToken.getValue().equals(":")) {
            this.nextToken();
            String returnType = this._currentToken.getValue();
            this.nextToken();
            return returnType;
        }
        return "java.lang.Object";
    }

    private String parseType() {
        if (this.peekToken().getValue().equals(":")) {
            this.nextToken();
            this.nextToken();
            return this._currentToken.getValue();
        }
        return null;
    }

    private FunctionBodyNode parseFunctionBody(String functionName) {
        FunctionBodyNode bodyNode = new FunctionBodyNode(functionName);
        int currCurlyCount = this._context.getCurlyCount() - 1;
        this.addParseFillerUntil(bodyNode, () -> this._context.getCurlyCount() <= currCurlyCount);
        FillerNode lastCurly = new FillerNode();
        lastCurly.concatToken(this._currentToken);
        bodyNode.addChild(lastCurly);
        return bodyNode;
    }

    private void addParseFunctionParamAndBody(FunctionNode parent) {
        ParameterNode params = this.parseParams();
        String returnType = this.parseReturnType();
        FunctionBodyNode body = this.parseFunctionBody(parent.getName());
        parent.setReturnType(returnType);
        this.expect(this.match('}'));
        parent.setTokens(parent.getStart(), this._currentToken);
        parent.addChild(params);
        parent.addChild(body);
    }

    private void addParseFillerUntil(Node parent, Matcher matcher) {
        FillerNode fillerNode = this.parseFillerUntil(() -> this.matchOperator("=>") || this.match(TokenType.TEMPLATESTRING) || this.matchKeyword("function") && this._context.curlyCount == 0 || matcher.match());
        if (this.matchOperator("=>")) {
            this.skip(this.matchOperator("=>"));
            ArrowExpressionNode arrowNode = new ArrowExpressionNode();
            arrowNode.extractParams(fillerNode);
            parent.addChild(fillerNode);
            parent.addChild(arrowNode);
            this.addParseFillerUntil(parent, matcher);
        } else if (this.match(TokenType.TEMPLATESTRING)) {
            TemplateParser templateParser = new TemplateParser(new TemplateTokenizer(this.currToken().getValue(), false));
            Node templateNode = templateParser.parse();
            parent.addChild(fillerNode);
            parent.addChild(templateNode);
            this.nextToken();
            this.addParseFillerUntil(parent, matcher);
        } else if (this.matchKeyword("function") && this._context.curlyCount == 0) {
            this.skip(this.matchKeyword("function"));
            parent.addChild(fillerNode);
            FunctionNode functionNode = this.parseFunction(null);
            parent.addChild(functionNode);
            this.addParseFillerUntil(parent, matcher);
        } else {
            parent.addChild(fillerNode);
        }
    }

    protected FillerNode parseFillerUntil(Matcher matcher) {
        FillerNode fillerNode = new FillerNode(this._context.inOverrideFunction);
        while (!this.match(TokenType.EOF) && !matcher.match()) {
            fillerNode.concatToken(this._currentToken);
            this.nextAnyToken();
        }
        return fillerNode;
    }

    private void concatToken(StringBuilder val2) {
        val2.append(this._currentToken.getValue());
    }

    protected boolean expect(Matcher matcher) {
        boolean matched = matcher.match();
        if (!matched) {
            this.expect(false);
        }
        return matched;
    }

    protected boolean expect(boolean assertion) {
        if (!assertion) {
            this.error("Unexpected Token: " + this._currentToken.toString());
        }
        return assertion;
    }

    protected void skip(boolean b) {
        this.expect(b);
        this.nextToken();
    }

    private void error(String errorMsg) {
        this._programNode.addError(errorMsg, this.currToken());
    }

    protected boolean match(char c) {
        return this.match(TokenType.PUNCTUATION, String.valueOf(c));
    }

    protected boolean matchOperator(String val2) {
        return this.match(TokenType.OPERATOR, val2);
    }

    protected boolean matchKeyword(String val2) {
        return this.match(TokenType.KEYWORD, val2);
    }

    protected boolean matchClassKeyword(String val2) {
        if (!this.match(TokenType.IDENTIFIER, val2)) {
            return false;
        }
        return !val2.equals("static") && !val2.equals("get") && !val2.equals("set") || this.peekToken().getType() == TokenType.IDENTIFIER;
    }

    protected boolean match(TokenType type, String val2) {
        return this.match(type) && this._currentToken.getValue().equals(val2);
    }

    protected boolean matchIgnoreWhitespace(TokenType type, String val2) {
        return this.match(type) && this._currentToken.getValue().trim().equals(val2);
    }

    protected boolean match(TokenType type) {
        return this._currentToken.getType() == type;
    }

    private Token peekToken() {
        if (this._nextToken == null || this._nextToken.getOffset() <= this._currentToken.getOffset()) {
            this._nextToken = this._tokenizer.nextNonWhiteSpace();
        }
        return this._nextToken;
    }

    protected Token currToken() {
        return this._currentToken;
    }

    private boolean isOverrideFunction(String functionName) {
        if (this._classNode == null) {
            return false;
        }
        String packageName = this._programNode.getPackageFromClassName(this._classNode.getSuperClass());
        if (packageName == null) {
            return false;
        }
        return false;
    }

    private void nextAnyToken() {
        this._currentToken = this._tokenizer.next();
        if (this.match('{')) {
            ++this._context.curlyCount;
        }
        if (this.match('}')) {
            --this._context.curlyCount;
        }
    }

    protected void nextToken() {
        this._currentToken = this._currentToken == null || this._nextToken == null || this._currentToken.getOffset() >= this._nextToken.getOffset() ? this._tokenizer.nextNonWhiteSpace() : this._nextToken;
        if (this.match('{')) {
            ++this._context.curlyCount;
        }
        if (this.match('}')) {
            --this._context.curlyCount;
        }
    }

    protected static interface Matcher {
        public boolean match();
    }
}

