/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.expression;

import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.preprocessor.definitions.Definitions;
import manifold.preprocessor.expression.Expression;
import manifold.preprocessor.expression.ExpressionTokenType;
import manifold.preprocessor.expression.NumberLiteral;

public class EqualityExpression
extends Expression {
    private final Expression _lhs;
    private final Expression _rhs;
    private final boolean _not;

    EqualityExpression(Expression lhs, Expression rhs, boolean not, int start, int end) {
        super(start, end);
        this._lhs = lhs;
        this._rhs = rhs;
        this._not = not;
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> children = new ArrayList<Expression>();
        children.add(this._lhs);
        children.add(this._rhs);
        return children;
    }

    @Override
    public boolean evaluate(Definitions definitions) {
        if (this._lhs instanceof NumberLiteral || this._rhs instanceof NumberLiteral) {
            BigDecimal lhsNumber = this.getNumberValue(this._lhs, definitions);
            if (lhsNumber == null) {
                this.generateError(this._lhs, definitions);
                return false;
            }
            BigDecimal rhsNumber = this.getNumberValue(this._rhs, definitions);
            if (rhsNumber == null) {
                this.generateError(this._rhs, definitions);
                return false;
            }
            return this._not != (lhsNumber.compareTo(rhsNumber) == 0);
        }
        return this._not != (this._lhs.evaluate(definitions) == this._rhs.evaluate(definitions) && Objects.equals(this._lhs.getValue(definitions), this._rhs.getValue(definitions)));
    }

    public BigDecimal getNumberValue(Expression operand, Definitions definitions) {
        String value = operand.getValue(definitions);
        try {
            return new BigDecimal(value.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void generateError(Expression expr, Definitions definitions) {
        if (JavacPlugin.instance() != null) {
            String value = expr.getValue(definitions);
            IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), new JCDiagnostic.SimpleDiagnosticPosition(expr.getStartOffset()), "proc.messager", "Numeric value expected for '" + expr + "', but was '" + value + "'");
        }
    }

    public String toString() {
        return this._lhs + (this._not ? ExpressionTokenType.NotEquals.getToken() : ExpressionTokenType.Equals.getToken()) + this._rhs;
    }
}

