/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.execution.CoercedVariables;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.RawVariables;
import graphql.execution.TypeFromAST;
import graphql.execution.ValuesResolverConversion;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.InputValueWithState;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import manifold.shade.org.jetbrains.annotations.NotNull;
import manifold.shade.org.jetbrains.annotations.Nullable;

@Internal
public class ValuesResolver {
    private ValuesResolver() {
    }

    public static CoercedVariables coerceVariableValues(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, RawVariables rawVariables, GraphQLContext graphqlContext, Locale locale) throws CoercingParseValueException, NonNullableValueCoercedAsNullException {
        return ValuesResolverConversion.externalValueToInternalValueForVariables(schema, variableDefinitions, rawVariables, graphqlContext, locale);
    }

    public static Map<String, NormalizedInputValue> getNormalizedVariableValues(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, RawVariables rawVariables, GraphQLContext graphqlContext, Locale locale) {
        GraphqlFieldVisibility fieldVisibility = schema.getCodeRegistry().getFieldVisibility();
        LinkedHashMap<String, NormalizedInputValue> result = new LinkedHashMap<String, NormalizedInputValue>();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            String variableName = variableDefinition.getName();
            GraphQLType variableType = TypeFromAST.getTypeFromAST(schema, variableDefinition.getType());
            Assert.assertTrue(variableType instanceof GraphQLInputType);
            Value defaultValue = variableDefinition.getDefaultValue();
            boolean hasValue = rawVariables.containsKey(variableName);
            Object value = rawVariables.get(variableName);
            if (!hasValue && defaultValue != null) {
                result.put(variableName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(variableType), defaultValue));
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(variableType) && (!hasValue || value == null)) {
                return (Map)Assert.assertShouldNeverHappen("variable values are expected to be valid", new Object[0]);
            }
            if (!hasValue) continue;
            if (value == null) {
                result.put(variableName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(variableType), null));
                continue;
            }
            Object literal = ValuesResolverConversion.externalValueToLiteral(fieldVisibility, value, (GraphQLInputType)variableType, ValueMode.NORMALIZED, graphqlContext, locale);
            result.put(variableName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(variableType), literal));
        }
        return result;
    }

    public static Map<String, Object> getArgumentValues(List<GraphQLArgument> argumentTypes, List<Argument> arguments, CoercedVariables coercedVariables, GraphQLContext graphqlContext, Locale locale) {
        return ValuesResolver.getArgumentValuesImpl(DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY, argumentTypes, arguments, coercedVariables, graphqlContext, locale);
    }

    public static Map<String, NormalizedInputValue> getNormalizedArgumentValues(List<GraphQLArgument> argumentTypes, List<Argument> arguments, Map<String, NormalizedInputValue> normalizedVariables) {
        if (argumentTypes.isEmpty()) {
            return ImmutableKit.emptyMap();
        }
        LinkedHashMap<String, NormalizedInputValue> result = new LinkedHashMap<String, NormalizedInputValue>();
        Map<String, Argument> argumentMap = ValuesResolver.argumentMap(arguments);
        for (GraphQLArgument argumentDefinition : argumentTypes) {
            String argumentName = argumentDefinition.getName();
            Argument argument = argumentMap.get(argumentName);
            if (argument == null || ValuesResolver.isVariableAbsent(argument.getValue(), normalizedVariables)) continue;
            GraphQLInputType argumentType = argumentDefinition.getType();
            Object value = ValuesResolver.literalToNormalizedValue(DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY, argumentType, argument.getValue(), normalizedVariables);
            result.put(argumentName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(argumentType), value));
        }
        return result;
    }

    public static Map<String, Object> getArgumentValues(GraphQLCodeRegistry codeRegistry, List<GraphQLArgument> argumentTypes, List<Argument> arguments, CoercedVariables coercedVariables, GraphQLContext graphqlContext, Locale locale) {
        return ValuesResolver.getArgumentValuesImpl(codeRegistry.getFieldVisibility(), argumentTypes, arguments, coercedVariables, graphqlContext, locale);
    }

    public static Value<?> valueToLiteral(@NotNull GraphqlFieldVisibility fieldVisibility, @NotNull InputValueWithState inputValueWithState, @NotNull GraphQLType type, GraphQLContext graphqlContext, Locale locale) {
        return (Value)ValuesResolverConversion.valueToLiteralImpl(fieldVisibility, inputValueWithState, type, ValueMode.LITERAL, graphqlContext, locale);
    }

    public static Value<?> valueToLiteral(@NotNull InputValueWithState inputValueWithState, @NotNull GraphQLType type, GraphQLContext graphqlContext, Locale locale) {
        return (Value)ValuesResolverConversion.valueToLiteralImpl(DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY, inputValueWithState, type, ValueMode.LITERAL, graphqlContext, locale);
    }

    public static Object valueToInternalValue(InputValueWithState inputValueWithState, GraphQLType type, GraphQLContext graphqlContext, Locale locale) throws CoercingParseValueException, CoercingParseLiteralException {
        return ValuesResolverConversion.valueToInternalValueImpl(inputValueWithState, type, graphqlContext, locale);
    }

    public static Object externalValueToInternalValue(GraphqlFieldVisibility fieldVisibility, Object externalValue, GraphQLInputType type, GraphQLContext graphqlContext, Locale locale) {
        return ValuesResolverConversion.externalValueToInternalValueImpl(fieldVisibility, type, externalValue, graphqlContext, locale);
    }

    @Nullable
    public static <T> T getInputValueImpl(GraphQLInputType inputType, InputValueWithState inputValue, GraphQLContext graphqlContext, Locale locale) {
        if (inputValue.isNotSet()) {
            return null;
        }
        return (T)ValuesResolver.valueToInternalValue(inputValue, inputType, graphqlContext, locale);
    }

    private static Map<String, Object> getArgumentValuesImpl(GraphqlFieldVisibility fieldVisibility, List<GraphQLArgument> argumentTypes, List<Argument> arguments, CoercedVariables coercedVariables, GraphQLContext graphqlContext, Locale locale) {
        if (argumentTypes.isEmpty()) {
            return ImmutableKit.emptyMap();
        }
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        Map<String, Argument> argumentMap = ValuesResolver.argumentMap(arguments);
        for (GraphQLArgument argumentDefinition : argumentTypes) {
            Object value;
            Value argumentValue;
            GraphQLInputType argumentType = argumentDefinition.getType();
            String argumentName = argumentDefinition.getName();
            Argument argument = argumentMap.get(argumentName);
            InputValueWithState defaultValue = argumentDefinition.getArgumentDefaultValue();
            boolean hasValue = argument != null;
            Value value2 = argumentValue = argument != null ? argument.getValue() : null;
            if (argumentValue instanceof VariableReference) {
                String variableName = ((VariableReference)argumentValue).getName();
                hasValue = coercedVariables.containsKey(variableName);
                value = coercedVariables.get(variableName);
            } else {
                value = argumentValue;
            }
            if (!hasValue && argumentDefinition.hasSetDefaultValue()) {
                Object coercedDefaultValue = ValuesResolverConversion.defaultValueToInternalValue(fieldVisibility, defaultValue, argumentType, graphqlContext, locale);
                coercedValues.put(argumentName, coercedDefaultValue);
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(argumentType) && (!hasValue || ValuesResolverConversion.isNullValue(value))) {
                throw new NonNullableValueCoercedAsNullException(argumentDefinition);
            }
            if (!hasValue) continue;
            if (ValuesResolverConversion.isNullValue(value)) {
                coercedValues.put(argumentName, value);
                continue;
            }
            if (argumentValue instanceof VariableReference) {
                coercedValues.put(argumentName, value);
                continue;
            }
            value = ValuesResolverConversion.literalToInternalValue(fieldVisibility, argumentType, argument.getValue(), coercedVariables, graphqlContext, locale);
            coercedValues.put(argumentName, value);
        }
        return coercedValues;
    }

    private static Map<String, Argument> argumentMap(List<Argument> arguments) {
        LinkedHashMap<String, Argument> result = new LinkedHashMap<String, Argument>(arguments.size());
        for (Argument argument : arguments) {
            result.put(argument.getName(), argument);
        }
        return result;
    }

    public static Object literalToNormalizedValue(GraphqlFieldVisibility fieldVisibility, GraphQLType type, Value inputValue, Map<String, NormalizedInputValue> normalizedVariables) {
        if (inputValue instanceof VariableReference) {
            String varName = ((VariableReference)inputValue).getName();
            return normalizedVariables.get(varName).getValue();
        }
        if (inputValue instanceof NullValue) {
            return null;
        }
        if (type instanceof GraphQLScalarType) {
            return inputValue;
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return ValuesResolver.literalToNormalizedValue(fieldVisibility, GraphQLTypeUtil.unwrapOne(type), inputValue, normalizedVariables);
        }
        if (type instanceof GraphQLInputObjectType) {
            return ValuesResolver.literalToNormalizedValueForInputObject(fieldVisibility, (GraphQLInputObjectType)type, (ObjectValue)inputValue, normalizedVariables);
        }
        if (type instanceof GraphQLEnumType) {
            return inputValue;
        }
        if (GraphQLTypeUtil.isList(type)) {
            return ValuesResolver.literalToNormalizedValueForList(fieldVisibility, (GraphQLList)type, inputValue, normalizedVariables);
        }
        return null;
    }

    private static Object literalToNormalizedValueForInputObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType type, ObjectValue inputObjectLiteral, Map<String, NormalizedInputValue> normalizedVariables) {
        LinkedHashMap<String, NormalizedInputValue> result = new LinkedHashMap<String, NormalizedInputValue>();
        for (ObjectField field : inputObjectLiteral.getObjectFields()) {
            if (ValuesResolver.isVariableAbsent(field.getValue(), normalizedVariables)) continue;
            GraphQLInputType fieldType = type.getField(field.getName()).getType();
            Object fieldValue = ValuesResolver.literalToNormalizedValue(fieldVisibility, fieldType, field.getValue(), normalizedVariables);
            result.put(field.getName(), new NormalizedInputValue(GraphQLTypeUtil.simplePrint(fieldType), fieldValue));
        }
        return result;
    }

    private static List<Object> literalToNormalizedValueForList(GraphqlFieldVisibility fieldVisibility, GraphQLList type, Value value, Map<String, NormalizedInputValue> normalizedVariables) {
        if (value instanceof ArrayValue) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Value valueInArray : ((ArrayValue)value).getValues()) {
                result.add(ValuesResolver.literalToNormalizedValue(fieldVisibility, type.getWrappedType(), valueInArray, normalizedVariables));
            }
            return result;
        }
        return Collections.singletonList(ValuesResolver.literalToNormalizedValue(fieldVisibility, type.getWrappedType(), value, normalizedVariables));
    }

    private static boolean isVariableAbsent(Value value, Map<String, NormalizedInputValue> variables) {
        if (value instanceof VariableReference) {
            VariableReference varRef = (VariableReference)value;
            return !variables.containsKey(varRef.getName());
        }
        return false;
    }

    public static enum ValueMode {
        LITERAL,
        NORMALIZED;

    }
}

