/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.directives;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.execution.CoercedVariables;
import graphql.execution.ValuesResolver;
import graphql.language.Directive;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLSchema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Internal
public class DirectivesResolver {
    public Map<String, GraphQLDirective> resolveDirectives(List<Directive> directives, GraphQLSchema schema, Map<String, Object> variables, GraphQLContext graphQLContext, Locale locale) {
        GraphQLCodeRegistry codeRegistry = schema.getCodeRegistry();
        LinkedHashMap directiveMap = new LinkedHashMap();
        directives.forEach(directive -> {
            GraphQLDirective protoType = schema.getDirective(directive.getName());
            if (protoType != null) {
                GraphQLDirective newDirective = protoType.transform(builder -> this.buildArguments((GraphQLDirective.Builder)builder, codeRegistry, protoType, (Directive)directive, variables, graphQLContext, locale));
                directiveMap.put(newDirective.getName(), newDirective);
            }
        });
        return ImmutableMap.copyOf(directiveMap);
    }

    private void buildArguments(GraphQLDirective.Builder directiveBuilder, GraphQLCodeRegistry codeRegistry, GraphQLDirective protoType, Directive fieldDirective, Map<String, Object> variables, GraphQLContext graphQLContext, Locale locale) {
        Map<String, Object> argumentValues = ValuesResolver.getArgumentValues(codeRegistry, protoType.getArguments(), fieldDirective.getArguments(), CoercedVariables.of(variables), graphQLContext, locale);
        directiveBuilder.clearArguments();
        protoType.getArguments().forEach(protoArg -> {
            if (argumentValues.containsKey(protoArg.getName())) {
                Object argValue = argumentValues.get(protoArg.getName());
                GraphQLArgument newArgument = protoArg.transform(argBuilder -> argBuilder.value(argValue));
                directiveBuilder.argument(newArgument);
            } else {
                GraphQLArgument newArgument = protoArg.transform(argBuilder -> argBuilder.value(null));
                directiveBuilder.argument(newArgument);
            }
        });
    }
}

