/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.dataloader.FieldLevelTrackingApproach;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import manifold.shade.org.dataloader.DataLoader;
import manifold.shade.org.dataloader.DataLoaderRegistry;
import manifold.shade.org.slf4j.Logger;

@PublicApi
public class DataLoaderDispatcherInstrumentationState
implements InstrumentationState {
    @Internal
    public static final DataLoaderRegistry EMPTY_DATALOADER_REGISTRY = new DataLoaderRegistry(){
        private static final String ERROR_MESSAGE = "You MUST set in your own DataLoaderRegistry to use data loader";

        @Override
        public DataLoaderRegistry register(String key, DataLoader<?, ?> dataLoader) {
            return (DataLoaderRegistry)Assert.assertShouldNeverHappen(ERROR_MESSAGE, new Object[0]);
        }

        @Override
        public <K, V> DataLoader<K, V> computeIfAbsent(String key, Function<String, DataLoader<?, ?>> mappingFunction) {
            return (DataLoader)Assert.assertShouldNeverHappen(ERROR_MESSAGE, new Object[0]);
        }

        @Override
        public DataLoaderRegistry unregister(String key) {
            return (DataLoaderRegistry)Assert.assertShouldNeverHappen(ERROR_MESSAGE, new Object[0]);
        }
    };
    private final FieldLevelTrackingApproach approach;
    private final AtomicReference<DataLoaderRegistry> dataLoaderRegistry;
    private final InstrumentationState state;
    private volatile boolean aggressivelyBatching = true;
    private volatile boolean hasNoDataLoaders;

    public DataLoaderDispatcherInstrumentationState(Logger log, DataLoaderRegistry dataLoaderRegistry) {
        this.dataLoaderRegistry = new AtomicReference<DataLoaderRegistry>(dataLoaderRegistry);
        this.approach = new FieldLevelTrackingApproach(log, this::getDataLoaderRegistry);
        this.state = this.approach.createState();
        this.hasNoDataLoaders = this.checkForNoDataLoader(dataLoaderRegistry);
    }

    private boolean checkForNoDataLoader(DataLoaderRegistry dataLoaderRegistry) {
        return dataLoaderRegistry == EMPTY_DATALOADER_REGISTRY;
    }

    boolean isAggressivelyBatching() {
        return this.aggressivelyBatching;
    }

    void setAggressivelyBatching(boolean aggressivelyBatching) {
        this.aggressivelyBatching = aggressivelyBatching;
    }

    FieldLevelTrackingApproach getApproach() {
        return this.approach;
    }

    DataLoaderRegistry getDataLoaderRegistry() {
        return this.dataLoaderRegistry.get();
    }

    void setDataLoaderRegistry(DataLoaderRegistry newRegistry) {
        this.dataLoaderRegistry.set(newRegistry);
        this.hasNoDataLoaders = this.checkForNoDataLoader(newRegistry);
    }

    boolean hasNoDataLoaders() {
        return this.hasNoDataLoaders;
    }

    InstrumentationState getState() {
        return this.state;
    }
}

