/*
 * Decompiled with CFR 0.152.
 */
package graphql.extensions;

import graphql.Internal;
import graphql.com.google.common.collect.Sets;
import graphql.extensions.ExtensionsMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import manifold.shade.org.jetbrains.annotations.NotNull;

@Internal
public class DefaultExtensionsMerger
implements ExtensionsMerger {
    @Override
    @NotNull
    public Map<Object, Object> merge(@NotNull Map<Object, Object> leftMap, @NotNull Map<Object, Object> rightMap) {
        Object rightVal;
        if (leftMap.isEmpty()) {
            return this.mapCast(rightMap);
        }
        if (rightMap.isEmpty()) {
            return this.mapCast(leftMap);
        }
        LinkedHashMap<Object, Object> targetMap = new LinkedHashMap<Object, Object>();
        Set<Object> leftKeys = leftMap.keySet();
        for (Object key : leftKeys) {
            Object object = leftMap.get(key);
            if (rightMap.containsKey(key)) {
                rightVal = rightMap.get(key);
                targetMap.put(key, this.mergeObjects(object, rightVal));
                continue;
            }
            targetMap.put(key, object);
        }
        Sets.SetView<Object> rightOnlyKeys = Sets.difference(rightMap.keySet(), leftKeys);
        for (Object e : rightOnlyKeys) {
            rightVal = rightMap.get(e);
            targetMap.put(e, rightVal);
        }
        return targetMap;
    }

    private Object mergeObjects(Object leftVal, Object rightVal) {
        if (leftVal instanceof Map && rightVal instanceof Map) {
            return this.merge(this.mapCast(leftVal), this.mapCast(rightVal));
        }
        if (leftVal instanceof Collection && rightVal instanceof Collection) {
            return this.appendLists(leftVal, rightVal);
        }
        return rightVal;
    }

    @NotNull
    private List<Object> appendLists(Object leftVal, Object rightVal) {
        ArrayList<Object> target = new ArrayList<Object>(this.listCast(leftVal));
        target.addAll(this.listCast(rightVal));
        return target;
    }

    private Map<Object, Object> mapCast(Object map) {
        return (Map)map;
    }

    private Collection<Object> listCast(Object collection) {
        return (Collection)collection;
    }
}

