/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.InlineFragment;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.NormalizedInputValue;
import graphql.normalized.VariableAccumulator;
import graphql.normalized.VariablePredicate;
import graphql.normalized.VariableValueWithDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import manifold.shade.org.jetbrains.annotations.NotNull;
import manifold.shade.org.jetbrains.annotations.Nullable;

@Internal
public class ExecutableNormalizedOperationToAstCompiler {
    public static CompilerResult compileToDocument(@NotNull GraphQLSchema schema, @NotNull OperationDefinition.Operation operationKind, @Nullable String operationName, @NotNull List<ExecutableNormalizedField> topLevelFields, @Nullable VariablePredicate variablePredicate) {
        GraphQLObjectType operationType = ExecutableNormalizedOperationToAstCompiler.getOperationType(schema, operationKind);
        VariableAccumulator variableAccumulator = new VariableAccumulator(variablePredicate);
        List<Selection<?>> selections = ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedField(schema, operationType.getName(), topLevelFields, variableAccumulator);
        SelectionSet selectionSet = new SelectionSet(selections);
        OperationDefinition.Builder definitionBuilder = OperationDefinition.newOperationDefinition().name(operationName).operation(operationKind).selectionSet(selectionSet);
        definitionBuilder.variableDefinitions(variableAccumulator.getVariableDefinitions());
        return new CompilerResult(Document.newDocument().definition(definitionBuilder.build()).build(), variableAccumulator.getVariablesMap());
    }

    private static List<Selection<?>> subselectionsForNormalizedField(GraphQLSchema schema, @NotNull String parentOutputType, List<ExecutableNormalizedField> executableNormalizedFields, VariableAccumulator variableAccumulator) {
        ImmutableList.Builder selections = ImmutableList.builder();
        LinkedHashMap<String, List> fieldsByTypeCondition = new LinkedHashMap<String, List>();
        for (ExecutableNormalizedField nf : executableNormalizedFields) {
            if (nf.isConditional(schema)) {
                ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, nf, variableAccumulator).forEach((objectTypeName, field) -> fieldsByTypeCondition.computeIfAbsent((String)objectTypeName, ignored -> new ArrayList()).add(field));
                continue;
            }
            selections.add(ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, parentOutputType, nf, variableAccumulator));
        }
        fieldsByTypeCondition.forEach((objectTypeName, fields) -> {
            TypeName typeName = TypeName.newTypeName(objectTypeName).build();
            InlineFragment inlineFragment = InlineFragment.newInlineFragment().typeCondition(typeName).selectionSet(ExecutableNormalizedOperationToAstCompiler.selectionSet(fields)).build();
            selections.add(inlineFragment);
        });
        return selections.build();
    }

    private static Map<String, Field> selectionForNormalizedField(GraphQLSchema schema, ExecutableNormalizedField executableNormalizedField, VariableAccumulator variableAccumulator) {
        LinkedHashMap<String, Field> groupedFields = new LinkedHashMap<String, Field>();
        for (String objectTypeName : executableNormalizedField.getObjectTypeNames()) {
            groupedFields.put(objectTypeName, ExecutableNormalizedOperationToAstCompiler.selectionForNormalizedField(schema, objectTypeName, executableNormalizedField, variableAccumulator));
        }
        return groupedFields;
    }

    private static Field selectionForNormalizedField(GraphQLSchema schema, String objectTypeName, ExecutableNormalizedField executableNormalizedField, VariableAccumulator variableAccumulator) {
        List<Selection<?>> subSelections;
        if (executableNormalizedField.getChildren().isEmpty()) {
            subSelections = ImmutableKit.emptyList();
        } else {
            GraphQLFieldDefinition fieldDef = ExecutableNormalizedOperationToAstCompiler.getFieldDefinition(schema, objectTypeName, executableNormalizedField);
            GraphQLUnmodifiedType fieldOutputType = GraphQLTypeUtil.unwrapAll(fieldDef.getType());
            subSelections = ExecutableNormalizedOperationToAstCompiler.subselectionsForNormalizedField(schema, fieldOutputType.getName(), executableNormalizedField.getChildren(), variableAccumulator);
        }
        SelectionSet selectionSet = ExecutableNormalizedOperationToAstCompiler.selectionSetOrNullIfEmpty(subSelections);
        List<Argument> arguments = ExecutableNormalizedOperationToAstCompiler.createArguments(executableNormalizedField, variableAccumulator);
        return Field.newField().name(executableNormalizedField.getFieldName()).alias(executableNormalizedField.getAlias()).selectionSet(selectionSet).arguments(arguments).build();
    }

    @Nullable
    private static SelectionSet selectionSetOrNullIfEmpty(List<Selection<?>> selections) {
        return selections.isEmpty() ? null : SelectionSet.newSelectionSet().selections(selections).build();
    }

    private static SelectionSet selectionSet(List<Field> fields) {
        return SelectionSet.newSelectionSet().selections(fields).build();
    }

    private static List<Argument> createArguments(ExecutableNormalizedField executableNormalizedField, VariableAccumulator variableAccumulator) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableMap<String, NormalizedInputValue> normalizedArguments = executableNormalizedField.getNormalizedArguments();
        for (String argName : normalizedArguments.keySet()) {
            NormalizedInputValue normalizedInputValue = normalizedArguments.get(argName);
            Value<?> value = ExecutableNormalizedOperationToAstCompiler.argValue(executableNormalizedField, argName, normalizedInputValue, variableAccumulator);
            Argument argument = Argument.newArgument().name(argName).value(value).build();
            result.add(argument);
        }
        return result.build();
    }

    private static Value<?> argValue(ExecutableNormalizedField executableNormalizedField, String argName, @Nullable Object value, VariableAccumulator variableAccumulator) {
        if (value instanceof List) {
            ArrayValue.Builder arrayValue = ArrayValue.newArrayValue();
            arrayValue.values(ImmutableKit.map((List)value, val2 -> ExecutableNormalizedOperationToAstCompiler.argValue(executableNormalizedField, argName, val2, variableAccumulator)));
            return arrayValue.build();
        }
        if (value instanceof Map) {
            ObjectValue.Builder objectValue = ObjectValue.newObjectValue();
            Map map = (Map)value;
            for (String fieldName : map.keySet()) {
                Value<?> fieldValue = ExecutableNormalizedOperationToAstCompiler.argValue(executableNormalizedField, argName, (NormalizedInputValue)map.get(fieldName), variableAccumulator);
                objectValue.objectField(ObjectField.newObjectField().name(fieldName).value(fieldValue).build());
            }
            return objectValue.build();
        }
        if (value == null) {
            return NullValue.newNullValue().build();
        }
        return (Value)value;
    }

    @NotNull
    private static Value<?> argValue(ExecutableNormalizedField executableNormalizedField, String argName, NormalizedInputValue normalizedInputValue, VariableAccumulator variableAccumulator) {
        if (variableAccumulator.shouldMakeVariable(executableNormalizedField, argName, normalizedInputValue)) {
            VariableValueWithDefinition variableWithDefinition = variableAccumulator.accumulateVariable(normalizedInputValue);
            return variableWithDefinition.getVariableReference();
        }
        return ExecutableNormalizedOperationToAstCompiler.argValue(executableNormalizedField, argName, normalizedInputValue.getValue(), variableAccumulator);
    }

    @NotNull
    private static GraphQLFieldDefinition getFieldDefinition(GraphQLSchema schema, String parentType, ExecutableNormalizedField nf) {
        return Introspection.getFieldDef(schema, (GraphQLCompositeType)schema.getType(parentType), nf.getName());
    }

    @Nullable
    private static GraphQLObjectType getOperationType(@NotNull GraphQLSchema schema, @NotNull OperationDefinition.Operation operationKind) {
        switch (operationKind) {
            case QUERY: {
                return schema.getQueryType();
            }
            case MUTATION: {
                return schema.getMutationType();
            }
            case SUBSCRIPTION: {
                return schema.getSubscriptionType();
            }
        }
        return (GraphQLObjectType)Assert.assertShouldNeverHappen("Unknown operation kind " + (Object)((Object)operationKind), new Object[0]);
    }

    public static class CompilerResult {
        private final Document document;
        private final Map<String, Object> variables;

        public CompilerResult(Document document, Map<String, Object> variables) {
            this.document = document;
            this.variables = variables;
        }

        public Document getDocument() {
            return this.document;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }
    }
}

