/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.Internal;
import graphql.i18n.I18n;
import graphql.language.SourceLocation;
import graphql.parser.exceptions.InvalidUnicodeSyntaxException;
import java.io.IOException;
import java.io.StringWriter;

@Internal
public class UnicodeUtil {
    public static final int MAX_UNICODE_CODE_POINT = 0x10FFFF;
    public static final int LEADING_SURROGATE_LOWER_BOUND = 55296;
    public static final int LEADING_SURROGATE_UPPER_BOUND = 56319;
    public static final int TRAILING_SURROGATE_LOWER_BOUND = 56320;
    public static final int TRAILING_SURROGATE_UPPER_BOUND = 57343;

    public static int parseAndWriteUnicode(I18n i18n, StringWriter writer, String string, int i, SourceLocation sourceLocation) {
        int startIndex = UnicodeUtil.isBracedEscape(string, i) ? i + 2 : i + 1;
        int endIndexExclusive = UnicodeUtil.getEndIndexExclusive(i18n, string, i, sourceLocation);
        int continueIndex = UnicodeUtil.isBracedEscape(string, i) ? endIndexExclusive : endIndexExclusive - 1;
        String hexStr = string.substring(startIndex, endIndexExclusive);
        int codePoint = Integer.parseInt(hexStr, 16);
        if (UnicodeUtil.isTrailingSurrogateValue(codePoint)) {
            throw new InvalidUnicodeSyntaxException(i18n, "InvalidUnicode.trailingLeadingSurrogate", sourceLocation, UnicodeUtil.offendingToken(string, i, continueIndex));
        }
        if (UnicodeUtil.isLeadingSurrogateValue(codePoint)) {
            if (!UnicodeUtil.isEscapedUnicode(string, continueIndex + 1)) {
                throw new InvalidUnicodeSyntaxException(i18n, "InvalidUnicode.leadingTrailingSurrogate", sourceLocation, UnicodeUtil.offendingToken(string, i, continueIndex));
            }
            i = continueIndex + 2;
            int trailingStartIndex = UnicodeUtil.isBracedEscape(string, i) ? i + 2 : i + 1;
            int trailingEndIndexExclusive = UnicodeUtil.getEndIndexExclusive(i18n, string, i, sourceLocation);
            String trailingHexStr = string.substring(trailingStartIndex, trailingEndIndexExclusive);
            int trailingCodePoint = Integer.parseInt(trailingHexStr, 16);
            int n = continueIndex = UnicodeUtil.isBracedEscape(string, i) ? trailingEndIndexExclusive : trailingEndIndexExclusive - 1;
            if (UnicodeUtil.isTrailingSurrogateValue(trailingCodePoint)) {
                UnicodeUtil.writeCodePoint(writer, codePoint);
                UnicodeUtil.writeCodePoint(writer, trailingCodePoint);
                return continueIndex;
            }
            throw new InvalidUnicodeSyntaxException(i18n, "InvalidUnicode.leadingTrailingSurrogate", sourceLocation, UnicodeUtil.offendingToken(string, i, continueIndex));
        }
        if (UnicodeUtil.isValidUnicodeCodePoint(codePoint)) {
            UnicodeUtil.writeCodePoint(writer, codePoint);
            return continueIndex;
        }
        throw new InvalidUnicodeSyntaxException(i18n, "InvalidUnicode.invalidCodePoint", sourceLocation, UnicodeUtil.offendingToken(string, i, continueIndex));
    }

    private static String offendingToken(String string, int i, int continueIndex) {
        return string.substring(i - 1, continueIndex + 1);
    }

    private static int getEndIndexExclusive(I18n i18n, String string, int i, SourceLocation sourceLocation) {
        if (string.length() > i + 5 && !UnicodeUtil.isBracedEscape(string, i)) {
            return i + 5;
        }
        int endIndexExclusive = i + 2;
        do {
            if (endIndexExclusive + 1 < string.length()) continue;
            throw new InvalidUnicodeSyntaxException(i18n, "InvalidUnicode.incorrectEscape", sourceLocation, string.substring(i - 1, endIndexExclusive));
        } while (string.charAt(++endIndexExclusive) != '}');
        return endIndexExclusive;
    }

    private static boolean isValidUnicodeCodePoint(int value) {
        return value <= 0x10FFFF;
    }

    private static boolean isEscapedUnicode(String string, int index) {
        if (index + 1 >= string.length()) {
            return false;
        }
        return string.charAt(index) == '\\' && string.charAt(index + 1) == 'u';
    }

    private static boolean isLeadingSurrogateValue(int value) {
        return 55296 <= value && value <= 56319;
    }

    private static boolean isTrailingSurrogateValue(int value) {
        return 56320 <= value && value <= 57343;
    }

    private static void writeCodePoint(StringWriter writer, int codepoint) {
        char[] chars = Character.toChars(codepoint);
        try {
            writer.write(chars);
        }
        catch (IOException e) {
            Assert.assertShouldNeverHappen();
        }
    }

    private static boolean isBracedEscape(String string, int i) {
        return string.charAt(i + 1) == '{';
    }
}

