/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.GraphQLContext;
import graphql.PublicApi;
import graphql.execution.ValuesResolver;
import graphql.language.InputValueDefinition;
import graphql.language.Value;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInputValueDefinition;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.InputValueWithState;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import manifold.shade.org.jetbrains.annotations.NotNull;

@PublicApi
public class GraphQLInputObjectField
implements GraphQLNamedSchemaElement,
GraphQLInputValueDefinition {
    private final String name;
    private final String description;
    private final GraphQLInputType originalType;
    private final InputValueWithState defaultValue;
    private final String deprecationReason;
    private final InputValueDefinition definition;
    private final DirectivesUtil.DirectivesHolder directivesHolder;
    private GraphQLInputType replacedType;
    public static final String CHILD_TYPE = "type";

    private GraphQLInputObjectField(String name, String description, GraphQLInputType type, InputValueWithState defaultValue, List<GraphQLDirective> directives, List<GraphQLAppliedDirective> appliedDirectives, InputValueDefinition definition, String deprecationReason) {
        Assert.assertValidName(name);
        Assert.assertNotNull(type, () -> "type can't be null");
        Assert.assertNotNull(directives, () -> "directives cannot be null");
        this.name = name;
        this.originalType = type;
        this.defaultValue = defaultValue;
        this.description = description;
        this.directivesHolder = new DirectivesUtil.DirectivesHolder(directives, appliedDirectives);
        this.definition = definition;
        this.deprecationReason = deprecationReason;
    }

    void replaceType(GraphQLInputType type) {
        this.replacedType = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GraphQLInputType getType() {
        return this.replacedType != null ? this.replacedType : this.originalType;
    }

    @NotNull
    public InputValueWithState getInputFieldDefaultValue() {
        return this.defaultValue;
    }

    public static <T> T getInputFieldDefaultValue(GraphQLInputObjectField inputObjectField) {
        return ValuesResolver.getInputValueImpl(inputObjectField.getType(), inputObjectField.getInputFieldDefaultValue(), GraphQLContext.getDefault(), Locale.getDefault());
    }

    public boolean hasSetDefaultValue() {
        return this.defaultValue.isSet();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    @Override
    public InputValueDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return this.directivesHolder.getDirectives();
    }

    @Override
    public Map<String, GraphQLDirective> getDirectivesByName() {
        return this.directivesHolder.getDirectivesByName();
    }

    @Override
    public Map<String, List<GraphQLDirective>> getAllDirectivesByName() {
        return this.directivesHolder.getAllDirectivesByName();
    }

    @Override
    public GraphQLDirective getDirective(String directiveName) {
        return this.directivesHolder.getDirective(directiveName);
    }

    @Override
    public List<GraphQLAppliedDirective> getAppliedDirectives() {
        return this.directivesHolder.getAppliedDirectives();
    }

    @Override
    public Map<String, List<GraphQLAppliedDirective>> getAllAppliedDirectivesByName() {
        return this.directivesHolder.getAllAppliedDirectivesByName();
    }

    @Override
    public GraphQLAppliedDirective getAppliedDirective(String directiveName) {
        return this.directivesHolder.getAppliedDirective(directiveName);
    }

    public GraphQLInputObjectField transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLInputObjectField.newInputObjectField(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public GraphQLSchemaElement copy() {
        return GraphQLInputObjectField.newInputObjectField(this).build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLInputObjectField(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>();
        children.add(this.getType());
        children.addAll(this.directivesHolder.getDirectives());
        children.addAll(this.directivesHolder.getAppliedDirectives());
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children("directives", this.directivesHolder.getDirectives()).children("appliedDirectives", this.directivesHolder.getAppliedDirectives()).child(CHILD_TYPE, this.originalType).build();
    }

    @Override
    public GraphQLInputObjectField withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> {
            Builder cfr_ignored_0 = (Builder)builder.type((GraphQLInputType)newChildren.getChildOrNull(CHILD_TYPE)).replaceDirectives(newChildren.getChildren("directives")).replaceAppliedDirectives(newChildren.getChildren("appliedDirectives"));
        });
    }

    @Override
    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "GraphQLInputObjectField{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", originalType=" + GraphQLInputObjectField.inputTypeToStringAvoidingCircularReference(this.originalType) + ", defaultValue=" + this.defaultValue + ", definition=" + this.definition + ", directives=" + this.directivesHolder + ", replacedType=" + GraphQLInputObjectField.inputTypeToStringAvoidingCircularReference(this.replacedType) + '}';
    }

    private static Object inputTypeToStringAvoidingCircularReference(GraphQLInputType graphQLInputType) {
        return graphQLInputType instanceof GraphQLInputObjectType ? String.format("[%s]", GraphQLInputObjectType.class.getSimpleName()) : graphQLInputType;
    }

    public static Builder newInputObjectField(GraphQLInputObjectField existing) {
        return new Builder(existing);
    }

    public static Builder newInputObjectField() {
        return new Builder();
    }

    @PublicApi
    public static class Builder
    extends GraphqlDirectivesContainerTypeBuilder<Builder, Builder> {
        private InputValueWithState defaultValue = InputValueWithState.NOT_SET;
        private GraphQLInputType type;
        private InputValueDefinition definition;
        private String deprecationReason;

        public Builder() {
        }

        public Builder(GraphQLInputObjectField existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.defaultValue = existing.getInputFieldDefaultValue();
            this.type = existing.originalType;
            this.definition = existing.getDefinition();
            this.deprecationReason = existing.deprecationReason;
            this.copyExistingDirectives(existing);
        }

        public Builder definition(InputValueDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder deprecate(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public Builder type(GraphQLInputObjectType.Builder type) {
            return this.type(type.build());
        }

        public Builder type(GraphQLInputType type) {
            this.type = type;
            return this;
        }

        @Deprecated
        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = InputValueWithState.newInternalValue(defaultValue);
            return this;
        }

        public Builder defaultValueLiteral(Value defaultValue) {
            this.defaultValue = InputValueWithState.newLiteralValue(defaultValue);
            return this;
        }

        public Builder defaultValueProgrammatic(Object defaultValue) {
            this.defaultValue = InputValueWithState.newExternalValue(defaultValue);
            return this;
        }

        public Builder clearDefaultValue() {
            this.defaultValue = InputValueWithState.NOT_SET;
            return this;
        }

        @Override
        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            return (Builder)super.replaceDirectives(directives);
        }

        @Override
        public Builder withDirectives(GraphQLDirective ... directives) {
            return (Builder)super.withDirectives(directives);
        }

        @Override
        public Builder withDirective(GraphQLDirective directive) {
            return (Builder)super.withDirective(directive);
        }

        @Override
        public Builder withDirective(GraphQLDirective.Builder builder) {
            return (Builder)super.withDirective(builder);
        }

        @Override
        public Builder clearDirectives() {
            return (Builder)super.clearDirectives();
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public GraphQLInputObjectField build() {
            Assert.assertNotNull(this.type, () -> "type can't be null");
            return new GraphQLInputObjectField(this.name, this.description, this.type, this.defaultValue, this.sort(this.directives, GraphQLInputObjectField.class, GraphQLDirective.class), this.sort(this.appliedDirectives, GraphQLScalarType.class, GraphQLAppliedDirective.class), this.definition, this.deprecationReason);
        }
    }
}

