/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Internal;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.EditOperation;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Vertex;
import java.util.List;

@Internal
public class EditorialCostForMapping {
    public static int editorialCostForMapping(Mapping mapping, SchemaGraph sourceGraph, SchemaGraph targetGraph, List<EditOperation> editOperationsResult) {
        int cost = 0;
        for (int i = 0; i < mapping.size(); ++i) {
            boolean equalNodes;
            Vertex sourceVertex = mapping.getSource(i);
            Vertex targetVertex = mapping.getTarget(i);
            boolean bl = equalNodes = sourceVertex.getType().equals(targetVertex.getType()) && sourceVertex.getProperties().equals(targetVertex.getProperties());
            if (equalNodes) continue;
            if (sourceVertex.isIsolated()) {
                editOperationsResult.add(EditOperation.insertVertex("Insert" + targetVertex, sourceVertex, targetVertex));
            } else if (targetVertex.isIsolated()) {
                editOperationsResult.add(EditOperation.deleteVertex("Delete " + sourceVertex, sourceVertex, targetVertex));
            } else {
                editOperationsResult.add(EditOperation.changeVertex("Change " + sourceVertex + " to " + targetVertex, sourceVertex, targetVertex));
            }
            ++cost;
        }
        List<Edge> edges = sourceGraph.getEdges();
        for (Edge sourceEdge : edges) {
            Vertex targetTo;
            if (!mapping.containsSource(sourceEdge.getFrom()) || !mapping.containsSource(sourceEdge.getTo())) continue;
            Vertex targetFrom = mapping.getTarget(sourceEdge.getFrom());
            Edge targetEdge = targetGraph.getEdge(targetFrom, targetTo = mapping.getTarget(sourceEdge.getTo()));
            if (targetEdge == null) {
                editOperationsResult.add(EditOperation.deleteEdge("Delete edge " + sourceEdge, sourceEdge));
                ++cost;
                continue;
            }
            if (sourceEdge.getLabel().equals(targetEdge.getLabel())) continue;
            editOperationsResult.add(EditOperation.changeEdge("Change " + sourceEdge + " to " + targetEdge, sourceEdge, targetEdge));
            ++cost;
        }
        for (Edge targetEdge : targetGraph.getEdges()) {
            Vertex sourceTo;
            Vertex sourceFrom;
            if (!mapping.containsTarget(targetEdge.getFrom()) || !mapping.containsTarget(targetEdge.getTo()) || sourceGraph.getEdge(sourceFrom = mapping.getSource(targetEdge.getFrom()), sourceTo = mapping.getSource(targetEdge.getTo())) != null) continue;
            editOperationsResult.add(EditOperation.insertEdge("Insert edge " + targetEdge, targetEdge));
            ++cost;
        }
        return cost;
    }
}

