/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Internal;
import graphql.com.google.common.collect.BiMap;
import graphql.com.google.common.collect.HashBiMap;
import graphql.schema.diffing.Vertex;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Internal
public class Mapping {
    private BiMap<Vertex, Vertex> map = HashBiMap.create();
    private List<Vertex> sourceList = new ArrayList<Vertex>();
    private List<Vertex> targetList = new ArrayList<Vertex>();

    private Mapping(BiMap<Vertex, Vertex> map, List<Vertex> sourceList, List<Vertex> targetList) {
        this.map = map;
        this.sourceList = sourceList;
        this.targetList = targetList;
    }

    public Mapping() {
    }

    public Vertex getSource(Vertex target) {
        return (Vertex)this.map.inverse().get(target);
    }

    public Vertex getTarget(Vertex source) {
        return (Vertex)this.map.get(source);
    }

    public Vertex getSource(int i) {
        return this.sourceList.get(i);
    }

    public Vertex getTarget(int i) {
        return this.targetList.get(i);
    }

    public List<Vertex> getTargets() {
        return this.targetList;
    }

    public List<Vertex> getSources() {
        return this.sourceList;
    }

    public boolean containsSource(Vertex sourceVertex) {
        return this.map.containsKey(sourceVertex);
    }

    public boolean containsTarget(Vertex targetVertex) {
        return this.map.containsValue(targetVertex);
    }

    public int size() {
        return this.map.size();
    }

    public void add(Vertex source, Vertex target) {
        this.map.put(source, target);
        this.sourceList.add(source);
        this.targetList.add(target);
    }

    public Mapping removeLastElement() {
        HashBiMap<Vertex, Vertex> newMap = HashBiMap.create(this.map);
        newMap.remove(this.sourceList.get(this.sourceList.size() - 1));
        ArrayList<Vertex> newSourceList = new ArrayList<Vertex>(this.sourceList.subList(0, this.sourceList.size() - 1));
        ArrayList<Vertex> newTargetList = new ArrayList<Vertex>(this.targetList.subList(0, this.targetList.size() - 1));
        return new Mapping(newMap, newSourceList, newTargetList);
    }

    public Mapping copy() {
        HashBiMap<Vertex, Vertex> newMap = HashBiMap.create(this.map);
        ArrayList<Vertex> newSourceList = new ArrayList<Vertex>(this.sourceList);
        ArrayList<Vertex> newTargetList = new ArrayList<Vertex>(this.targetList);
        return new Mapping(newMap, newSourceList, newTargetList);
    }

    public Mapping extendMapping(Vertex source, Vertex target) {
        HashBiMap<Vertex, Vertex> newMap = HashBiMap.create(this.map);
        newMap.put(source, target);
        ArrayList<Vertex> newSourceList = new ArrayList<Vertex>(this.sourceList);
        newSourceList.add(source);
        ArrayList<Vertex> newTargetList = new ArrayList<Vertex>(this.targetList);
        newTargetList.add(target);
        return new Mapping(newMap, newSourceList, newTargetList);
    }

    public BiMap<Vertex, Vertex> getMap() {
        return this.map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mapping mapping = (Mapping)o;
        return Objects.equals(this.map, mapping.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

