/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Assert;
import graphql.ExperimentalApi;
import graphql.com.google.common.collect.HashBasedTable;
import graphql.com.google.common.collect.LinkedHashMultimap;
import graphql.com.google.common.collect.Multimap;
import graphql.com.google.common.collect.Table;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import manifold.shade.org.jetbrains.annotations.Nullable;

@ExperimentalApi
public class SchemaGraph {
    public static final String SCHEMA = "Schema";
    public static final String OBJECT = "Object";
    public static final String INTERFACE = "Interface";
    public static final String UNION = "Union";
    public static final String FIELD = "Field";
    public static final String ARGUMENT = "Argument";
    public static final String SCALAR = "Scalar";
    public static final String ENUM = "Enum";
    public static final String ENUM_VALUE = "EnumValue";
    public static final String INPUT_OBJECT = "InputObject";
    public static final String INPUT_FIELD = "InputField";
    public static final String DIRECTIVE = "Directive";
    public static final String APPLIED_DIRECTIVE = "AppliedDirective";
    public static final String APPLIED_ARGUMENT = "AppliedArgument";
    public static final String ISOLATED = "__ISOLATED";
    private List<Vertex> vertices = new ArrayList<Vertex>();
    private List<Edge> edges = new ArrayList<Edge>();
    private Map<String, Vertex> typesByName = new LinkedHashMap<String, Vertex>();
    private Map<String, Vertex> directivesByName = new LinkedHashMap<String, Vertex>();
    private Table<Vertex, Vertex, Edge> edgesByDirection = HashBasedTable.create();
    private Table<Vertex, Vertex, Edge> edgesByInverseDirection = HashBasedTable.create();
    private Multimap<String, Vertex> typeToVertices = LinkedHashMultimap.create();

    public SchemaGraph() {
    }

    public SchemaGraph(List<Vertex> vertices, List<Edge> edges, Table<Vertex, Vertex, Edge> edgeByVertexPair) {
        this.vertices = vertices;
        this.edges = edges;
        this.edgesByDirection = edgeByVertexPair;
    }

    public void addVertex(Vertex vertex) {
        this.vertices.add(vertex);
        this.typeToVertices.put(vertex.getType(), vertex);
    }

    public void addVertices(Collection<Vertex> vertices) {
        for (Vertex vertex : vertices) {
            this.vertices.add(vertex);
            this.typeToVertices.put(vertex.getType(), vertex);
        }
    }

    public Collection<Vertex> getVerticesByType(String type) {
        return this.typeToVertices.get(type);
    }

    public Multimap<String, Vertex> getVerticesByType() {
        return this.typeToVertices;
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
        this.edgesByDirection.put(edge.getFrom(), edge.getTo(), edge);
        this.edgesByInverseDirection.put(edge.getTo(), edge.getFrom(), edge);
    }

    public List<Edge> getAdjacentEdges(Vertex from) {
        return new ArrayList<Edge>(this.edgesByDirection.row(from).values());
    }

    public List<Edge> getAdjacentEdgesAndInverse(Vertex fromAndTo) {
        ArrayList<Edge> result = new ArrayList<Edge>(this.edgesByDirection.row(fromAndTo).values());
        result.addAll(this.edgesByInverseDirection.row(fromAndTo).values());
        return result;
    }

    public List<Vertex> getAdjacentVertices(Vertex from) {
        return this.getAdjacentVertices(from, x -> true);
    }

    public List<Vertex> getAdjacentVertices(Vertex from, Predicate<Vertex> predicate) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        for (Edge edge : this.edgesByDirection.row(from).values()) {
            Vertex v = edge.getTo();
            if (!predicate.test(v)) continue;
            result.add(v);
        }
        return result;
    }

    public List<Vertex> getAdjacentVerticesInverse(Vertex to) {
        return this.getAdjacentVerticesInverse(to, x -> true);
    }

    public List<Vertex> getAdjacentVerticesInverse(Vertex to, Predicate<Vertex> predicate) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        for (Edge edge : this.edgesByInverseDirection.row(to).values()) {
            Vertex v = edge.getFrom();
            if (!predicate.test(v)) continue;
            result.add(v);
        }
        return result;
    }

    public List<Edge> getAdjacentEdges(Vertex from, Predicate<Vertex> predicate) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (Edge edge : this.edgesByDirection.row(from).values()) {
            Vertex v = edge.getTo();
            if (!predicate.test(v)) continue;
            result.add(edge);
        }
        return result;
    }

    public List<Edge> getAdjacentEdgesInverse(Vertex to) {
        return this.getAdjacentEdgesInverse(to, x -> true);
    }

    public List<Edge> getAdjacentEdgesInverse(Vertex to, Predicate<Vertex> predicate) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (Edge edge : this.edgesByInverseDirection.row(to).values()) {
            Vertex v = edge.getFrom();
            if (!predicate.test(v)) continue;
            result.add(edge);
        }
        return result;
    }

    public Edge getSingleAdjacentEdge(Vertex from, Predicate<Edge> predicate) {
        for (Edge edge : this.edgesByDirection.row(from).values()) {
            if (!predicate.test(edge)) continue;
            return edge;
        }
        return null;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    @Nullable
    public Edge getEdge(Vertex from, Vertex to) {
        return this.edgesByDirection.get(from, to);
    }

    @Nullable
    public Edge getEdgeOrInverse(Vertex from, Vertex to) {
        Edge result = this.edgesByDirection.get(from, to);
        return result != null ? result : this.edgesByInverseDirection.get(from, to);
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<Vertex> vertices) {
        this.vertices = vertices;
    }

    public void addType(String name, Vertex vertex) {
        this.typesByName.put(name, vertex);
    }

    public void addDirective(String name, Vertex vertex) {
        this.directivesByName.put(name, vertex);
    }

    public Vertex getType(String name) {
        return this.typesByName.get(name);
    }

    public Vertex getDirective(String name) {
        return this.directivesByName.get(name);
    }

    public Optional<Vertex> findTargetVertex(Vertex from, Predicate<Vertex> vertexPredicate) {
        return this.edgesByDirection.row(from).values().stream().map(Edge::getTo).filter(vertexPredicate).findFirst();
    }

    public int size() {
        return this.vertices.size();
    }

    public List<Vertex> addIsolatedVertices(int count, String debugPrefix) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        for (int i = 0; i < count; ++i) {
            Vertex isolatedVertex = Vertex.newIsolatedNode(debugPrefix + i);
            this.vertices.add(isolatedVertex);
            result.add(isolatedVertex);
        }
        return result;
    }

    public Vertex getFieldOrDirectiveForArgument(Vertex argument) {
        List<Vertex> adjacentVertices = this.getAdjacentVerticesInverse(argument);
        Assert.assertTrue(adjacentVertices.size() == 1, () -> String.format("No field or directive found for %s", argument));
        return adjacentVertices.get(0);
    }

    public Vertex getFieldsContainerForField(Vertex field) {
        List<Vertex> adjacentVertices = this.getAdjacentVerticesInverse(field);
        Assert.assertTrue(adjacentVertices.size() == 1, () -> String.format("No fields container found for %s", field));
        return adjacentVertices.get(0);
    }

    public Vertex getInputObjectForInputField(Vertex inputField) {
        List<Vertex> adjacentVertices = this.getAdjacentVerticesInverse(inputField);
        Assert.assertTrue(adjacentVertices.size() == 1, () -> String.format("No input object found for %s", inputField));
        return adjacentVertices.get(0);
    }

    public Vertex getAppliedDirectiveForAppliedArgument(Vertex appliedArgument) {
        List<Vertex> adjacentVertices = this.getAdjacentVerticesInverse(appliedArgument);
        Assert.assertTrue(adjacentVertices.size() == 1, () -> String.format("No applied directive found for %s", appliedArgument));
        return adjacentVertices.get(0);
    }

    public Vertex getAppliedDirectiveContainerForAppliedDirective(Vertex appliedDirective) {
        List<Vertex> adjacentVertices = this.getAdjacentVerticesInverse(appliedDirective);
        Assert.assertTrue(adjacentVertices.size() == 1, () -> String.format("No applied directive container found for %s", appliedDirective));
        return adjacentVertices.get(0);
    }

    public int getAppliedDirectiveIndex(Vertex appliedDirective) {
        List<Edge> adjacentEdges = this.getAdjacentEdgesInverse(appliedDirective);
        Assert.assertTrue(adjacentEdges.size() == 1, () -> String.format("No applied directive container found for %s", appliedDirective));
        return Integer.parseInt(adjacentEdges.get(0).getLabel());
    }

    public Vertex getEnumForEnumValue(Vertex enumValue) {
        List<Vertex> adjacentVertices = this.getAdjacentVerticesInverse(enumValue);
        Assert.assertTrue(adjacentVertices.size() == 1, () -> String.format("No enum found for %s", enumValue));
        return adjacentVertices.get(0);
    }

    public List<Edge> getAllAdjacentEdges(List<Vertex> fromList, Vertex to) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (Vertex from : fromList) {
            Edge edge = this.getEdge(from, to);
            if (edge == null) continue;
            result.add(edge);
        }
        return result;
    }
}

