/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.ValuesResolver;
import graphql.introspection.Introspection;
import graphql.language.AstPrinter;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Vertex;
import graphql.schema.idl.DirectiveInfo;
import graphql.schema.idl.ScalarInfo;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;

@Internal
public class SchemaGraphFactory {
    private int counter = 1;
    private final String debugPrefix;

    public SchemaGraphFactory(String debugPrefix) {
        this.debugPrefix = debugPrefix;
    }

    public SchemaGraphFactory() {
        this.debugPrefix = "";
    }

    public SchemaGraph createGraph(GraphQLSchema schema) {
        LinkedHashSet<GraphQLSchemaElement> roots = new LinkedHashSet<GraphQLSchemaElement>();
        roots.add(schema.getQueryType());
        if (schema.isSupportingMutations()) {
            roots.add(schema.getMutationType());
        }
        if (schema.isSupportingSubscriptions()) {
            roots.add(schema.getSubscriptionType());
        }
        roots.addAll(schema.getAdditionalTypes());
        roots.addAll(schema.getDirectives());
        roots.addAll(schema.getSchemaDirectives());
        roots.add(schema.getIntrospectionSchemaType());
        Traverser<GraphQLSchemaElement> traverser = Traverser.depthFirst(GraphQLSchemaElement::getChildren);
        final SchemaGraph schemaGraph = new SchemaGraph();
        traverser.traverse(roots, new TraverserVisitor<GraphQLSchemaElement>(){

            @Override
            public TraversalControl enter(TraverserContext<GraphQLSchemaElement> context) {
                class IntrospectionNode {
                    IntrospectionNode() {
                    }
                }
                boolean isIntrospectionNode = false;
                if (context.thisNode() instanceof GraphQLNamedType) {
                    if (Introspection.isIntrospectionTypes((GraphQLNamedType)context.thisNode())) {
                        isIntrospectionNode = true;
                        context.setVar(IntrospectionNode.class, new IntrospectionNode());
                    }
                } else {
                    boolean bl = isIntrospectionNode = context.getVarFromParents(IntrospectionNode.class) != null;
                }
                if (context.thisNode() instanceof GraphQLObjectType) {
                    SchemaGraphFactory.this.newObject((GraphQLObjectType)context.thisNode(), schemaGraph, isIntrospectionNode);
                }
                if (context.thisNode() instanceof GraphQLInterfaceType) {
                    SchemaGraphFactory.this.newInterface((GraphQLInterfaceType)context.thisNode(), schemaGraph, isIntrospectionNode);
                }
                if (context.thisNode() instanceof GraphQLUnionType) {
                    SchemaGraphFactory.this.newUnion((GraphQLUnionType)context.thisNode(), schemaGraph, isIntrospectionNode);
                }
                if (context.thisNode() instanceof GraphQLScalarType) {
                    SchemaGraphFactory.this.newScalar((GraphQLScalarType)context.thisNode(), schemaGraph, isIntrospectionNode);
                }
                if (context.thisNode() instanceof GraphQLInputObjectType) {
                    SchemaGraphFactory.this.newInputObject((GraphQLInputObjectType)context.thisNode(), schemaGraph, isIntrospectionNode);
                }
                if (context.thisNode() instanceof GraphQLEnumType) {
                    SchemaGraphFactory.this.newEnum((GraphQLEnumType)context.thisNode(), schemaGraph, isIntrospectionNode);
                }
                if (context.thisNode() instanceof GraphQLDirective && context.getParentNode() == null) {
                    SchemaGraphFactory.this.newDirective((GraphQLDirective)context.thisNode(), schemaGraph);
                }
                return TraversalControl.CONTINUE;
            }

            @Override
            public TraversalControl leave(TraverserContext<GraphQLSchemaElement> context) {
                return TraversalControl.CONTINUE;
            }
        });
        this.addSchemaVertex(schemaGraph, schema);
        ArrayList<Vertex> copyOfVertices = new ArrayList<Vertex>(schemaGraph.getVertices());
        for (Vertex vertex : copyOfVertices) {
            if ("Object".equals(vertex.getType())) {
                this.handleObjectVertex(vertex, schemaGraph, schema);
            }
            if ("Interface".equals(vertex.getType())) {
                this.handleInterfaceVertex(vertex, schemaGraph, schema);
            }
            if ("Union".equals(vertex.getType())) {
                this.handleUnion(vertex, schemaGraph, schema);
            }
            if ("InputObject".equals(vertex.getType())) {
                this.handleInputObject(vertex, schemaGraph, schema);
            }
            if (!"Directive".equals(vertex.getType())) continue;
            this.handleDirective(vertex, schemaGraph, schema);
        }
        return schemaGraph;
    }

    private void addSchemaVertex(SchemaGraph schemaGraph, GraphQLSchema graphQLSchema) {
        GraphQLObjectType queryType = graphQLSchema.getQueryType();
        GraphQLObjectType mutationType = graphQLSchema.getMutationType();
        GraphQLObjectType subscriptionType = graphQLSchema.getSubscriptionType();
        Vertex schemaVertex = new Vertex("Schema", "schema");
        schemaVertex.add("name", "Schema");
        schemaGraph.addVertex(schemaVertex);
        Vertex queryVertex = schemaGraph.getType(queryType.getName());
        schemaGraph.addEdge(new Edge(schemaVertex, queryVertex, "query"));
        if (mutationType != null) {
            Vertex mutationVertex = schemaGraph.getType(mutationType.getName());
            schemaGraph.addEdge(new Edge(schemaVertex, mutationVertex, "mutation"));
        }
        if (subscriptionType != null) {
            Vertex subscriptionVertex = schemaGraph.getType(subscriptionType.getName());
            schemaGraph.addEdge(new Edge(schemaVertex, subscriptionVertex, "subscription"));
        }
        this.createAppliedDirectives(schemaVertex, graphQLSchema.getSchemaDirectives(), schemaGraph);
    }

    private void handleInputObject(Vertex inputObject, SchemaGraph schemaGraph, GraphQLSchema graphQLSchema) {
        GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)graphQLSchema.getType((String)inputObject.get("name"));
        List<GraphQLInputObjectField> inputFields = inputObjectType.getFields();
        for (GraphQLInputObjectField inputField : inputFields) {
            Vertex inputFieldVertex = schemaGraph.findTargetVertex(inputObject, vertex -> vertex.getType().equals("InputField") && vertex.get("name").equals(inputField.getName())).get();
            this.handleInputField(inputFieldVertex, inputField, schemaGraph, graphQLSchema);
        }
    }

    private void handleInputField(Vertex inputFieldVertex, GraphQLInputObjectField inputField, SchemaGraph schemaGraph, GraphQLSchema graphQLSchema) {
        GraphQLInputType type = inputField.getType();
        GraphQLUnmodifiedType graphQLUnmodifiedType = GraphQLTypeUtil.unwrapAll(type);
        Vertex typeVertex = Assert.assertNotNull(schemaGraph.getType(graphQLUnmodifiedType.getName()));
        Edge typeEdge = new Edge(inputFieldVertex, typeVertex);
        String typeEdgeLabel = "type=" + GraphQLTypeUtil.simplePrint(type) + ";defaultValue=";
        if (inputField.hasSetDefaultValue()) {
            typeEdgeLabel = typeEdgeLabel + AstPrinter.printAst(ValuesResolver.valueToLiteral(inputField.getInputFieldDefaultValue(), inputField.getType(), GraphQLContext.getDefault(), Locale.getDefault()));
        }
        typeEdge.setLabel(typeEdgeLabel);
        schemaGraph.addEdge(typeEdge);
    }

    private void handleUnion(Vertex unionVertex, SchemaGraph schemaGraph, GraphQLSchema graphQLSchema) {
        GraphQLUnionType unionType = (GraphQLUnionType)graphQLSchema.getType((String)unionVertex.get("name"));
        List<GraphQLNamedOutputType> types = unionType.getTypes();
        for (GraphQLNamedOutputType unionMemberType : types) {
            Vertex unionMemberVertex = Assert.assertNotNull(schemaGraph.getType(unionMemberType.getName()));
            schemaGraph.addEdge(new Edge(unionVertex, unionMemberVertex));
        }
    }

    private void handleInterfaceVertex(Vertex interfaceVertex, SchemaGraph schemaGraph, GraphQLSchema graphQLSchema) {
        GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)graphQLSchema.getType((String)interfaceVertex.get("name"));
        for (GraphQLNamedOutputType implementsInterface : interfaceType.getInterfaces()) {
            Vertex implementsInterfaceVertex = Assert.assertNotNull(schemaGraph.getType(implementsInterface.getName()));
            schemaGraph.addEdge(new Edge(interfaceVertex, implementsInterfaceVertex, "implements " + implementsInterface.getName()));
        }
        List<GraphQLFieldDefinition> fieldDefinitions = interfaceType.getFieldDefinitions();
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            Vertex fieldVertex = schemaGraph.findTargetVertex(interfaceVertex, vertex -> vertex.getType().equals("Field") && vertex.get("name").equals(fieldDefinition.getName())).get();
            this.handleField(fieldVertex, fieldDefinition, schemaGraph, graphQLSchema);
        }
    }

    private void handleObjectVertex(Vertex objectVertex, SchemaGraph schemaGraph, GraphQLSchema graphQLSchema) {
        GraphQLObjectType objectType = graphQLSchema.getObjectType((String)objectVertex.get("name"));
        for (GraphQLNamedOutputType implementsInterface : objectType.getInterfaces()) {
            Vertex implementsInterfaceVertex = Assert.assertNotNull(schemaGraph.getType(implementsInterface.getName()));
            schemaGraph.addEdge(new Edge(objectVertex, implementsInterfaceVertex, "implements " + implementsInterface.getName()));
        }
        List<GraphQLFieldDefinition> fieldDefinitions = objectType.getFieldDefinitions();
        for (GraphQLFieldDefinition fieldDefinition : fieldDefinitions) {
            Vertex fieldVertex = schemaGraph.findTargetVertex(objectVertex, vertex -> vertex.getType().equals("Field") && vertex.get("name").equals(fieldDefinition.getName())).get();
            this.handleField(fieldVertex, fieldDefinition, schemaGraph, graphQLSchema);
        }
    }

    private void handleField(Vertex fieldVertex, GraphQLFieldDefinition fieldDefinition, SchemaGraph schemaGraph, GraphQLSchema graphQLSchema) {
        GraphQLOutputType type = fieldDefinition.getType();
        GraphQLUnmodifiedType graphQLUnmodifiedType = GraphQLTypeUtil.unwrapAll(type);
        Vertex typeVertex = Assert.assertNotNull(schemaGraph.getType(graphQLUnmodifiedType.getName()));
        Edge typeEdge = new Edge(fieldVertex, typeVertex);
        typeEdge.setLabel("type=" + GraphQLTypeUtil.simplePrint(type) + ";");
        schemaGraph.addEdge(typeEdge);
        for (GraphQLArgument graphQLArgument : fieldDefinition.getArguments()) {
            Vertex argumentVertex = schemaGraph.findTargetVertex(fieldVertex, vertex -> vertex.getType().equals("Argument") && vertex.get("name").equals(graphQLArgument.getName())).get();
            this.handleArgument(argumentVertex, graphQLArgument, schemaGraph);
        }
    }

    private void handleDirective(Vertex directive, SchemaGraph schemaGraph, GraphQLSchema graphQLSchema) {
        GraphQLDirective graphQLDirective = graphQLSchema.getDirective(directive.getName());
        for (GraphQLArgument graphQLArgument : graphQLDirective.getArguments()) {
            Vertex argumentVertex = schemaGraph.findTargetVertex(directive, vertex -> vertex.isOfType("Argument") && vertex.getName().equals(graphQLArgument.getName())).get();
            this.handleArgument(argumentVertex, graphQLArgument, schemaGraph);
        }
    }

    private void handleArgument(Vertex argumentVertex, GraphQLArgument graphQLArgument, SchemaGraph schemaGraph) {
        GraphQLInputType type = graphQLArgument.getType();
        GraphQLUnmodifiedType graphQLUnmodifiedType = GraphQLTypeUtil.unwrapAll(type);
        Vertex typeVertex = Assert.assertNotNull(schemaGraph.getType(graphQLUnmodifiedType.getName()));
        Edge typeEdge = new Edge(argumentVertex, typeVertex);
        String typeEdgeLabel = "type=" + GraphQLTypeUtil.simplePrint(type) + ";defaultValue=";
        if (graphQLArgument.hasSetDefaultValue()) {
            typeEdgeLabel = typeEdgeLabel + AstPrinter.printAst(ValuesResolver.valueToLiteral(graphQLArgument.getArgumentDefaultValue(), graphQLArgument.getType(), GraphQLContext.getDefault(), Locale.getDefault()));
        }
        typeEdge.setLabel(typeEdgeLabel);
        schemaGraph.addEdge(typeEdge);
    }

    private void newObject(GraphQLObjectType graphQLObjectType, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex objectVertex = new Vertex("Object", this.debugPrefix + String.valueOf(this.counter++));
        objectVertex.setBuiltInType(isIntrospectionNode);
        objectVertex.add("name", graphQLObjectType.getName());
        objectVertex.add("description", this.desc(graphQLObjectType.getDescription()));
        for (GraphQLFieldDefinition fieldDefinition : graphQLObjectType.getFieldDefinitions()) {
            Vertex newFieldVertex = this.newField(fieldDefinition, schemaGraph, isIntrospectionNode);
            schemaGraph.addVertex(newFieldVertex);
            schemaGraph.addEdge(new Edge(objectVertex, newFieldVertex));
        }
        schemaGraph.addVertex(objectVertex);
        schemaGraph.addType(graphQLObjectType.getName(), objectVertex);
        this.createAppliedDirectives(objectVertex, graphQLObjectType.getDirectives(), schemaGraph);
    }

    private Vertex newField(GraphQLFieldDefinition graphQLFieldDefinition, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex fieldVertex = new Vertex("Field", this.debugPrefix + String.valueOf(this.counter++));
        fieldVertex.setBuiltInType(isIntrospectionNode);
        fieldVertex.add("name", graphQLFieldDefinition.getName());
        fieldVertex.add("description", this.desc(graphQLFieldDefinition.getDescription()));
        for (GraphQLArgument argument : graphQLFieldDefinition.getArguments()) {
            Vertex argumentVertex = this.newArgument(argument, schemaGraph, isIntrospectionNode);
            schemaGraph.addVertex(argumentVertex);
            schemaGraph.addEdge(new Edge(fieldVertex, argumentVertex));
        }
        this.createAppliedDirectives(fieldVertex, graphQLFieldDefinition.getDirectives(), schemaGraph);
        return fieldVertex;
    }

    private Vertex newArgument(GraphQLArgument graphQLArgument, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex vertex = new Vertex("Argument", this.debugPrefix + String.valueOf(this.counter++));
        vertex.setBuiltInType(isIntrospectionNode);
        vertex.add("name", graphQLArgument.getName());
        vertex.add("description", this.desc(graphQLArgument.getDescription()));
        this.createAppliedDirectives(vertex, graphQLArgument.getDirectives(), schemaGraph);
        return vertex;
    }

    private void newScalar(GraphQLScalarType scalarType, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex scalarVertex = new Vertex("Scalar", this.debugPrefix + String.valueOf(this.counter++));
        scalarVertex.setBuiltInType(isIntrospectionNode);
        if (ScalarInfo.isGraphqlSpecifiedScalar(scalarType.getName())) {
            scalarVertex.setBuiltInType(true);
        }
        scalarVertex.add("name", scalarType.getName());
        scalarVertex.add("description", this.desc(scalarType.getDescription()));
        scalarVertex.add("specifiedByUrl", scalarType.getSpecifiedByUrl());
        schemaGraph.addVertex(scalarVertex);
        schemaGraph.addType(scalarType.getName(), scalarVertex);
        this.createAppliedDirectives(scalarVertex, scalarType.getDirectives(), schemaGraph);
    }

    private void newInterface(GraphQLInterfaceType interfaceType, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex interfaceVertex = new Vertex("Interface", this.debugPrefix + String.valueOf(this.counter++));
        interfaceVertex.setBuiltInType(isIntrospectionNode);
        interfaceVertex.add("name", interfaceType.getName());
        interfaceVertex.add("description", this.desc(interfaceType.getDescription()));
        for (GraphQLFieldDefinition fieldDefinition : interfaceType.getFieldDefinitions()) {
            Vertex newFieldVertex = this.newField(fieldDefinition, schemaGraph, isIntrospectionNode);
            schemaGraph.addVertex(newFieldVertex);
            schemaGraph.addEdge(new Edge(interfaceVertex, newFieldVertex));
        }
        schemaGraph.addVertex(interfaceVertex);
        schemaGraph.addType(interfaceType.getName(), interfaceVertex);
        this.createAppliedDirectives(interfaceVertex, interfaceType.getDirectives(), schemaGraph);
    }

    private void newEnum(GraphQLEnumType enumType, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex enumVertex = new Vertex("Enum", this.debugPrefix + String.valueOf(this.counter++));
        enumVertex.setBuiltInType(isIntrospectionNode);
        enumVertex.add("name", enumType.getName());
        enumVertex.add("description", this.desc(enumType.getDescription()));
        for (GraphQLEnumValueDefinition enumValue : enumType.getValues()) {
            Vertex enumValueVertex = new Vertex("EnumValue", this.debugPrefix + String.valueOf(this.counter++));
            enumValueVertex.setBuiltInType(isIntrospectionNode);
            enumValueVertex.add("name", enumValue.getName());
            schemaGraph.addVertex(enumValueVertex);
            schemaGraph.addEdge(new Edge(enumVertex, enumValueVertex));
            this.createAppliedDirectives(enumValueVertex, enumValue.getDirectives(), schemaGraph);
        }
        schemaGraph.addVertex(enumVertex);
        schemaGraph.addType(enumType.getName(), enumVertex);
        this.createAppliedDirectives(enumVertex, enumType.getDirectives(), schemaGraph);
    }

    private void newUnion(GraphQLUnionType unionType, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex unionVertex = new Vertex("Union", this.debugPrefix + String.valueOf(this.counter++));
        unionVertex.setBuiltInType(isIntrospectionNode);
        unionVertex.add("name", unionType.getName());
        unionVertex.add("description", this.desc(unionType.getDescription()));
        schemaGraph.addVertex(unionVertex);
        schemaGraph.addType(unionType.getName(), unionVertex);
        this.createAppliedDirectives(unionVertex, unionType.getDirectives(), schemaGraph);
    }

    private void newInputObject(GraphQLInputObjectType inputObject, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex inputObjectVertex = new Vertex("InputObject", this.debugPrefix + String.valueOf(this.counter++));
        inputObjectVertex.setBuiltInType(isIntrospectionNode);
        inputObjectVertex.add("name", inputObject.getName());
        inputObjectVertex.add("description", this.desc(inputObject.getDescription()));
        for (GraphQLInputObjectField inputObjectField : inputObject.getFieldDefinitions()) {
            Vertex newInputField = this.newInputField(inputObjectField, schemaGraph, isIntrospectionNode);
            Edge newEdge = new Edge(inputObjectVertex, newInputField);
            schemaGraph.addEdge(newEdge);
        }
        schemaGraph.addVertex(inputObjectVertex);
        schemaGraph.addType(inputObject.getName(), inputObjectVertex);
        this.createAppliedDirectives(inputObjectVertex, inputObject.getDirectives(), schemaGraph);
    }

    private void createAppliedDirectives(Vertex from, List<GraphQLDirective> appliedDirectives, SchemaGraph schemaGraph) {
        LinkedHashMap<String, Integer> countByName = new LinkedHashMap<String, Integer>();
        for (GraphQLDirective appliedDirective : appliedDirectives) {
            Vertex appliedDirectiveVertex = new Vertex("AppliedDirective", this.debugPrefix + String.valueOf(this.counter++));
            appliedDirectiveVertex.add("name", appliedDirective.getName());
            for (GraphQLArgument appliedArgument : appliedDirective.getArguments()) {
                if (!appliedArgument.hasSetValue()) continue;
                Vertex appliedArgumentVertex = new Vertex("AppliedArgument", this.debugPrefix + String.valueOf(this.counter++));
                appliedArgumentVertex.add("name", appliedArgument.getName());
                appliedArgumentVertex.add("value", AstPrinter.printAst(ValuesResolver.valueToLiteral(appliedArgument.getArgumentValue(), appliedArgument.getType(), GraphQLContext.getDefault(), Locale.getDefault())));
                schemaGraph.addVertex(appliedArgumentVertex);
                schemaGraph.addEdge(new Edge(appliedDirectiveVertex, appliedArgumentVertex));
            }
            schemaGraph.addVertex(appliedDirectiveVertex);
            Integer count = countByName.getOrDefault(appliedDirective.getName(), 0);
            schemaGraph.addEdge(new Edge(from, appliedDirectiveVertex, String.valueOf(count)));
            countByName.put(appliedDirective.getName(), count + 1);
        }
    }

    private void newDirective(GraphQLDirective directive, SchemaGraph schemaGraph) {
        Vertex directiveVertex = new Vertex("Directive", this.debugPrefix + String.valueOf(this.counter++));
        directiveVertex.add("name", directive.getName());
        directiveVertex.add("repeatable", directive.isRepeatable());
        directiveVertex.add("locations", directive.validLocations());
        boolean graphqlSpecified = DirectiveInfo.isGraphqlSpecifiedDirective(directive.getName());
        directiveVertex.setBuiltInType(graphqlSpecified);
        directiveVertex.add("description", this.desc(directive.getDescription()));
        for (GraphQLArgument argument : directive.getArguments()) {
            Vertex argumentVertex = this.newArgument(argument, schemaGraph, graphqlSpecified);
            schemaGraph.addVertex(argumentVertex);
            schemaGraph.addEdge(new Edge(directiveVertex, argumentVertex));
        }
        schemaGraph.addDirective(directive.getName(), directiveVertex);
        schemaGraph.addVertex(directiveVertex);
    }

    private Vertex newInputField(GraphQLInputObjectField inputField, SchemaGraph schemaGraph, boolean isIntrospectionNode) {
        Vertex vertex = new Vertex("InputField", this.debugPrefix + String.valueOf(this.counter++));
        schemaGraph.addVertex(vertex);
        vertex.setBuiltInType(isIntrospectionNode);
        vertex.add("name", inputField.getName());
        vertex.add("description", this.desc(inputField.getDescription()));
        this.createAppliedDirectives(vertex, inputField.getDirectives(), schemaGraph);
        return vertex;
    }

    private String desc(String desc) {
        return desc;
    }
}

