/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.Assert;
import graphql.Internal;
import graphql.schema.validation.SchemaValidationErrorClassification;
import graphql.schema.validation.SchemaValidationErrorType;
import java.util.StringJoiner;

@Internal
public class SchemaValidationError {
    private final SchemaValidationErrorClassification errorClassification;
    private final String description;

    public SchemaValidationError(SchemaValidationErrorType errorClassification, String description) {
        Assert.assertNotNull(errorClassification, () -> "error classification can not be null");
        Assert.assertNotNull(description, () -> "error description can not be null");
        this.errorClassification = errorClassification;
        this.description = description;
    }

    public SchemaValidationErrorClassification getClassification() {
        return this.errorClassification;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return new StringJoiner(", ", SchemaValidationError.class.getSimpleName() + "[", "]").add("errorClassification=" + this.errorClassification).add("description='" + this.description + "'").toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.errorClassification.hashCode();
        result = 31 * result + this.description.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SchemaValidationError)) {
            return false;
        }
        SchemaValidationError that = (SchemaValidationError)other;
        return this.errorClassification.equals(that.errorClassification) && this.description.equals(that.description);
    }
}

