/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.json.JsonIssueContainer;
import manifold.api.json.JsonTransformer;
import manifold.api.json.codegen.IJsonType;
import manifold.api.json.codegen.JsonListType;
import manifold.api.json.codegen.JsonStructureType;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.api.util.JavacDiagnostic;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.json.rt.Json;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.ScriptException;

class Model
extends AbstractSingleFileModel {
    private JsonStructureType _type;
    private JsonIssueContainer _issues;

    Model(IManifoldHost host, String fqn, Set<IFile> files) {
        super(host, fqn, files);
        this.init();
    }

    private void init() {
        Object jsonValue;
        try {
            jsonValue = Json.fromJson(ResourceFileTypeManifold.getContent(this.getFile()));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ScriptException) {
                this._issues = new JsonIssueContainer((ScriptException)cause, this.getFile());
            }
            jsonValue = new DataBindings();
        }
        IJsonType type = JsonTransformer.transformJsonObject(this.getHost(), this.getFile().getBaseName(), null, jsonValue);
        this._type = this.getStructureType(type);
    }

    private JsonStructureType getStructureType(IJsonType type) {
        if (type instanceof JsonListType) {
            return this.getStructureType(((JsonListType)type).getComponentType());
        }
        if (type instanceof JsonStructureType) {
            return (JsonStructureType)type;
        }
        return null;
    }

    public JsonStructureType getType() {
        return this._type;
    }

    @Override
    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        if (this._issues == null || errorHandler == null) {
            return;
        }
        SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
        for (IIssue issue : this._issues.getIssues()) {
            Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            errorHandler.report(new JavacDiagnostic(file, kind, issue.getStartOffset(), issue.getLine(), issue.getColumn(), issue.getMessage()));
        }
    }
}

