/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import manifold.api.host.IModule;
import manifold.ext.rt.ExtensionMethod;
import manifold.ext.rt.RuntimeMethods;
import manifold.ext.rt.api.IProxyFactory_gen;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.rt.api.util.Pair;

public class StaticStructuralTypeProxyGenerator {
    private final String _package;
    private final String _name;
    private final Type _iface;
    private final IModule _module;
    private final Symbol.ClassSymbol _rootClass;
    private Symbol.ClassSymbol _rootClassSymbol;

    private StaticStructuralTypeProxyGenerator(String name, Type iface, Symbol.ClassSymbol rootClass, String extensionPkg, IModule module) {
        this._package = StaticStructuralTypeProxyGenerator.getNamespace(extensionPkg);
        this._name = name;
        this._iface = iface;
        this._rootClass = rootClass;
        this._module = module;
    }

    static Pair<String, String> makeProxy(String name, Type iface, Symbol.ClassSymbol rootClass, String extensionPkg, IModule module) {
        StaticStructuralTypeProxyGenerator gen = new StaticStructuralTypeProxyGenerator(name, iface, rootClass, extensionPkg, module);
        return new Pair<String, String>(gen._package + '.' + gen._name, gen.generateProxy().toString());
    }

    private StringBuilder generateProxy() {
        return new StringBuilder().append("package ").append(this._package).append(";\n\n").append("import ").append(IProxyFactory_gen.class.getTypeName()).append(";\n").append("\n").append("public class ").append(this._name).append(" implements IProxyFactory_gen<").append(this._rootClass.getQualifiedName()).append(", ").append(this._iface.tsym.getQualifiedName()).append(">\n").append("{\n").append("  @Override\n").append("  public ").append(this._iface.tsym.getQualifiedName()).append(" proxy( ").append(this._rootClass.getQualifiedName()).append(" root, Class<").append(this._iface.tsym.getQualifiedName()).append("> cls) {\n").append("    return new Proxy(root);\n").append("  }\n").append("  public static class Proxy implements ").append(this.eraseParams(this._iface)).append(" {\n").append("    private final ").append(this._rootClass.getQualifiedName()).append(" _root;\n").append("    \n").append("    public Proxy(").append(this._rootClass.getQualifiedName()).append(" root) {\n").append("      _root = root;\n").append("    }\n\n").append(this.implementIface(this._iface, this._iface, new HashSet<Type>(), new StringBuilder())).append("  }\n").append("}");
    }

    private String eraseParams(Type iface) {
        if (!(iface instanceof Type.ClassType)) {
            return iface.toString();
        }
        if (!iface.isParameterized()) {
            return iface.toString();
        }
        StringBuilder sb = new StringBuilder(iface.tsym.getQualifiedName()).append('<');
        for (Type param : iface.allparams()) {
            if (sb.charAt(sb.length() - 1) != '<') {
                sb.append(", ");
            }
            sb.append(this.eraseParams(param));
        }
        sb.append('>');
        return sb.toString();
    }

    private static String getNamespace(String extensionPkg) {
        String nspace = extensionPkg;
        if (nspace.startsWith("java.") || nspace.startsWith("javax.")) {
            nspace = "not" + nspace;
        }
        return nspace;
    }

    private String implementIface(Type originalIface, Type iface, Set<Type> visited, StringBuilder sb) {
        if (visited.contains(iface)) {
            return null;
        }
        visited.add(iface);
        for (Type type : ((Symbol.ClassSymbol)iface.tsym).getInterfaces()) {
            this.implementIface(originalIface, type, visited, sb);
        }
        for (Symbol mi : IDynamicJdk.instance().getMembers((Symbol.ClassSymbol)iface.tsym)) {
            if (!(mi instanceof Symbol.MethodSymbol)) continue;
            this.genInterfaceMethodDecl(sb, originalIface, (Symbol.MethodSymbol)mi, this._rootClass);
        }
        return sb.toString();
    }

    private boolean isSynthetic(Symbol.MethodSymbol m) {
        return (m.flags() & 0x1000L) != 0L || (m.flags() & 0x80000000L) != 0L;
    }

    private void genInterfaceMethodDecl(StringBuilder sb, Type iface, Symbol.MethodSymbol mi, Symbol.ClassSymbol rootType) {
        Types types = Types.instance(JavacPlugin.instance().getContext());
        if ((mi = (Symbol.MethodSymbol)mi.asMemberOf(iface, types)).isDefault() && !this.implementsMethod(rootType, mi) || mi.isStatic() || this.isSynthetic(mi)) {
            return;
        }
        if (mi.getAnnotation(ExtensionMethod.class) != null) {
            return;
        }
        if (StaticStructuralTypeProxyGenerator.isObjectMethod(mi)) {
            return;
        }
        String returnType = this.eraseParams(mi.getReturnType());
        sb.append("  public ").append(returnType).append(' ').append(mi.flatName()).append("(");
        java.util.List params = mi.getParameters();
        for (int i = 0; i < ((List)params).size(); ++i) {
            Symbol.VarSymbol pi = (Symbol.VarSymbol)((List)params).get(i);
            sb.append(' ').append(this.eraseParams(pi.type)).append(" p").append(i);
            sb.append(i < ((List)params).size() - 1 ? (char)',' : ' ');
        }
        sb.append(") {\n").append(returnType.equals("void") ? "    " : "    return ").append(this.maybeCastReturnType(mi, returnType, rootType));
        if (!mi.getReturnType().isPrimitive()) {
            sb.append(RuntimeMethods.class.getTypeName()).append(".coerce(");
        }
        if (!this.handleField(sb, mi)) {
            this.handleMethod(sb, mi, (List<Symbol.VarSymbol>)params);
        }
        if (!mi.getReturnType().isPrimitive()) {
            sb.append(", ").append(mi.getReturnType().tsym.toString()).append(".class);\n");
        } else {
            sb.append(";\n");
        }
        sb.append("  }\n");
    }

    private void handleMethod(StringBuilder sb, Symbol.MethodSymbol mi, List<Symbol.VarSymbol> params) {
        sb.append("_root").append('.').append(mi.flatName()).append("(");
        for (int i = 0; i < params.size(); ++i) {
            sb.append(' ').append("p").append(i).append(i < params.size() - 1 ? (char)',' : ' ');
        }
        sb.append(")");
    }

    private boolean handleField(StringBuilder sb, Symbol.MethodSymbol method) {
        String propertyName = this.getPropertyNameFromGetter(method);
        if (propertyName != null) {
            Symbol.VarSymbol field = this.findField(propertyName, this._rootClass, method.getReturnType(), Variance.Covariant);
            if (field != null) {
                sb.append("_root").append('.').append(field.flatName());
                return true;
            }
        } else {
            Symbol.VarSymbol field;
            propertyName = this.getPropertyNameFromSetter(method);
            if (propertyName != null && (field = this.findField(propertyName, this._rootClass, ((Symbol.VarSymbol)((List)method.getParameters()).get((int)0)).type, Variance.Contravariant)) != null) {
                sb.append("_root").append('.').append(field.flatName()).append(" = p0;\n");
                return true;
            }
        }
        return false;
    }

    private Symbol.VarSymbol findField(String name, Symbol.ClassSymbol rootType, Type returnType, Variance variance) {
        Types types = Types.instance(JavacPlugin.instance().getContext());
        rootType = (Symbol.ClassSymbol)types.erasure((Type)rootType.type).tsym;
        String nameUpper = Character.toUpperCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        String nameLower = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        String nameUnder = '_' + nameLower;
        for (Symbol field : IDynamicJdk.instance().getMembers(rootType)) {
            Type fromType;
            if (!(field instanceof Symbol.VarSymbol)) continue;
            String fieldName = field.flatName().toString();
            Type toType = variance == Variance.Covariant ? returnType : field.type;
            Type type = fromType = variance == Variance.Covariant ? field.type : returnType;
            if (!types.isAssignable(fromType, toType) && !this.arePrimitiveTypesAssignable(toType, fromType) || !fieldName.equals(nameUpper) && !fieldName.equals(nameLower) && !fieldName.equals(nameUnder)) continue;
            return (Symbol.VarSymbol)field;
        }
        return null;
    }

    private boolean arePrimitiveTypesAssignable(Type toType, Type fromType) {
        if (toType == null || fromType == null || !toType.isPrimitive() || !fromType.isPrimitive()) {
            return false;
        }
        if (toType == fromType) {
            return true;
        }
        JavacTypes types = JavacTypes.instance(JavacPlugin.instance().getContext());
        if (toType == types.getPrimitiveType(TypeKind.DOUBLE)) {
            return fromType == types.getPrimitiveType(TypeKind.FLOAT) || fromType == types.getPrimitiveType(TypeKind.INT) || fromType == types.getPrimitiveType(TypeKind.CHAR) || fromType == types.getPrimitiveType(TypeKind.SHORT) || fromType == types.getPrimitiveType(TypeKind.BYTE);
        }
        if (toType == types.getPrimitiveType(TypeKind.FLOAT)) {
            return fromType == types.getPrimitiveType(TypeKind.CHAR) || fromType == types.getPrimitiveType(TypeKind.SHORT) || fromType == types.getPrimitiveType(TypeKind.BYTE);
        }
        if (toType == types.getPrimitiveType(TypeKind.LONG)) {
            return fromType == types.getPrimitiveType(TypeKind.INT) || fromType == types.getPrimitiveType(TypeKind.CHAR) || fromType == types.getPrimitiveType(TypeKind.SHORT) || fromType == types.getPrimitiveType(TypeKind.BYTE);
        }
        if (toType == types.getPrimitiveType(TypeKind.INT)) {
            return fromType == types.getPrimitiveType(TypeKind.SHORT) || fromType == types.getPrimitiveType(TypeKind.CHAR) || fromType == types.getPrimitiveType(TypeKind.BYTE);
        }
        if (toType == types.getPrimitiveType(TypeKind.SHORT)) {
            return fromType == types.getPrimitiveType(TypeKind.BYTE);
        }
        return false;
    }

    private String getPropertyNameFromGetter(Symbol.MethodSymbol method) {
        java.util.List params = method.getParameters();
        if (!((List)params).isEmpty()) {
            return null;
        }
        String name = method.flatName().toString();
        String propertyName = null;
        JavacTypes types = JavacTypes.instance(JavacPlugin.instance().getContext());
        for (String prefix : Arrays.asList("get", "is")) {
            if (name.length() <= prefix.length() || !name.startsWith(prefix)) continue;
            if (prefix.equals("is") && !method.getReturnType().equals(types.getPrimitiveType(TypeKind.BOOLEAN)) && !method.getReturnType().tsym.getQualifiedName().toString().equals(Boolean.class.getTypeName()) || this.hasPotentialMethod(this.getRootClassSymbol(), name, ((List)method.getParameters()).length())) break;
            propertyName = name.substring(prefix.length());
            char firstChar = propertyName.charAt(0);
            if (firstChar == '_' && propertyName.length() > 1) {
                propertyName = propertyName.substring(1);
                continue;
            }
            if (!Character.isAlphabetic(firstChar) || Character.isUpperCase(firstChar)) continue;
            propertyName = null;
            break;
        }
        return propertyName;
    }

    private String getPropertyNameFromSetter(Symbol.MethodSymbol method) {
        JavacTypes types = JavacTypes.instance(JavacPlugin.instance().getContext());
        if (!method.getReturnType().equals(types.getNoType(TypeKind.VOID))) {
            return null;
        }
        java.util.List params = method.getParameters();
        if (((List)params).size() != 1) {
            return null;
        }
        String name = method.flatName().toString();
        String propertyName = null;
        if (name.length() > "set".length() && name.startsWith("set")) {
            if (this.hasPotentialMethod(this.getRootClassSymbol(), name, ((List)method.getParameters()).size())) {
                return null;
            }
            propertyName = name.substring("set".length());
            char firstChar = propertyName.charAt(0);
            if (firstChar == '_' && propertyName.length() > 1) {
                propertyName = propertyName.substring(1);
            } else if (Character.isAlphabetic(firstChar) && !Character.isUpperCase(firstChar)) {
                propertyName = null;
            }
        }
        return propertyName;
    }

    private boolean hasPotentialMethod(Symbol.ClassSymbol rootClassSymbol, String name, int paramCount) {
        if (rootClassSymbol == null || rootClassSymbol instanceof NoType) {
            return false;
        }
        for (Symbol member : IDynamicJdk.instance().getMembers(rootClassSymbol, e -> e.flatName().toString().equals(name))) {
            Symbol.MethodSymbol methodSym = (Symbol.MethodSymbol)member;
            if (((List)methodSym.getParameters()).size() != paramCount) continue;
            return true;
        }
        if (this.hasPotentialMethod((Symbol.ClassSymbol)rootClassSymbol.getSuperclass().tsym, name, paramCount)) {
            return true;
        }
        for (Type iface : rootClassSymbol.getInterfaces()) {
            if (!this.hasPotentialMethod((Symbol.ClassSymbol)iface.tsym, name, paramCount)) continue;
            return true;
        }
        return false;
    }

    private Symbol.ClassSymbol getRootClassSymbol() {
        if (this._rootClassSymbol == null) {
            ClassSymbols classSymbols = ClassSymbols.instance(this._module);
            this._rootClassSymbol = classSymbols.getClassSymbol(JavacPlugin.instance().getJavacTask(), this._rootClass.getQualifiedName().toString()).getFirst();
        }
        return this._rootClassSymbol;
    }

    public static boolean isObjectMethod(Symbol.MethodSymbol mi) {
        java.util.List paramTypes = null;
        block0: for (Method objMi : Object.class.getMethods()) {
            Parameter[] objParams;
            if (!objMi.getName().equals(mi.flatName().toString())) continue;
            if (paramTypes == null) {
                paramTypes = mi.getParameters();
            }
            if ((objParams = objMi.getParameters()).length == ((List)paramTypes).size()) {
                for (int i = 0; i < objParams.length; ++i) {
                    if (!((Symbol.VarSymbol)((List)paramTypes).get((int)i)).type.tsym.getQualifiedName().toString().equals(objParams[i].getType().getCanonicalName())) continue block0;
                }
            }
            return true;
        }
        return false;
    }

    private boolean implementsMethod(Symbol.ClassSymbol type, Symbol.MethodSymbol mi) {
        return this.ghettoImplementsMethod(type, mi);
    }

    private boolean ghettoImplementsMethod(Symbol.ClassSymbol sym, Symbol.MethodSymbol mi) {
        Types types = Types.instance(JavacPlugin.instance().getContext());
        for (Symbol m : IDynamicJdk.instance().getMembersByName(sym, (Name)mi.getSimpleName())) {
            if (!(m instanceof Symbol.MethodSymbol)) continue;
            java.util.List params = ((Symbol.MethodSymbol)m).getParameters();
            java.util.List miParams = mi.getParameters();
            if (((List)params).size() != ((List)miParams).size()) continue;
            int paramsSize = ((List)params).size();
            for (int i = 0; i < paramsSize; ++i) {
                Symbol.VarSymbol param = (Symbol.VarSymbol)((List)params).get(i);
                if (types.isAssignable(((Symbol.VarSymbol)((List)miParams).get((int)i)).type, param.type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String maybeCastReturnType(Symbol.MethodSymbol mi, String returnType, Symbol.ClassSymbol rootType) {
        return !returnType.equals("void") ? "(" + returnType + ")" : "";
    }

    static enum Variance {
        Covariant,
        Contravariant;

    }
}

