/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.type.ISelfCompiledFile;
import manifold.internal.javac.SourceSupplier;
import manifold.util.concurrent.LocklessLazyVar;

public class GeneratedJavaStubFileObject
extends SimpleJavaFileObject
implements ISelfCompiledFile {
    private String _name;
    private long _timestamp;
    private SourceSupplier _sourceSupplier;
    private LocklessLazyVar<String> _src = LocklessLazyVar.make(() -> this._sourceSupplier.getSource());
    private LocklessLazyVar<Boolean> _isFragment = LocklessLazyVar.make(() -> this.getResourceFiles().stream().anyMatch(f -> f instanceof IFileFragment));
    private static Boolean _dumpSource;

    public GeneratedJavaStubFileObject(String name, SourceSupplier sourceSupplier) {
        super(URI.create("genstub:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
        this._name = name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension;
        this._timestamp = System.currentTimeMillis();
        this._sourceSupplier = sourceSupplier;
    }

    @Override
    public URI toUri() {
        return URI.create("genstub:///" + this.getName());
    }

    @Override
    public String getName() {
        return this._name;
    }

    public boolean isPrimary() {
        return this._sourceSupplier.isPrimary();
    }

    @Override
    public boolean isSelfCompile(String fqn) {
        return this._sourceSupplier.isSelfCompile(fqn);
    }

    @Override
    public void parse(String fqn) {
        this._sourceSupplier.parse(fqn);
    }

    @Override
    public byte[] compile(String fqn) {
        return this._sourceSupplier.compile(fqn);
    }

    @Override
    public InputStream openInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream openOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        String source = this._src.get();
        this.maybeDumpSource(source);
        return source;
    }

    private void maybeDumpSource(String source) {
        if (this.shouldDumpSource()) {
            System.out.println("\n================\n");
            System.out.println(this.getName());
            System.out.println("\n================\n");
            int[] line = new int[]{1};
            String code = Arrays.stream(source.split("\n")).map(s -> {
                int n = line[0];
                line[0] = n + 1;
                return n + ":  " + s + "\n";
            }).reduce(String::concat).orElse("");
            System.out.println(code);
        }
    }

    private boolean shouldDumpSource() {
        return _dumpSource == null ? (_dumpSource = Boolean.valueOf(!System.getProperty("manifold.dump.source", "").isEmpty())) : _dumpSource;
    }

    @Override
    public Writer openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return this._timestamp;
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (!(o instanceof GeneratedJavaStubFileObject)) {
            return false;
        }
        return this._name.equals(((GeneratedJavaStubFileObject)o).getName());
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.SOURCE;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return !simpleName.equals("module-info") && !simpleName.equals("package-info");
    }

    public boolean isFileFragment() {
        return this._isFragment.get();
    }

    public IFileFragment getFileFragment() {
        return this.getResourceFiles().stream().filter(f -> f instanceof IFileFragment).findFirst().orElse(null);
    }

    public Set<IFile> getResourceFiles() {
        return this._sourceSupplier.getResourceFiles();
    }
}

